/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.util.ObjectUtils;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.messages.MaterialThemeBundle;
import com.mixpanel.mixpanelapi.ClientDelivery;
import com.mixpanel.mixpanelapi.MessageBuilder;
import com.mixpanel.mixpanelapi.MixpanelAPI;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.json.JSONException;
import org.json.JSONObject;

public final class MTAnalytics {
    @NonNls
    public static final String CONFIG = "ConfigV2";
    @NonNls
    public static final String UPDATE_NOTIFICATION = "Notification";
    @NonNls
    public static final String RECOMMENDED_HEIGHT = "RecommendedTabHeight";
    @NonNls
    public static final String CHANGE_WALLPAPER = "ChangeWallpaper";
    @NonNls
    public static final String REMOVE_WALLPAPER = "RemoveWallpaper";
    @NonNls
    public static final String COMPACT_DROPDOWNS = "CompactDropdowns";
    @NonNls
    public static final String COMPACT_SIDEBAR = "CompactSidebar";
    @NonNls
    public static final String COMPACT_STATUSBAR = "CompactStatusBar";
    @NonNls
    public static final String COMPACT_MENUS = "CompactMenus";
    @NonNls
    public static final String SHOW_WIZARD = "ShowWizard";
    @NonNls
    public static final String CONTRAST_MODE = "ContrastMode";
    @NonNls
    public static final String HIGH_CONTRAST = "HighContrast";
    @NonNls
    public static final String MATERIAL_FONTS = "MaterialFonts";
    @NonNls
    public static final String OVERRIDE_ACCENT = "OverrideAccent";
    @NonNls
    public static final String COLORED_DIRS = "ColoredDirs";
    @NonNls
    public static final String STATUSBAR_THEME = "StatusBarTheme";
    @NonNls
    public static final String UPPERCASE_TABS = "UppercaseTabs";
    @NonNls
    public static final String ACCENT = "AccentColor";
    @NonNls
    public static final String ACCENT_MODE = "AccentMode";
    @NonNls
    public static final String INDICATOR_STYLE = "IndicatorStyle";
    @NonNls
    public static final String SELECT_THEME = "SelectTheme";
    @NonNls
    public static final String HELP = "Help";
    @NonNls
    public static final String COMPACT_TABLES = "CompactTables";
    @NonNls
    public static final String TAB_HIGHLIGHT_POSITION = "TabHighlightPosition";
    @NonNls
    public static final String MATERIAL_WALLPAPERS = "Material Wallpapers";
    @NonNls
    public static final String PROJECT_FRAME = "ProjectFrame";
    @NonNls
    private static final String MIXPANEL_KEY = "mixpanelKey";
    private final MessageBuilder messageBuilder = new MessageBuilder((String)ObjectUtils.notNull((Object)System.getenv("mixpanelKey"), (Object)MaterialThemeBundle.message("mixpanel.key", new Object[0])));
    private final MixpanelAPI mixpanel = new MixpanelAPI();
    private final String userId = MTConfig.getInstance().getUserId();
    private boolean isOffline = false;

    public MTAnalytics() {
        ApplicationManager.getApplication().executeOnPooledThread(this::ping);
    }

    public static MTAnalytics getInstance() {
        return (MTAnalytics)ServiceManager.getService(MTAnalytics.class);
    }

    void initAnalytics() {
        this.identify();
        try {
            this.trackWithData(CONFIG, MTConfig.getInstance().asJson());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void track(String event) {
        if (MTConfig.getInstance().isDisallowDataCollection() || this.isOffline) {
            return;
        }
        try {
            JSONObject sentEvent = this.messageBuilder.event(this.userId, event, null);
            ClientDelivery delivery = new ClientDelivery();
            delivery.addMessage(sentEvent);
            this.mixpanel.deliver(delivery);
        }
        catch (IOException e) {
            this.isOffline = true;
        }
    }

    void trackWithData(String event, JSONObject props) {
        if (MTConfig.getInstance().isDisallowDataCollection() || this.isOffline) {
            return;
        }
        try {
            JSONObject sentEvent = this.messageBuilder.event(this.userId, event, props);
            ClientDelivery delivery = new ClientDelivery();
            delivery.addMessage(sentEvent);
            this.mixpanel.deliver(delivery);
        }
        catch (IOException e) {
            this.isOffline = true;
        }
    }

    public void trackValue(String event, Object value) {
        try {
            JSONObject props = new JSONObject();
            props.put(event, value);
            this.trackWithData(event, props);
        }
        catch (JSONException e) {
            this.isOffline = true;
        }
    }

    private void identify() {
        if (MTConfig.getInstance().isDisallowDataCollection() || this.isOffline) {
            return;
        }
        try {
            JSONObject props = new JSONObject();
            props.put("IDE", (Object)ApplicationNamesInfo.getInstance().getFullProductName());
            props.put("IDEVersion", ApplicationInfo.getInstance().getBuild().getBaselineVersion());
            props.put("version", (Object)MTConfig.getInstance().getVersion());
            JSONObject update = this.messageBuilder.set(this.userId, props);
            this.mixpanel.sendMessage(update);
        }
        catch (IOException | JSONException e) {
            this.isOffline = true;
        }
    }

    private void ping() {
        if (MTConfig.getInstance().isDisallowDataCollection() || this.isOffline) {
            return;
        }
        try {
            JSONObject props = new JSONObject();
            JSONObject update = this.messageBuilder.set(this.userId, props);
            this.mixpanel.sendMessage(update);
        }
        catch (IOException e) {
            this.isOffline = true;
        }
    }
}

