/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea;

import com.intellij.ui.ColorUtil;
import com.intellij.util.SVGLoader;
import com.mallowigi.idea.MTConfig;
import java.awt.Color;
import javax.swing.plaf.ColorUIResource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MTAccentColorPatcher
implements SVGLoader.SvgElementColorPatcherProvider {
    private static final MTConfig CONFIG = MTConfig.getInstance();
    @NonNls
    @Nullable
    private static Color accentColor = MTAccentColorPatcher.getAccentColor();
    private static ColorUIResource themeColor = MTAccentColorPatcher.getThemeColor();

    private static ColorUIResource getAccentColor() {
        return new ColorUIResource(ColorUtil.fromHex((String)CONFIG.getAccentColor()));
    }

    private static ColorUIResource getThemeColor() {
        return new ColorUIResource(CONFIG.getSelectedTheme().getTheme().getPrimaryColor());
    }

    MTAccentColorPatcher() {
        MTAccentColorPatcher.refreshColors();
    }

    private static void refreshColors() {
        accentColor = MTAccentColorPatcher.getAccentColor();
        themeColor = MTAccentColorPatcher.getThemeColor();
    }

    public static void refreshAccentColor(ColorUIResource tint) {
        accentColor = tint;
    }

    public static void refreshThemeColor(ColorUIResource theme) {
        themeColor = theme;
    }

    @NotNull
    @ApiStatus.Internal
    public final SVGLoader.SvgElementColorPatcher forPath(@Nullable String path) {
        return new SVGLoader.SvgElementColorPatcher(){

            public void patchColors(@NonNls Element svg) {
                String accentProp = svg.getAttribute("accent");
                String themeProp = svg.getAttribute("theme");
                String accentHexColor = MTAccentColorPatcher.getColorHex(accentColor);
                String themeHexColor = MTAccentColorPatcher.getColorHex(themeColor);
                if ("true".equals(accentProp) || "fill".equals(accentProp)) {
                    svg.setAttribute("fill", "#" + accentHexColor);
                } else if ("stroke".equals(accentProp)) {
                    svg.setAttribute("stroke", "#" + accentHexColor);
                } else if ("true".equals(themeProp) || "fill".equals(themeProp)) {
                    svg.setAttribute("fill", "#" + themeHexColor);
                } else if ("stroke".equals(themeProp)) {
                    svg.setAttribute("stroke", "#" + themeHexColor);
                }
                NodeList nodes = svg.getChildNodes();
                int length = nodes.getLength();
                for (int i = 0; i < length; ++i) {
                    Node item = nodes.item(i);
                    if (!(item instanceof Element)) continue;
                    this.patchColors((Element)item);
                }
            }

            public byte @Nullable [] digest() {
                return null;
            }
        };
    }

    private static String getColorHex(Color color) {
        return ColorUtil.toHex((Color)color);
    }
}

