/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.toolwindow;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.internal.statistic.toolwindow.StatisticsGroupHyperlinkInfo;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\"\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/internal/statistic/toolwindow/StatisticsEventLogFilter;", "Lcom/intellij/execution/filters/Filter;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "groupIdToLine", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/HashMap;)V", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "entireLength", "Companion", "intellij.platform.statistics.devkit"})
public final class StatisticsEventLogFilter
implements Filter {
    private final VirtualFile file;
    private final HashMap<String, Integer> groupIdToLine;
    @NotNull
    private static final Pattern LOG_PATTERN;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Matcher matcher = LOG_PATTERN.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        String groupIdKey = "groupId";
        String groupId = matcher.group(groupIdKey);
        Integer lineNumber = this.groupIdToLine.get(groupId);
        if (lineNumber == null) {
            return null;
        }
        String eventId = matcher.group("event");
        String eventData = matcher.group("eventData");
        int groupIdStart = entireLength - line.length();
        int n = matcher.start(groupIdKey) + groupIdStart;
        int n2 = matcher.end(groupIdKey) + groupIdStart;
        String string = groupId;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"groupId");
        String string2 = eventId;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"eventId");
        String string3 = eventData;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"eventData");
        return new Filter.Result(n, n2, (HyperlinkInfo)new StatisticsGroupHyperlinkInfo(string, string2, string3, this.file, lineNumber));
    }

    public StatisticsEventLogFilter(@NotNull VirtualFile file, @NotNull HashMap<String, Integer> groupIdToLine2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(groupIdToLine2, (String)"groupIdToLine");
        this.file = file;
        this.groupIdToLine = groupIdToLine2;
    }

    static {
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile("\\[\"(?<groupId>.*)\", v\\d+]: \"(?<event>.*)\" (?<count>\\(count=\\d+\\))?\\s*(?<eventData>.*)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(\n      \"\u2026))?\\\\s*(?<eventData>.*)\")");
        LOG_PATTERN = pattern;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/internal/statistic/toolwindow/StatisticsEventLogFilter$Companion;", "", "()V", "LOG_PATTERN", "Ljava/util/regex/Pattern;", "getLOG_PATTERN", "()Ljava/util/regex/Pattern;", "intellij.platform.statistics.devkit"})
    public static final class Companion {
        @NotNull
        public final Pattern getLOG_PATTERN() {
            return LOG_PATTERN;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

