/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions;

import com.google.gson.GsonBuilder;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.internal.statistic.eventLog.events.EventsSchemeBuilder;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/internal/statistic/actions/GenerateEventsScheme;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "openInScratch", "project", "Lcom/intellij/openapi/project/Project;", "text", "", "update", "event", "intellij.platform.statistics.devkit"})
public final class GenerateEventsScheme
extends AnAction {
    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
        presentation.setEnabled(StatisticsRecorderUtil.isTestModeEnabled((String)"FUS"));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String text;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        List eventsScheme = EventsSchemeBuilder.buildEventsScheme();
        String string = text = new GsonBuilder().setPrettyPrinting().create().toJson((Object)eventsScheme);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        this.openInScratch(project2, string);
    }

    private final void openInScratch(Project project, String text) {
        String string = PathUtil.makeFileName((String)"statistics_events_scheme", (String)"json");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathUtil.makeFileName(\"s\u2026s_events_scheme\", \"json\")");
        String fileName = string;
        VirtualFile scratchFile = ScratchRootType.getInstance().createScratchFile(project, fileName, (Language)JsonLanguage.INSTANCE, text);
        if (scratchFile != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(project, scratchFile){
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $scratchFile;

                public final void run() {
                    FileEditorManager.getInstance((Project)this.$project).openFile(this.$scratchFile, true);
                }
                {
                    this.$project = project;
                    this.$scratchFile = virtualFile;
                }
            });
        }
    }
}

