/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.php.performanceTesting;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodDialog;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodHandler;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodParameterInfo;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodSettings;
import com.jetbrains.php.refactoring.extractMethod.PhpParametersFolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class PhpExtractMethodCommand
extends AbstractCommand {
    public static final String PREFIX = "%phpExtractMethod";

    public PhpExtractMethodCommand(@NotNull String text, int line) {
        if (text == null) {
            PhpExtractMethodCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            PhpExtractMethodCommand.$$$reportNull$$$0(1);
        }
        Project project = context.getProject();
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        ApplicationManager.getApplication().invokeLater(() -> this.lambda$_execute$0(project, (ActionCallback)actionCallback));
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            PhpExtractMethodCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private /* synthetic */ void lambda$_execute$0(final Project project, ActionCallback actionCallback) {
        final Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null) {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (psiFile != null) {
                final int errorsBefore = DaemonCodeAnalyzerImpl.getHighlights((Document)editor.getDocument(), (HighlightSeverity)HighlightSeverity.ERROR, (Project)project).size();
                new ExtractMethodConfigurator(project).invoke(project, editor, psiFile);
                final Disposable listenerDisposable = Disposer.newDisposable();
                MessageBusConnection busConnection = project.getMessageBus().connect(listenerDisposable);
                busConnection.subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, (Object)new DaemonCodeAnalyzer.DaemonListener(){

                    public void daemonFinished() {
                        int errorsAfter = DaemonCodeAnalyzerImpl.getHighlights((Document)editor.getDocument(), (HighlightSeverity)HighlightSeverity.ERROR, (Project)project).size();
                        if (errorsBefore > errorsAfter) {
                            throw new RuntimeException("Errors are found after refactoring");
                        }
                        Disposer.dispose((Disposable)listenerDisposable);
                    }
                });
                actionCallback.setDone();
            } else {
                actionCallback.reject("PSI file is null");
            }
        } else {
            actionCallback.reject("Editor is null");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/php/performanceTesting/PhpExtractMethodCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/php/performanceTesting/PhpExtractMethodCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExtractMethodConfigurator
    extends PhpExtractMethodHandler {
        private final Project myProject;

        private ExtractMethodConfigurator(Project project) {
            this.myProject = project;
        }

        @Override
        protected PhpExtractMethodSettings getSettings(final @NotNull PhpExtractMethodCodeFragment fragment, final @NotNull Set<PhpPsiElement> inputVariables, final @NotNull Set<PhpPsiElement> outputVariables) {
            if (fragment == null) {
                ExtractMethodConfigurator.$$$reportNull$$$0(0);
            }
            if (inputVariables == null) {
                ExtractMethodConfigurator.$$$reportNull$$$0(1);
            }
            if (outputVariables == null) {
                ExtractMethodConfigurator.$$$reportNull$$$0(2);
            }
            return new PhpExtractMethodSettings(){

                @Override
                @NotNull
                public Set<PhpPsiElement> getOutputVariables() {
                    Set set = outputVariables;
                    if (set == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return set;
                }

                @Override
                @NotNull
                public Set<PhpPsiElement> getInputVariables() {
                    Set set = inputVariables;
                    if (set == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return set;
                }

                @Override
                public boolean isPassOutputByReference() {
                    return false;
                }

                @Override
                public boolean isReplaceBreakContinueWithReturn() {
                    return false;
                }

                @Override
                public boolean generatePhpDoc() {
                    return true;
                }

                @Override
                @NotNull
                public PhpParametersFolder getParameterFolder() {
                    return new PhpParametersFolder();
                }

                @Override
                @NotNull
                public String getName() {
                    return "dummy";
                }

                @Override
                @NotNull
                public List<PhpExtractMethodParameterInfo> getParameters() {
                    List<PhpExtractMethodParameterInfo> parameters = PhpExtractMethodDialog.getParameterItems(fragment, inputVariables, outputVariables, this.getParameterFolder());
                    List<PhpExtractMethodParameterInfo> parameterForCurrentMode = this.filterParametersByReturnType(parameters, this.isPassOutputByReference());
                    for (PhpExtractMethodParameterInfo parameter : parameterForCurrentMode) {
                        parameter.setIsReturnByRefMode(myProject, this.isPassOutputByReference());
                    }
                    List<PhpExtractMethodParameterInfo> list = parameterForCurrentMode;
                    if (list == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return list;
                }

                @Override
                public // Could not load outer class - annotation placement on inner may be incorrect
                 @Nullable PhpModifier.Access getVisibility() {
                    return null;
                }

                @Override
                public boolean isDeclareStatic() {
                    return false;
                }

                @Override
                public boolean useTrailingCommaInParametersList() {
                    return false;
                }

                @Override
                @NotNull
                public String getFunctionBody() {
                    String string = fragment.generateCodeText();
                    if (string == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return string;
                }

                @Override
                @NotNull
                public String getReturnType() {
                    return "";
                }

                List<PhpExtractMethodParameterInfo> filterParametersByReturnType(List<? extends PhpExtractMethodParameterInfo> parameters, boolean returnByRef) {
                    ArrayList<PhpExtractMethodParameterInfo> parameterForReturnType = new ArrayList<PhpExtractMethodParameterInfo>(parameters.size());
                    for (PhpExtractMethodParameterInfo phpExtractMethodParameterInfo : parameters) {
                        if (!phpExtractMethodParameterInfo.isEnabled(returnByRef)) continue;
                        parameterForReturnType.add(phpExtractMethodParameterInfo);
                    }
                    return parameterForReturnType;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "org/jetbrains/php/performanceTesting/PhpExtractMethodCommand$ExtractMethodConfigurator$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getOutputVariables";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getInputVariables";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getParameters";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFunctionBody";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "inputVariables";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputVariables";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/php/performanceTesting/PhpExtractMethodCommand$ExtractMethodConfigurator";
            objectArray[2] = "getSettings";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

