/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.smarty.lang.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.smarty.SmartyBundle;
import com.jetbrains.smarty.SmartyCompletionContributor;
import com.jetbrains.smarty.lang.SmartyTokenTypes;
import com.jetbrains.smarty.lang.lexer.SmartyLexer;
import com.jetbrains.smarty.lang.parser.SmartyExpressionParser;
import com.jetbrains.smarty.lang.psi.SmartyCompositeElementTypes;
import java.util.Collection;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public class SmartyTagsParser
implements PsiParser {
    private final Stack<Tag> myNonUniqueFunctionsStack = new Stack();
    private final Project myProject;

    public SmartyTagsParser(Project project) {
        this.myProject = project;
    }

    public void clearStack() {
        this.closeMarkersForUnclosedTags();
    }

    public void parseOneSmartyTagInInnerConstruction(PsiBuilder builder, boolean clearStack) {
        if (builder.getTokenType() == SmartyTokenTypes.START_TAG_START) {
            this.parseOpenTag(builder);
        } else if (builder.getTokenType() == SmartyTokenTypes.END_TAG_START) {
            this.parseCloseTag(builder);
        }
        if (clearStack) {
            this.closeMarkersForUnclosedTags();
        }
    }

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        while (!builder.eof()) {
            if (builder.getTokenType() == SmartyTokenTypes.START_TAG_START) {
                this.parseOpenTag(builder);
                continue;
            }
            if (builder.getTokenType() == SmartyTokenTypes.END_TAG_START) {
                this.parseCloseTag(builder);
                continue;
            }
            builder.advanceLexer();
        }
        this.closeMarkersForUnclosedTags();
        marker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            SmartyTagsParser.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    private void closeMarkersForUnclosedTags() {
        while (!this.myNonUniqueFunctionsStack.empty()) {
            Tag openTag = this.myNonUniqueFunctionsStack.pop();
            if (!SmartyCompletionContributor.isPredefinedFunction(openTag.getName())) {
                openTag.getBeginMarker().doneBefore(SmartyTagsParser.getTagType(openTag), openTag.getMarkerOfContent());
            } else {
                openTag.getBeginMarker().doneBefore(SmartyTagsParser.getTagType(openTag), openTag.myMarkerOfContent, SmartyBundle.message("parsing.error.tag.is.not.closed", new Object[0]));
            }
            openTag.getMarkerOfContent().drop();
        }
    }

    private String parseOpenTag(PsiBuilder builder) {
        assert (builder.getTokenType() == SmartyTokenTypes.START_TAG_START);
        boolean pushIntoStack = false;
        String functionName = "";
        PsiBuilder.Marker startTagMarker = builder.mark();
        builder.advanceLexer();
        boolean parseExpression = true;
        if (builder.getTokenType() == SmartyTokenTypes.PREDEFINED_FUNCTION) {
            functionName = builder.getTokenText();
            boolean bl = pushIntoStack = !SmartyCompletionContributor.isPredefinedFunction(functionName) || !SmartyCompletionContributor.isUnique(functionName);
            if (!"if".equals(functionName) && !"elseif".equals(functionName)) {
                parseExpression = false;
                if ("for".equals(functionName)) {
                    SmartyTagsParser.parseForTag(builder);
                } else if ("foreach".equals(functionName)) {
                    PsiBuilder.Marker marker = builder.mark();
                    boolean parseFunction = false;
                    builder.advanceLexer();
                    if (builder.getTokenType() == SmartyTokenTypes.IDENTIFIER) {
                        builder.advanceLexer();
                        if (builder.getTokenType() == SmartyTokenTypes.EQ) {
                            marker.rollbackTo();
                            SmartyTagsParser.parseFunctionTagInner(functionName, builder);
                            parseFunction = true;
                        }
                    }
                    if (!parseFunction) {
                        marker.rollbackTo();
                        if (builder.getTokenType() == SmartyTokenTypes.PREDEFINED_FUNCTION) {
                            builder.advanceLexer();
                            SmartyTagsParser.parseForEachTagInner(builder);
                        }
                    }
                } else if ("while".equals(functionName)) {
                    SmartyTagsParser.parseWhileTag(builder);
                } else {
                    SmartyTagsParser.parseFunctionTagInner(functionName, builder);
                }
            } else {
                builder.advanceLexer();
            }
        } else if (builder.getTokenType() == SmartyTokenTypes.IDENTIFIER) {
            PsiBuilder.Marker tagContentBeginMarker = builder.mark();
            functionName = builder.getTokenText();
            builder.advanceLexer();
            if (builder.getTokenType() == SmartyTokenTypes.COLON_COLON || builder.getTokenType() == SmartyTokenTypes.L_PAR || builder.getTokenType() == SmartyTokenTypes.ARROW || builder.getTokenType() == SmartyTokenTypes.BACK_SLASH) {
                tagContentBeginMarker.rollbackTo();
                if (!SmartyExpressionParser.parseExpressionOrAssignment(builder)) {
                    builder.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
                } else {
                    SmartyTagsParser.parseFlag("nocache", builder);
                }
                parseExpression = false;
                functionName = null;
            } else {
                tagContentBeginMarker.drop();
                SmartyTagsParser.parseModifiers(builder);
                while (!builder.eof() && builder.getTokenType() != SmartyTokenTypes.TAG_END) {
                    if (builder.getTokenType() == SmartyTokenTypes.DOUBLE_QUOTE) {
                        SmartyExpressionParser.parseDoubleQuotedString(builder);
                        continue;
                    }
                    builder.advanceLexer();
                }
                parseExpression = false;
                pushIntoStack = true;
            }
        }
        if (parseExpression && !SmartyExpressionParser.parseExpressionOrAssignment(builder)) {
            builder.error(SmartyBundle.message("parsing.error.empty.tag", new Object[0]));
        } else if (parseExpression) {
            SmartyTagsParser.parseScope(builder);
            while (SmartyTagsParser.parseFlag("nocache", builder) || SmartyTagsParser.parseFlag("nofilter", builder)) {
            }
        }
        if (builder.getTokenType() != SmartyTokenTypes.TAG_END && builder.getTokenType() != SmartyTokenTypes.OR) {
            builder.error(SmartyBundle.message("parsing.error.right.curly.brace.expected", SmartyLexer.getRightDelimiter(this.myProject)));
        } else {
            builder.advanceLexer();
        }
        if (pushIntoStack) {
            this.myNonUniqueFunctionsStack.push(new Tag(functionName != null ? functionName : "", startTagMarker, builder.mark()));
        } else if ("include".equals(functionName)) {
            startTagMarker.done(SmartyCompositeElementTypes.INCLUDE_TAG);
        } else if ("config_load".equals(functionName)) {
            startTagMarker.done(SmartyCompositeElementTypes.CONFIG_LOAD_TAG);
        } else {
            startTagMarker.done(SmartyCompositeElementTypes.TAG);
        }
        return functionName != null ? functionName : "";
    }

    private static boolean parseFlag(String flagName, PsiBuilder builder) {
        if (flagName.equals(builder.getTokenText())) {
            builder.advanceLexer();
            if (builder.getTokenType() == SmartyTokenTypes.EQ) {
                builder.advanceLexer();
                if (builder.getTokenType() == SmartyTokenTypes.BOOLEAN_VALUE) {
                    builder.advanceLexer();
                } else {
                    builder.error(SmartyBundle.message("parsing.value.expected", new Object[0]));
                }
            }
            return true;
        }
        return false;
    }

    private static void parseScope(PsiBuilder builder) {
        if ("scope".equals(builder.getTokenText())) {
            builder.advanceLexer();
            if (builder.getTokenType() == SmartyTokenTypes.EQ) {
                builder.advanceLexer();
                if (!SmartyExpressionParser.parseVariable(builder)) {
                    builder.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
                }
            } else {
                builder.error(SmartyBundle.message("parsing.value.expected", new Object[0]));
            }
        }
    }

    private static void parseForEachTagInner(PsiBuilder builder) {
        SmartyExpressionParser.parseVariable(builder);
        if (builder.getTokenType() == SmartyTokenTypes.AS_KEYWORD) {
            builder.advanceLexer();
        } else {
            builder.error(SmartyBundle.message("parsing.error.as.expected", new Object[0]));
        }
        SmartyExpressionParser.parseVariableDefinition(builder);
        if (builder.getTokenType() == SmartyTokenTypes.ARRAY_ASSIGNMENT) {
            builder.advanceLexer();
            SmartyExpressionParser.parseVariableDefinition(builder);
        }
    }

    private static void parseWhileTag(PsiBuilder builder) {
        builder.advanceLexer();
        SmartyExpressionParser.parseExpressionOrAssignment(builder);
    }

    private static void parseForTag(PsiBuilder builder) {
        int offset = builder.getCurrentOffset();
        builder.advanceLexer();
        boolean isForComplete = false;
        int numberOfAssignments = 0;
        boolean start = true;
        PsiBuilder.Marker mark = builder.mark();
        do {
            if (!start) {
                builder.advanceLexer();
            }
            SmartyExpressionParser.parseExpressionOrAssignment(builder);
            if (builder.getCurrentOffset() == offset) break;
            ++numberOfAssignments;
            start = false;
        } while (builder.getTokenType() == SmartyTokenTypes.COMMA);
        if (builder.getTokenType() != SmartyTokenTypes.TO_KEYWORD || numberOfAssignments != 1) {
            mark.drop();
        }
        if (builder.getTokenType() == SmartyTokenTypes.TO_KEYWORD) {
            if (numberOfAssignments == 1) {
                mark.rollbackTo();
                if (!SmartyExpressionParser.parseDefinitionAndAssignment(builder)) {
                    SmartyExpressionParser.parseExpressionOrAssignment(builder);
                }
            }
            builder.advanceLexer();
            if (!builder.eof() && builder.getTokenType() != SmartyTokenTypes.TAG_END) {
                SmartyExpressionParser.parseExpressionOrAssignment(builder);
                isForComplete = true;
                if (builder.getTokenType() == SmartyTokenTypes.STEP_KEYWORD) {
                    builder.advanceLexer();
                    if (!builder.eof() && builder.getTokenType() != SmartyTokenTypes.TAG_END) {
                        SmartyExpressionParser.parseExpressionOrAssignment(builder);
                    }
                }
            }
        } else if (builder.getTokenType() == SmartyTokenTypes.SEMICOLON) {
            builder.advanceLexer();
            if (!builder.eof() && builder.getTokenType() != SmartyTokenTypes.TAG_END) {
                SmartyExpressionParser.parseExpressionOrAssignment(builder);
                if (builder.getTokenType() != SmartyTokenTypes.SEMICOLON) {
                    builder.error(SmartyBundle.message("parsing.error.semicolon.expected", new Object[0]));
                } else {
                    builder.advanceLexer();
                }
                if (!builder.eof() && builder.getTokenType() != SmartyTokenTypes.TAG_END) {
                    SmartyExpressionParser.parseExpressionOrAssignment(builder);
                    isForComplete = true;
                }
            }
        }
        if (!isForComplete) {
            builder.error(SmartyBundle.message("parsing.error.incomplete.expression", new Object[0]));
        }
        SmartyTagsParser.parseAttributeList("for", builder);
    }

    public static void parseModifiers(PsiBuilder builder) {
        while (builder.getTokenType() == SmartyTokenTypes.OR) {
            PsiBuilder.Marker marker = builder.mark();
            builder.advanceLexer();
            if (builder.getTokenType() == SmartyTokenTypes.SILENCE) {
                builder.advanceLexer();
            }
            if (builder.getTokenType() != SmartyTokenTypes.IDENTIFIER) {
                builder.error(SmartyBundle.message("parsing.error.identifier.expected", new Object[0]));
            } else {
                builder.advanceLexer();
            }
            while (builder.getTokenType() == SmartyTokenTypes.DOT_DOT) {
                builder.advanceLexer();
                SmartyExpressionParser.parseVariable(builder);
            }
            marker.done(SmartyCompositeElementTypes.MODIFIER);
        }
    }

    private void parseCloseTag(PsiBuilder builder) {
        assert (builder.getTokenType() == SmartyTokenTypes.END_TAG_START);
        builder.advanceLexer();
        String functionName = "";
        if (builder.getTokenType() == SmartyTokenTypes.PREDEFINED_FUNCTION || builder.getTokenType() == SmartyTokenTypes.IDENTIFIER) {
            functionName = builder.getTokenText();
            builder.advanceLexer();
        } else {
            builder.error(SmartyBundle.message("parsing.error.function.name.expected", new Object[0]));
        }
        if (builder.getTokenType() != SmartyTokenTypes.TAG_END) {
            builder.error(SmartyBundle.message("parsing.error.right.curly.brace.expected", SmartyLexer.getRightDelimiter(this.myProject)));
        } else {
            builder.advanceLexer();
        }
        boolean canParse = false;
        for (Tag t : this.myNonUniqueFunctionsStack) {
            if (!t.getName().equals(functionName)) continue;
            canParse = true;
            break;
        }
        if (canParse) {
            Tag tag = null;
            while (!this.myNonUniqueFunctionsStack.empty() && !(tag = this.myNonUniqueFunctionsStack.pop()).getName().equals(functionName)) {
                if (!SmartyCompletionContributor.isPredefinedFunction(tag.getName())) {
                    tag.getBeginMarker().doneBefore(SmartyTagsParser.getTagType(tag), tag.getMarkerOfContent());
                } else {
                    tag.getBeginMarker().doneBefore(SmartyTagsParser.getTagType(tag), tag.myMarkerOfContent, SmartyBundle.message("parsing.error.tag.is.not.closed", new Object[0]));
                }
                tag.myMarkerOfContent.drop();
            }
            if (tag != null) {
                tag.getMarkerOfContent().drop();
                tag.getBeginMarker().done(SmartyTagsParser.getTagType(tag));
            }
        } else {
            builder.error(SmartyBundle.message("parsing.error.no.open.tag.specified", new Object[0]));
        }
    }

    private static void parseFunctionTagInner(String functionName, PsiBuilder builder) {
        if (builder.getTokenType() != SmartyTokenTypes.PREDEFINED_FUNCTION && builder.getTokenType() != SmartyTokenTypes.IDENTIFIER) {
            return;
        }
        builder.advanceLexer();
        SmartyTagsParser.parseModifiers(builder);
        SmartyTagsParser.parseAttributeList(functionName, builder);
    }

    private static void parseAttributeList(String functionName, PsiBuilder builder) {
        if (builder.getTokenType() == SmartyTokenTypes.TAG_END) {
            return;
        }
        Collection<SmartyCompletionContributor.Attribute> functionAttributes = SmartyCompletionContributor.getFunctionAttributes(functionName);
        int numberOfRequired = 0;
        for (SmartyCompletionContributor.Attribute attr : functionAttributes) {
            if (!attr.isIsRequired()) continue;
            ++numberOfRequired;
        }
        boolean isAssignmentFirst = false;
        PsiBuilder.Marker mark = builder.mark();
        if (builder.getTokenType() == SmartyTokenTypes.IDENTIFIER) {
            builder.advanceLexer();
            if (builder.getTokenType() == SmartyTokenTypes.EQ) {
                mark.rollbackTo();
                SmartyTagsParser.parseAttribute(functionName, builder);
                isAssignmentFirst = true;
            }
        }
        if (!isAssignmentFirst && numberOfRequired != 0) {
            mark.rollbackTo();
            for (int i = 0; i < numberOfRequired; ++i) {
                PsiBuilder.Marker attributeMarker = builder.mark();
                if (!SmartyExpressionParser.parseVariable(builder)) {
                    attributeMarker.drop();
                    break;
                }
                attributeMarker.done(SmartyCompositeElementTypes.ATTRIBUTE);
            }
        } else if (!isAssignmentFirst) {
            mark.drop();
        }
        while (SmartyTagsParser.parseAttribute(functionName, builder)) {
        }
    }

    private static boolean parseAttribute(String functionName, PsiBuilder builder) {
        if (builder.getTokenType() != SmartyTokenTypes.IDENTIFIER) {
            return false;
        }
        String attributeName = builder.getTokenText();
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() != SmartyTokenTypes.EQ) {
            Set<String> flags = SmartyCompletionContributor.getFunctionFlags(functionName);
            for (String flag : flags) {
                if (!flag.equals(attributeName)) continue;
                if (builder.getTokenType() == SmartyTokenTypes.EQ) {
                    marker.rollbackTo();
                    marker = builder.mark();
                    SmartyTagsParser.parseFlag(flag, builder);
                }
                marker.done(SmartyCompositeElementTypes.ATTRIBUTE);
                return false;
            }
            builder.error(SmartyBundle.message("parsing.error.expected", new Object[0]));
        } else {
            builder.advanceLexer();
            PsiBuilder.Marker valueMarker = builder.mark();
            if (!SmartyExpressionParser.parseArrayDefinition(builder)) {
                if (SmartyExpressionParser.parseExpression(builder)) {
                    valueMarker.done(SmartyCompositeElementTypes.ATTRIBUTE_VALUE);
                } else {
                    valueMarker.drop();
                }
            } else {
                valueMarker.done(SmartyCompositeElementTypes.ATTRIBUTE_VALUE);
            }
        }
        marker.done(SmartyCompositeElementTypes.ATTRIBUTE);
        return true;
    }

    private static IElementType getTagType(@NotNull Tag tag) {
        if (tag == null) {
            SmartyTagsParser.$$$reportNull$$$0(1);
        }
        if ("literal".equalsIgnoreCase(tag.getName())) {
            return SmartyCompositeElementTypes.LITERAL_TAG;
        }
        return SmartyCompositeElementTypes.TAG;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/smarty/lang/parser/SmartyTagsParser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/smarty/lang/parser/SmartyTagsParser";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTagType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Tag {
        @NotNull
        private final String myName;
        private final PsiBuilder.Marker myBeginMarker;
        private final PsiBuilder.Marker myMarkerOfContent;

        private Tag(@NotNull String name, PsiBuilder.Marker beginMarker, PsiBuilder.Marker markerOfContent) {
            if (name == null) {
                Tag.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myBeginMarker = beginMarker;
            this.myMarkerOfContent = markerOfContent;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                Tag.$$$reportNull$$$0(1);
            }
            return string;
        }

        public PsiBuilder.Marker getBeginMarker() {
            return this.myBeginMarker;
        }

        public PsiBuilder.Marker getMarkerOfContent() {
            return this.myMarkerOfContent;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Tag)) {
                return false;
            }
            Tag obj_tag = (Tag)obj;
            return this.myName.equals(obj_tag.myName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/smarty/lang/parser/SmartyTagsParser$Tag";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/smarty/lang/parser/SmartyTagsParser$Tag";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

