/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.smarty.lang.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.smarty.SmartyBundle;
import com.jetbrains.smarty.lang.SmartyTokenTypes;
import com.jetbrains.smarty.lang.parser.SmartyTagsParser;
import com.jetbrains.smarty.lang.psi.SmartyCompositeElementTypes;

public class SmartyExpressionParser {
    public static boolean parseArrayDefinition(PsiBuilder builder) {
        if (builder.getTokenType() != SmartyTokenTypes.L_BRACKET) {
            return false;
        }
        builder.advanceLexer();
        while (true) {
            int offset = builder.getCurrentOffset();
            if (builder.getTokenType() == SmartyTokenTypes.R_BRACKET) break;
            if (!SmartyExpressionParser.parseArrayDefinition(builder)) {
                SmartyExpressionParser.parseExpression(builder);
            }
            if (builder.getTokenType() == SmartyTokenTypes.ARRAY_ASSIGNMENT) {
                builder.advanceLexer();
                if (!SmartyExpressionParser.parseArrayDefinition(builder)) {
                    SmartyExpressionParser.parseExpression(builder);
                }
            }
            if (offset == builder.getCurrentOffset()) {
                builder.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
                break;
            }
            if (builder.getTokenType() != SmartyTokenTypes.COMMA) break;
            builder.advanceLexer();
        }
        if (builder.getTokenType() != SmartyTokenTypes.R_BRACKET) {
            builder.error(SmartyBundle.message("parsing.error.right.square.brace.expected", new Object[0]));
        } else {
            builder.advanceLexer();
        }
        return true;
    }

    public static boolean parseDefinitionAndAssignment(PsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        if (!SmartyExpressionParser.parseVariableDefinition(builder)) {
            mark.rollbackTo();
            return false;
        }
        if (builder.getTokenType() == SmartyTokenTypes.EQ) {
            builder.advanceLexer();
            SmartyExpressionParser.parseRValue(builder);
        }
        mark.drop();
        return true;
    }

    public static void parseRValue(PsiBuilder builder) {
        if (builder.getTokenType() == SmartyTokenTypes.L_BRACKET) {
            SmartyExpressionParser.parseArrayDefinition(builder);
        } else if (!SmartyExpressionParser.parseExpression(builder)) {
            builder.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
        }
    }

    public static boolean parseExpressionOrAssignment(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!SmartyExpressionParser.parseExpression(builder)) {
            expr.drop();
            return false;
        }
        if (builder.getTokenType() == SmartyTokenTypes.EQ) {
            builder.advanceLexer();
            SmartyExpressionParser.parseRValue(builder);
            expr.done(SmartyCompositeElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    public static boolean parseExpression(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!SmartyExpressionParser.parseRelationalExpression(builder)) {
            expr.drop();
            return false;
        }
        while (SmartyTokenTypes.LOGICAL_OPERATIONS.contains(builder.getTokenType())) {
            builder.advanceLexer();
            if (!SmartyExpressionParser.parseRelationalExpression(builder)) {
                builder.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(SmartyCompositeElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        if (builder.getTokenType() == SmartyTokenTypes.QUESTION) {
            builder.advanceLexer();
            if (!SmartyExpressionParser.parseExpression(builder)) {
                builder.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            if (builder.getTokenType() == SmartyTokenTypes.DOT_DOT) {
                builder.advanceLexer();
            } else {
                builder.error(SmartyBundle.message("parsing.error.colon.expected", new Object[0]));
            }
            if (!SmartyExpressionParser.parseExpression(builder)) {
                builder.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
            }
        }
        expr.drop();
        return true;
    }

    private static boolean parseRelationalExpression(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!SmartyExpressionParser.parseAdditiveExpression(builder)) {
            expr.drop();
            return false;
        }
        while (SmartyTokenTypes.RELATIONAL_OPERATIONS.contains(builder.getTokenType())) {
            builder.advanceLexer();
            if (!SmartyExpressionParser.parseAdditiveExpression(builder)) {
                builder.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(SmartyCompositeElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private static boolean parseAdditiveExpression(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!SmartyExpressionParser.parseMultiplicativeExpression(builder)) {
            expr.drop();
            return false;
        }
        while (SmartyTokenTypes.ADDITIVE_OPERATIONS.contains(builder.getTokenType())) {
            builder.advanceLexer();
            if (!SmartyExpressionParser.parseMultiplicativeExpression(builder)) {
                builder.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(SmartyCompositeElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private static boolean parseMultiplicativeExpression(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!SmartyExpressionParser.parseUnaryExpression(builder)) {
            expr.drop();
            return false;
        }
        while (SmartyTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(builder.getTokenType())) {
            builder.advanceLexer();
            if (!SmartyExpressionParser.parseUnaryExpression(builder)) {
                builder.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(SmartyCompositeElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private static boolean parseUnaryExpression(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (SmartyTokenTypes.UNARY_OPERATIONS.contains(tokenType)) {
            PsiBuilder.Marker expr = builder.mark();
            builder.advanceLexer();
            if (!SmartyExpressionParser.parseUnaryExpression(builder)) {
                builder.error(SmartyBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(SmartyCompositeElementTypes.UNARY_EXPRESSION);
            return true;
        }
        SmartyExpressionParser.parseOperand(builder);
        return true;
    }

    public static boolean parseVariable(PsiBuilder builder) {
        if (builder.getTokenType() == SmartyTokenTypes.DOLLAR || builder.getTokenType() == SmartyTokenTypes.START_TAG_START) {
            if (builder.getTokenType() == SmartyTokenTypes.DOLLAR) {
                builder.advanceLexer();
            }
            SmartyExpressionParser.parseVariableInner(builder);
            SmartyTagsParser.parseModifiers(builder);
        } else if (builder.getTokenType() == SmartyTokenTypes.SHARP) {
            builder.advanceLexer();
            PsiBuilder.Marker configVariable = builder.mark();
            if (builder.getTokenType() == SmartyTokenTypes.IDENTIFIER) {
                builder.advanceLexer();
                configVariable.done(SmartyCompositeElementTypes.CONFIG_VARIABLE_REFERENCE);
            } else {
                builder.error(SmartyBundle.message("parsing.error.identifier.expected", new Object[0]));
                configVariable.drop();
            }
            if (builder.getTokenType() != SmartyTokenTypes.SHARP) {
                builder.error(SmartyBundle.message("parsing.error.number.sign.expected", new Object[0]));
            } else {
                builder.advanceLexer();
            }
        } else if (SmartyTokenTypes.STATIC_VALUES.contains(builder.getTokenType())) {
            builder.advanceLexer();
        } else if (builder.getTokenType() == SmartyTokenTypes.SINGLE_QUOTE) {
            SmartyExpressionParser.parseSingleQuotedString(builder);
            SmartyTagsParser.parseModifiers(builder);
        } else if (builder.getTokenType() == SmartyTokenTypes.DOUBLE_QUOTE) {
            SmartyExpressionParser.parseDoubleQuotedString(builder);
            SmartyTagsParser.parseModifiers(builder);
        } else if (builder.getTokenType() == SmartyTokenTypes.L_BRACKET) {
            SmartyExpressionParser.parseArrayDefinition(builder);
            SmartyTagsParser.parseModifiers(builder);
        } else {
            if (builder.getTokenType() == SmartyTokenTypes.IDENTIFIER) {
                PsiBuilder.Marker functionCallMarker = builder.mark();
                if (builder.lookAhead(1) == SmartyTokenTypes.BACK_SLASH && !SmartyExpressionParser.parseNamespacedReference(builder)) {
                    return false;
                }
                builder.advanceLexer();
                if (builder.getTokenType() == SmartyTokenTypes.L_PAR) {
                    SmartyExpressionParser.parseArgumentsList(builder);
                    functionCallMarker.done(SmartyCompositeElementTypes.FUNCTION_CALL);
                } else if (builder.getTokenType() == SmartyTokenTypes.COLON_COLON) {
                    functionCallMarker.rollbackTo();
                    SmartyExpressionParser.parseVariableInner(builder);
                    SmartyTagsParser.parseModifiers(builder);
                } else {
                    functionCallMarker.drop();
                }
                if (builder.getTokenType() == SmartyTokenTypes.L_BRACKET) {
                    SmartyExpressionParser.parseArrayAccess(builder);
                }
                SmartyTagsParser.parseModifiers(builder);
                return true;
            }
            if (builder.getTokenType() == SmartyTokenTypes.BACK_QUOTE) {
                builder.advanceLexer();
                SmartyExpressionParser.parseExpression(builder);
                if (builder.getTokenType() != SmartyTokenTypes.BACK_QUOTE) {
                    builder.error(SmartyBundle.message("parsing.error.back.quote.expected", new Object[0]));
                } else {
                    builder.advanceLexer();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean parseNamespacedReference(PsiBuilder builder) {
        IElementType lastTokenType = null;
        IElementType currentTokenType = builder.getTokenType();
        IElementType lookAheadTokenType = builder.lookAhead(1);
        while (!(currentTokenType != SmartyTokenTypes.BACK_SLASH && currentTokenType != SmartyTokenTypes.IDENTIFIER || lastTokenType == currentTokenType || lookAheadTokenType != SmartyTokenTypes.BACK_SLASH && lookAheadTokenType != SmartyTokenTypes.IDENTIFIER)) {
            lastTokenType = currentTokenType;
            builder.advanceLexer();
            currentTokenType = builder.getTokenType();
            lookAheadTokenType = builder.lookAhead(1);
        }
        return lastTokenType != currentTokenType;
    }

    private static void parseSingleQuotedString(PsiBuilder builder) {
        assert (builder.getTokenType() == SmartyTokenTypes.SINGLE_QUOTE);
        builder.advanceLexer();
        if (builder.getTokenType() == SmartyTokenTypes.STRING_LITERAL) {
            builder.advanceLexer();
        }
        if (builder.getTokenType() == SmartyTokenTypes.SINGLE_QUOTE) {
            builder.advanceLexer();
        }
    }

    public static void parseDoubleQuotedString(PsiBuilder builder) {
        assert (builder.getTokenType() == SmartyTokenTypes.DOUBLE_QUOTE);
        SmartyTagsParser tagsParser = null;
        builder.advanceLexer();
        while (true) {
            if (builder.getTokenType() == SmartyTokenTypes.DOLLAR) {
                builder.advanceLexer();
                SmartyExpressionParser.parseVariableInner(builder);
                continue;
            }
            if (builder.getTokenType() == SmartyTokenTypes.STRING_LITERAL) {
                builder.advanceLexer();
                continue;
            }
            if (builder.getTokenType() == SmartyTokenTypes.BACK_QUOTE) {
                builder.advanceLexer();
                SmartyExpressionParser.parseExpression(builder);
                if (builder.getTokenType() != SmartyTokenTypes.BACK_QUOTE) {
                    builder.error(SmartyBundle.message("parsing.error.single.quote.expected", new Object[0]));
                    continue;
                }
                builder.advanceLexer();
                continue;
            }
            if (builder.getTokenType() != SmartyTokenTypes.START_TAG_START && builder.getTokenType() != SmartyTokenTypes.END_TAG_START) break;
            if (tagsParser == null) {
                tagsParser = new SmartyTagsParser(builder.getProject());
            }
            tagsParser.parseOneSmartyTagInInnerConstruction(builder, false);
        }
        if (tagsParser != null) {
            tagsParser.clearStack();
        }
        if (builder.getTokenType() != SmartyTokenTypes.DOUBLE_QUOTE) {
            builder.error(SmartyBundle.message("parsing.error.double.quote.expected", new Object[0]));
        } else {
            builder.advanceLexer();
        }
    }

    public static boolean parseVariableDefinition(PsiBuilder builder) {
        if (builder.getTokenType() == SmartyTokenTypes.DOLLAR) {
            builder.advanceLexer();
        } else {
            builder.error(SmartyBundle.message("parsing.error.dollar.expected", new Object[0]));
        }
        PsiBuilder.Marker mark = builder.mark();
        if (builder.getTokenType() != SmartyTokenTypes.IDENTIFIER) {
            builder.error(SmartyBundle.message("parsing.error.identifier.expected", new Object[0]));
            mark.drop();
            return false;
        }
        builder.advanceLexer();
        mark.done(SmartyCompositeElementTypes.DEFINITION);
        return true;
    }

    private static void parseVariableInner(PsiBuilder builder) {
        boolean isNamespace;
        PsiBuilder.Marker referenceExpression = builder.mark();
        boolean start = true;
        boolean bl = isNamespace = builder.lookAhead(1) == SmartyTokenTypes.BACK_SLASH;
        if (isNamespace) {
            SmartyExpressionParser.parseNamespacedReference(builder);
        }
        while (builder.getTokenType() == SmartyTokenTypes.DOT || builder.getTokenType() == SmartyTokenTypes.COLON_COLON || builder.getTokenType() == SmartyTokenTypes.ARROW || start) {
            if (!(start || builder.getTokenType() != SmartyTokenTypes.DOT && builder.getTokenType() != SmartyTokenTypes.ARROW && builder.getTokenType() != SmartyTokenTypes.DOLLAR && builder.getTokenType() != SmartyTokenTypes.COLON_COLON)) {
                builder.advanceLexer();
                if (builder.getTokenType() == SmartyTokenTypes.DOLLAR) {
                    builder.advanceLexer();
                }
            }
            if (builder.getTokenType() != SmartyTokenTypes.IDENTIFIER && builder.getTokenType() != SmartyTokenTypes.NUMERIC_LITERAL && builder.getTokenType() != SmartyTokenTypes.START_TAG_START) break;
            boolean isID = false;
            do {
                if (builder.getTokenType() == SmartyTokenTypes.START_TAG_START) {
                    new SmartyTagsParser(builder.getProject()).parseOneSmartyTagInInnerConstruction(builder, true);
                    isID = false;
                    continue;
                }
                if (isID) break;
                builder.advanceLexer();
                isID = true;
            } while (builder.getTokenType() == SmartyTokenTypes.IDENTIFIER || builder.getTokenType() == SmartyTokenTypes.NUMERIC_LITERAL || builder.getTokenType() == SmartyTokenTypes.START_TAG_START);
            referenceExpression.done(SmartyCompositeElementTypes.REFERENCE);
            if (start && builder.getTokenType() == SmartyTokenTypes.SILENCE) {
                PsiBuilder.Marker mark = builder.mark();
                builder.advanceLexer();
                if (builder.getTokenType() != SmartyTokenTypes.IDENTIFIER) {
                    mark.rollbackTo();
                } else {
                    String tokenText = builder.getTokenText();
                    if (tokenText != null) {
                        builder.advanceLexer();
                        start = false;
                        mark.drop();
                        referenceExpression = referenceExpression.precede();
                        referenceExpression.done(SmartyCompositeElementTypes.REFERENCE);
                        referenceExpression = referenceExpression.precede();
                        break;
                    }
                    mark.rollbackTo();
                }
            }
            if (builder.getTokenType() == SmartyTokenTypes.L_PAR) {
                referenceExpression = referenceExpression.precede();
                SmartyExpressionParser.parseArgumentsList(builder);
                referenceExpression.done(SmartyCompositeElementTypes.FUNCTION_CALL);
            }
            while (builder.getTokenType() == SmartyTokenTypes.L_BRACKET) {
                SmartyExpressionParser.parseArrayAccess(builder);
            }
            referenceExpression = referenceExpression.precede();
            if (!start && builder.getTokenType() == SmartyTokenTypes.COLON_COLON) {
                builder.error(SmartyBundle.message("parsing.error.static.access.not.allowed", new Object[0]));
            }
            start = false;
        }
        if (start) {
            builder.error(SmartyBundle.message("parsing.error.reference.expected", new Object[0]));
        }
        referenceExpression.drop();
    }

    private static void parseArgumentsList(PsiBuilder builder) {
        PsiBuilder.Marker argumentList = builder.mark();
        if (builder.getTokenType() != SmartyTokenTypes.L_PAR) {
            builder.error(SmartyBundle.message("parsing.error.left.brace.expected", new Object[0]));
        } else {
            builder.advanceLexer();
        }
        if (builder.getTokenType() != SmartyTokenTypes.R_PAR) {
            SmartyExpressionParser.parseExprList(builder);
        }
        if (builder.getTokenType() != SmartyTokenTypes.R_PAR) {
            builder.error(SmartyBundle.message("parsing.error.right.brace.expected", new Object[0]));
        }
        builder.advanceLexer();
        argumentList.done(SmartyCompositeElementTypes.ARGUMENT_LIST);
    }

    private static void parseExprList(PsiBuilder builder) {
        if (!SmartyExpressionParser.parseArrayDefinition(builder)) {
            SmartyExpressionParser.parseExpression(builder);
        }
        if (builder.getTokenType() == SmartyTokenTypes.COMMA) {
            builder.advanceLexer();
            SmartyExpressionParser.parseExprList(builder);
        }
    }

    private static void parseArrayAccess(PsiBuilder builder) {
        assert (builder.getTokenType() == SmartyTokenTypes.L_BRACKET);
        builder.advanceLexer();
        if (builder.getTokenType() == SmartyTokenTypes.R_BRACKET) {
            builder.advanceLexer();
            if (builder.getTokenType() != SmartyTokenTypes.EQ) {
                builder.error(SmartyBundle.message("parsing.error.assign.expected", new Object[0]));
            }
            return;
        }
        if (!SmartyExpressionParser.parseExpression(builder)) {
            builder.error(SmartyBundle.message("parsing.error.reference.expected", new Object[0]));
        }
        if (builder.getTokenType() != SmartyTokenTypes.R_BRACKET) {
            builder.error(SmartyBundle.message("parsing.error.right.square.brace.expected", new Object[0]));
        } else {
            builder.advanceLexer();
        }
    }

    public static void parseOperand(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == SmartyTokenTypes.L_PAR) {
            builder.advanceLexer();
            SmartyExpressionParser.parseExpression(builder);
            if (builder.getTokenType() != SmartyTokenTypes.R_PAR) {
                builder.error(SmartyBundle.message("parsing.error.right.brace.expected", new Object[0]));
                return;
            }
            builder.advanceLexer();
        } else if (SmartyTokenTypes.PREFIX_OPERATIONS.contains(tokenType)) {
            builder.advanceLexer();
            SmartyExpressionParser.parseOperand(builder);
        } else {
            if (!SmartyExpressionParser.parseVariable(builder)) {
                builder.error(SmartyBundle.message("parsing.error.reference.expected", new Object[0]));
            }
            if (SmartyTokenTypes.POSTFIX_OPERATIONS.contains(tokenType = builder.getTokenType())) {
                builder.advanceLexer();
            }
        }
    }
}

