/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.smarty.edit;

import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageBraceMatching;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.smarty.SmartyCompletionContributor;
import com.jetbrains.smarty.SmartyFileType;
import com.jetbrains.smarty.SmartyLanguage;
import com.jetbrains.smarty.lang.SmartyTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartyTagsMatcher
implements BraceMatcher {
    private static final BracePair[] PAIRS = new BracePair[]{new BracePair(SmartyTokenTypes.L_BRACKET, SmartyTokenTypes.R_BRACKET, false), new BracePair(SmartyTokenTypes.L_PAR, SmartyTokenTypes.R_PAR, false)};

    public int getBraceTokenGroupId(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            SmartyTagsMatcher.$$$reportNull$$$0(0);
        }
        Language l = tokenType.getLanguage();
        return l.hashCode();
    }

    public boolean isLBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        LanguageFileType tokenFileType;
        IElementType tokenType;
        PairedBraceMatcher matcher;
        if (iterator == null) {
            SmartyTagsMatcher.$$$reportNull$$$0(1);
        }
        if (fileText == null) {
            SmartyTagsMatcher.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            SmartyTagsMatcher.$$$reportNull$$$0(3);
        }
        if ((matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage((tokenType = iterator.getTokenType()).getLanguage())) != null) {
            BracePair[] pairs = matcher.getPairs();
            BracePair[] bracePairArray = pairs;
            int n = bracePairArray.length;
            for (int i = 0; i < n; ++i) {
                BracePair pair = bracePairArray[i];
                if (pair.getLeftBraceType() != tokenType) continue;
                return true;
            }
        }
        if (!tokenType.getLanguage().equals((Object)SmartyLanguage.INSTANCE) && (tokenFileType = iterator.getTokenType().getLanguage().getAssociatedFileType()) != null && tokenFileType != SmartyFileType.INSTANCE) {
            for (FileTypeExtensionPoint ext : BraceMatcher.EP_NAME.getExtensionList()) {
                if (ext.filetype == null || !ext.filetype.equals(tokenFileType.getName())) continue;
                return ((BraceMatcher)ext.getInstance()).isLBraceToken(iterator, fileText, (FileType)(tokenFileType instanceof XmlFileType ? HtmlFileType.INSTANCE : tokenFileType));
            }
        }
        for (BracePair pair : PAIRS) {
            if (pair.getLeftBraceType() != tokenType) continue;
            return true;
        }
        return tokenType == SmartyTokenTypes.START_TAG_START;
    }

    public boolean isRBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        LanguageFileType tokenFileType;
        IElementType tokenType;
        PairedBraceMatcher matcher;
        if (iterator == null) {
            SmartyTagsMatcher.$$$reportNull$$$0(4);
        }
        if (fileText == null) {
            SmartyTagsMatcher.$$$reportNull$$$0(5);
        }
        if (fileType == null) {
            SmartyTagsMatcher.$$$reportNull$$$0(6);
        }
        if ((matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage((tokenType = iterator.getTokenType()).getLanguage())) != null) {
            BracePair[] pairs = matcher.getPairs();
            for (BracePair pair : pairs) {
                if (pair.getRightBraceType() != tokenType) continue;
                return true;
            }
        }
        if (!tokenType.getLanguage().equals((Object)SmartyLanguage.INSTANCE) && (tokenFileType = iterator.getTokenType().getLanguage().getAssociatedFileType()) != null && tokenFileType != SmartyFileType.INSTANCE) {
            for (FileTypeExtensionPoint ext : BraceMatcher.EP_NAME.getExtensionList()) {
                if (ext.filetype == null || !ext.filetype.equals(tokenFileType.getName())) continue;
                return ((BraceMatcher)ext.getInstance()).isRBraceToken(iterator, fileText, (FileType)(tokenFileType instanceof XmlFileType ? HtmlFileType.INSTANCE : tokenFileType));
            }
        }
        if (tokenType == SmartyTokenTypes.SHARP) {
            iterator.retreat();
            IElementType nextTokenType = iterator.getTokenType();
            iterator.advance();
            return nextTokenType == SmartyTokenTypes.IDENTIFIER;
        }
        for (IElementType pair : PAIRS) {
            if (pair.getRightBraceType() != tokenType) continue;
            return true;
        }
        if (tokenType != SmartyTokenTypes.TAG_END) {
            return false;
        }
        int iteratorBackwardOffset = 0;
        while (!iterator.atEnd() && iterator.getTokenType() != SmartyTokenTypes.PREDEFINED_FUNCTION && iterator.getTokenType() != SmartyTokenTypes.START_TAG_START) {
            iterator.retreat();
            ++iteratorBackwardOffset;
        }
        if (!iterator.atEnd() && iterator.getTokenType() == SmartyTokenTypes.START_TAG_START) {
            SmartyTagsMatcher.returnIteratorBack(iterator, -iteratorBackwardOffset);
            return true;
        }
        if (iterator.atEnd() || iterator.getTokenType() != SmartyTokenTypes.PREDEFINED_FUNCTION) {
            SmartyTagsMatcher.returnIteratorBack(iterator, -iteratorBackwardOffset);
            return false;
        }
        String functionName = fileText.subSequence(iterator.getStart(), iterator.getEnd()).toString();
        if (SmartyCompletionContributor.isUnique(functionName)) {
            SmartyTagsMatcher.returnIteratorBack(iterator, -iteratorBackwardOffset);
            return true;
        }
        iterator.retreat();
        ++iteratorBackwardOffset;
        while (!iterator.atEnd() && iterator.getTokenType() == SmartyTokenTypes.WHITE_SPACE) {
            iterator.retreat();
            ++iteratorBackwardOffset;
        }
        boolean returnValue = iterator.getTokenType() == SmartyTokenTypes.END_TAG_START;
        SmartyTagsMatcher.returnIteratorBack(iterator, -iteratorBackwardOffset);
        return returnValue;
    }

    private static void returnIteratorBack(HighlighterIterator iterator, int offset) {
        while (offset != 0) {
            if (offset < 0) {
                iterator.advance();
                ++offset;
                continue;
            }
            iterator.retreat();
            --offset;
        }
    }

    public boolean isPairBraces(@NotNull IElementType tokenType1, @NotNull IElementType tokenType2) {
        PairedBraceMatcher matcher;
        if (tokenType1 == null) {
            SmartyTagsMatcher.$$$reportNull$$$0(7);
        }
        if (tokenType2 == null) {
            SmartyTagsMatcher.$$$reportNull$$$0(8);
        }
        if ((matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(tokenType1.getLanguage())) != null) {
            BracePair[] pairs;
            for (BracePair pair : pairs = matcher.getPairs()) {
                if (pair.getLeftBraceType() == tokenType1) {
                    return pair.getRightBraceType() == tokenType2;
                }
                if (pair.getRightBraceType() != tokenType1) continue;
                return pair.getLeftBraceType() == tokenType2;
            }
        }
        LanguageFileType tokenFileType1 = tokenType1.getLanguage().getAssociatedFileType();
        LanguageFileType tokenFileType2 = tokenType2.getLanguage().getAssociatedFileType();
        if (tokenFileType2 != tokenFileType1) {
            return false;
        }
        if (tokenFileType1 != SmartyFileType.INSTANCE && tokenFileType1 != null) {
            for (FileTypeExtensionPoint ext : BraceMatcher.EP_NAME.getExtensionList()) {
                if (!ext.filetype.equals(tokenFileType1.getName())) continue;
                return ((BraceMatcher)ext.getInstance()).isPairBraces(tokenType1, tokenType2);
            }
        }
        for (BracePair pair : PAIRS) {
            if (pair.getLeftBraceType() == tokenType1) {
                return pair.getRightBraceType() == tokenType2;
            }
            if (pair.getRightBraceType() != tokenType1) continue;
            return pair.getLeftBraceType() == tokenType2;
        }
        return tokenType1 == SmartyTokenTypes.START_TAG_START && tokenType2 == SmartyTokenTypes.TAG_END || tokenType1 == SmartyTokenTypes.TAG_END && tokenType2 == SmartyTokenTypes.START_TAG_START;
    }

    public boolean isStructuralBrace(@NotNull HighlighterIterator iterator, @NotNull CharSequence text, @NotNull FileType fileType) {
        if (iterator == null) {
            SmartyTagsMatcher.$$$reportNull$$$0(9);
        }
        if (text == null) {
            SmartyTagsMatcher.$$$reportNull$$$0(10);
        }
        if (fileType == null) {
            SmartyTagsMatcher.$$$reportNull$$$0(11);
        }
        return true;
    }

    public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
        PairedBraceMatcher matcher;
        if (type == null) {
            SmartyTagsMatcher.$$$reportNull$$$0(12);
        }
        if ((matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(type.getLanguage())) != null) {
            BracePair[] pairs;
            BracePair[] bracePairArray = pairs = matcher.getPairs();
            int n = bracePairArray.length;
            for (int i = 0; i < n; ++i) {
                BracePair pair = bracePairArray[i];
                if (pair.getLeftBraceType() == type) {
                    return pair.getRightBraceType();
                }
                if (pair.getRightBraceType() != type) continue;
                return pair.getLeftBraceType();
            }
        }
        for (BracePair pair : PAIRS) {
            if (pair.getLeftBraceType() == type) {
                return pair.getRightBraceType();
            }
            if (pair.getRightBraceType() != type) continue;
            return pair.getLeftBraceType();
        }
        if (type == SmartyTokenTypes.START_TAG_START) {
            return SmartyTokenTypes.TAG_END;
        }
        if (type == SmartyTokenTypes.TAG_END) {
            return SmartyTokenTypes.START_TAG_START;
        }
        return null;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            SmartyTagsMatcher.$$$reportNull$$$0(13);
        }
        return true;
    }

    public int getCodeConstructStart(@NotNull PsiFile file, int openingBraceOffset) {
        if (file == null) {
            SmartyTagsMatcher.$$$reportNull$$$0(14);
        }
        return openingBraceOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType2";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lbraceType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/smarty/edit/SmartyTagsMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getBraceTokenGroupId";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isLBraceToken";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isRBraceToken";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isPairBraces";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isStructuralBrace";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getOppositeBraceTokenType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isPairedBracesAllowedBeforeType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getCodeConstructStart";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

