/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.smarty;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.smarty.SmartyFile;
import com.jetbrains.smarty.lang.SmartyTokenTypes;
import com.jetbrains.smarty.lang.psi.SmartyTag;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartyFoldingBuilder
implements FoldingBuilder,
DumbAware {
    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        PsiElement element;
        if (node == null) {
            SmartyFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            SmartyFoldingBuilder.$$$reportNull$$$0(1);
        }
        if ((element = node.getPsi()) instanceof SmartyFile && element.isValid()) {
            SmartyFile file = (SmartyFile)element;
            LinkedList<FoldingDescriptor> result = new LinkedList<FoldingDescriptor>();
            SmartyFoldingBuilder.addFoldingDescriptors((PsiElement)file, result);
            FoldingDescriptor[] foldingDescriptorArray = result.toArray(FoldingDescriptor.EMPTY);
            if (foldingDescriptorArray == null) {
                SmartyFoldingBuilder.$$$reportNull$$$0(2);
            }
            return foldingDescriptorArray;
        }
        if (FoldingDescriptor.EMPTY == null) {
            SmartyFoldingBuilder.$$$reportNull$$$0(3);
        }
        return FoldingDescriptor.EMPTY;
    }

    private static void addFoldingDescriptors(@NotNull PsiElement root, List<FoldingDescriptor> descriptors) {
        if (root == null) {
            SmartyFoldingBuilder.$$$reportNull$$$0(4);
        }
        for (PsiElement child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            int end;
            TextRange elementRange = child.getTextRange();
            int start = elementRange.getStartOffset();
            if (start + 1 >= (end = elementRange.getEndOffset())) continue;
            TextRange range = null;
            ASTNode astNode = child.getNode();
            if (child instanceof SmartyTag) {
                String tagName = ((SmartyTag)child).getName();
                if ("if".equals(tagName) || "foreach".equals(tagName) || "section".equals(tagName) || "literal".equals(tagName)) {
                    range = SmartyFoldingBuilder.buildRangeForBraces(astNode, SmartyTokenTypes.TAG_END, SmartyTokenTypes.END_TAG_START);
                }
            } else if (astNode.getElementType() == SmartyTokenTypes.COMMENT && StringUtil.countChars((CharSequence)astNode.getChars(), (char)'\n') > 1) {
                range = astNode.getTextRange();
            }
            if (range != null) {
                descriptors.add(new FoldingDescriptor(astNode, range));
            }
            SmartyFoldingBuilder.addFoldingDescriptors(child, descriptors);
        }
    }

    @Nullable
    private static TextRange buildRangeForBraces(@NotNull ASTNode astNode, IElementType lbraceType, IElementType rbraceType) {
        int rightOffset;
        int startOffset;
        if (astNode == null) {
            SmartyFoldingBuilder.$$$reportNull$$$0(5);
        }
        ASTNode lBrace = astNode.findChildByType(lbraceType);
        ASTNode rBrace = astNode.findChildByType(rbraceType);
        if (lBrace != null && rBrace != null && (startOffset = lBrace.getStartOffset() + 1) + 1 < (rightOffset = rBrace.getStartOffset())) {
            return new TextRange(startOffset, rightOffset);
        }
        return null;
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            SmartyFoldingBuilder.$$$reportNull$$$0(6);
        }
        if (node.getElementType() == SmartyTokenTypes.COMMENT) {
            return SmartyFoldingBuilder.getFoldedCommentText(node);
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            SmartyFoldingBuilder.$$$reportNull$$$0(7);
        }
        return false;
    }

    private static String getFoldedCommentText(@NotNull ASTNode node) {
        if (node == null) {
            SmartyFoldingBuilder.$$$reportNull$$$0(8);
        }
        StringBuilder sb = new StringBuilder();
        CharSequence chars = node.getChars();
        boolean skip = false;
        boolean isAfterLeftDelimiter = false;
        boolean skipLeadingWs = true;
        for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            if (!skip) {
                switch (c) {
                    case '\n': {
                        if (sb.length() <= 3) break;
                        sb.append("...");
                        skip = true;
                        break;
                    }
                    case '\t': 
                    case ' ': {
                        if (skipLeadingWs) break;
                        sb.append(c);
                        break;
                    }
                    case '*': {
                        if (!isAfterLeftDelimiter) {
                            isAfterLeftDelimiter = true;
                            sb.append(c).append(' ');
                            break;
                        }
                    }
                    default: {
                        if (isAfterLeftDelimiter) {
                            skipLeadingWs = false;
                        }
                        sb.append(c);
                    }
                }
            }
            if (c != '*' || i <= chars.length() - 3) continue;
            sb.append(c);
            skip = false;
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/smarty/SmartyFoldingBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/smarty/SmartyFoldingBuilder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addFoldingDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildRangeForBraces";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFoldedCommentText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

