/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.util.connection;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.jetbrains.php.util.connection.ServerConnection;
import com.jetbrains.php.util.connection.ServerConnectionListener;
import com.jetbrains.php.util.connection.ServerConnectionStatus;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public abstract class ServerConnectionManager<S extends ServerConnection>
implements ServerConnectionListener<S>,
Disposable {
    private final ArrayList<S> myServerConnections = new ArrayList();
    private final Object myLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public S start(int port) throws ExecutionException {
        ServerConnection serverConnection;
        Object object = this.myLock;
        // MONITORENTER : object
        Iterator<S> iterator = this.myServerConnections.iterator();
        do {
            if (iterator.hasNext()) continue;
            S serverConnection2 = this.createServer();
            this.myServerConnections.add(serverConnection2);
            ((ServerConnection)serverConnection2).addListener(this);
            ((ServerConnection)serverConnection2).startListening(port, null);
            S s = serverConnection2;
            // MONITOREXIT : object
            if (s != null) return s;
            ServerConnectionManager.$$$reportNull$$$0(1);
            return s;
        } while ((serverConnection = (ServerConnection)iterator.next()).getDescriptor().getPort() != port);
        ServerConnection serverConnection3 = serverConnection;
        // MONITOREXIT : object
        if (serverConnection3 != null) return (S)serverConnection3;
        ServerConnectionManager.$$$reportNull$$$0(0);
        return (S)serverConnection3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statusChanged(@NotNull S connection, ServerConnectionStatus status) {
        if (connection == null) {
            ServerConnectionManager.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (status == ServerConnectionStatus.STOPPED) {
                ((ServerConnection)connection).removeListener(this);
                this.myServerConnections.remove(connection);
            }
        }
    }

    @NotNull
    protected abstract S createServer();

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/util/connection/ServerConnectionManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "start";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/util/connection/ServerConnectionManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "statusChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

