/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.util.connection;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ThrowableRunnable;
import com.jetbrains.php.debug.connection.PhpConnectionInitializationTask;
import com.jetbrains.php.util.connection.PhpConnectionInitCallback;
import com.jetbrains.php.util.connection.PhpDebugConnectionException;
import com.jetbrains.php.util.connection.PhpDebugSocketDescriptor;
import com.jetbrains.php.util.connection.PhpIncomingDebugConnectionsSocket;
import com.jetbrains.php.util.connection.ServerConnectionListener;
import com.jetbrains.php.util.connection.ServerConnectionStatus;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.EventListener;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ServerConnection
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ServerConnection.class);
    private static final long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    @NotNull
    private final PhpIncomingDebugConnectionsSocket myIncomingConnectionsSocket;
    private final Object myLock;
    protected final EventDispatcher<ServerConnectionListener> myDispatcher;
    private ServerConnectionStatus myStatus;

    protected ServerConnection(@NotNull PhpIncomingDebugConnectionsSocket socket, @NotNull Disposable parentDisposable) {
        if (socket == null) {
            ServerConnection.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            ServerConnection.$$$reportNull$$$0(1);
        }
        this.myLock = new Object();
        this.myDispatcher = EventDispatcher.create(ServerConnectionListener.class);
        this.myStatus = ServerConnectionStatus.STOPPED;
        this.myIncomingConnectionsSocket = socket;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @NotNull
    public final PhpDebugSocketDescriptor getDescriptor() {
        PhpDebugSocketDescriptor phpDebugSocketDescriptor = this.myIncomingConnectionsSocket.getDescriptor();
        if (phpDebugSocketDescriptor == null) {
            ServerConnection.$$$reportNull$$$0(2);
        }
        return phpDebugSocketDescriptor;
    }

    public final int getPort() {
        return this.myIncomingConnectionsSocket.getDescriptor().getPort();
    }

    public synchronized void startListening(int port, @Nullable PhpConnectionInitCallback callback) throws ExecutionException {
        LOG.debug("Starting '" + this.getDescriptiveName() + "' on port " + port);
        ThrowableRunnable<PhpDebugConnectionException> init = this.myIncomingConnectionsSocket.openConnection(port);
        String connectionType = this.myIncomingConnectionsSocket.getPresentableName();
        this.setStatus(ServerConnectionStatus.STARTED);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                if (!ServerConnection.initializeConnection(init, callback, connectionType)) {
                    return;
                }
                while (this.myIncomingConnectionsSocket.isConnectionOpened()) {
                    try {
                        Socket socket = this.waitForDebugSessionConnection();
                        socket.setTcpNoDelay(true);
                        this.registerSocket(socket);
                        ApplicationManager.getApplication().executeOnPooledThread(() -> {
                            try {
                                LOG.debug(MessageFormat.format("Incoming connection on port {0} from {1}", String.valueOf(port), socket.getInetAddress().getHostAddress()));
                                this.handle(socket);
                            }
                            catch (IOException e) {
                                LOG.warn((Throwable)e);
                            }
                            finally {
                                try {
                                    LOG.debug("----socket closed");
                                    this.closeDebugSessionConnection(socket);
                                }
                                catch (IOException e) {
                                    boolean bl = true;
                                }
                            }
                        });
                    }
                    catch (SocketTimeoutException ignored) {
                        boolean bl = true;
                    }
                }
            }
            catch (IOException e) {
                if (this.myIncomingConnectionsSocket.isConnectionOpened()) {
                    LOG.info("Error while listening on port " + port, (Throwable)e);
                }
            }
            finally {
                LOG.info("Stopped listening on port " + port);
                this.stopListening();
            }
        });
    }

    private static boolean initializeConnection(@NotNull ThrowableRunnable<PhpDebugConnectionException> init, @Nullable PhpConnectionInitCallback callback, @NotNull @Nls String connectionType) {
        if (init == null) {
            ServerConnection.$$$reportNull$$$0(3);
        }
        if (connectionType == null) {
            ServerConnection.$$$reportNull$$$0(4);
        }
        if (init == PhpIncomingDebugConnectionsSocket.EMPTY_INIT) {
            return true;
        }
        return new PhpConnectionInitializationTask(init, callback, connectionType, CONNECTION_TIMEOUT).execute();
    }

    protected void registerSocket(@NotNull Socket socket) {
        if (socket == null) {
            ServerConnection.$$$reportNull$$$0(5);
        }
    }

    @NotNull
    protected Socket waitForDebugSessionConnection() throws IOException {
        Socket socket = this.myIncomingConnectionsSocket.waitForDebugSessionConnection();
        if (socket == null) {
            ServerConnection.$$$reportNull$$$0(6);
        }
        return socket;
    }

    protected void closeDebugSessionConnection(@NotNull Socket socket) throws IOException {
        if (socket == null) {
            ServerConnection.$$$reportNull$$$0(7);
        }
        socket.close();
    }

    public synchronized void stopListening() {
        int port = this.getPort();
        LOG.debug("Stopping '" + this.getDescriptiveName() + "' on port " + port);
        this.setStatus(ServerConnectionStatus.STOPPED);
        if (this.myIncomingConnectionsSocket.isConnectionOpened()) {
            ThrowableRunnable<PhpDebugConnectionException> closeFuture = this.myIncomingConnectionsSocket.closeConnection();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    closeFuture.run();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Stopped '" + this.getDescriptiveName() + "' on port " + port);
                    }
                }
                catch (PhpDebugConnectionException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Failed to stop '" + this.getDescriptiveName() + "' on port " + port);
                    }
                    LOG.warn("Failed closing '" + this.getDescriptiveName() + "' on port " + port, (Throwable)e);
                }
                Disposer.dispose((Disposable)this);
            });
        }
    }

    public void dispose() {
    }

    protected abstract void handle(@NotNull Socket var1) throws IOException;

    @NotNull
    public abstract String getDescriptiveName();

    public void addListener(@NotNull ServerConnectionListener listener) {
        if (listener == null) {
            ServerConnection.$$$reportNull$$$0(8);
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(@NotNull ServerConnectionListener listener) {
        if (listener == null) {
            ServerConnection.$$$reportNull$$$0(9);
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStatus(ServerConnectionStatus status) {
        Object object = this.myLock;
        synchronized (object) {
            this.myStatus = status;
        }
        ((ServerConnectionListener)this.myDispatcher.getMulticaster()).statusChanged(this, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerConnectionStatus getStatus() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.myLock;
        synchronized (object) {
            return this.getStatus() == ServerConnectionStatus.STARTED;
        }
    }

    public final void log(String text) {
        LOG.info(this.hashCode() + "#" + text);
    }

    public final void logEvent(String text) {
        this.log("---" + text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "socket";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/util/connection/ServerConnection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "init";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionType";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/util/connection/ServerConnection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "waitForDebugSessionConnection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initializeConnection";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerSocket";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "closeDebugSessionConnection";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

