/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpTrimRendererVisitor
extends PhpElementVisitor {
    private final StringBuilder builder = new StringBuilder();
    private final int myMaxLength;
    private final int mySuffixLength;

    public PhpTrimRendererVisitor(int maxLength, int suffixLength) {
        this.myMaxLength = maxLength;
        this.mySuffixLength = suffixLength;
    }

    public String toString() {
        return StringUtil.shortenTextWithEllipsis((String)this.builder.toString(), (int)this.myMaxLength, (int)this.mySuffixLength);
    }

    private static boolean isWhiteSpaceBeforeRequired(IElementType type) {
        return PhpTokenTypes.kwINSTANCEOF.equals(type) || PhpTokenTypes.tsLIT_OPS.contains(type);
    }

    private static boolean isWhiteSpaceAfterRequired(IElementType type) {
        return PhpTokenTypes.kwINSTANCEOF.equals(type) || PhpTokenTypes.tsLIT_OPS.contains(type) || PhpTokenTypes.kwNEW.equals(type);
    }

    public void visitElement(@NotNull PsiElement element) {
        IElementType elementType;
        if (element == null) {
            PhpTrimRendererVisitor.$$$reportNull$$$0(0);
        }
        if (PhpTrimRendererVisitor.isWhiteSpaceBeforeRequired(elementType = element.getNode().getElementType())) {
            this.builder.append(' ');
        }
        this.builder.append(element.getText());
        if (PhpTrimRendererVisitor.isWhiteSpaceAfterRequired(elementType)) {
            this.builder.append(' ');
        }
    }

    public void visitPhpElement(PhpPsiElement element) {
        element.acceptChildren((PsiElementVisitor)this);
    }

    public void visitPhpVariable(Variable variable) {
        this.builder.append("$");
        this.builder.append(variable.getName());
    }

    public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
        boolean shortSyntax = expression.isShortSyntax();
        this.builder.append(shortSyntax ? "[" : "array(");
        if (PhpPsiUtil.getChildOfType((PsiElement)expression, PhpElementTypes.HASH_ARRAY_ELEMENT) != null || PhpPsiUtil.getChildOfType((PsiElement)expression, PhpElementTypes.ARRAY_VALUE) != null) {
            this.builder.append("...");
        }
        this.builder.append(shortSyntax ? "]" : ")");
    }

    public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
        PhpPsiElement value = expression.getValue();
        if (value != null) {
            value.accept((PsiElementVisitor)this);
        }
        this.builder.append("[");
        ArrayIndex index = expression.getIndex();
        if (index != null) {
            index.accept((PsiElementVisitor)this);
        }
        this.builder.append("]");
    }

    public void visitPhpParameterList(ParameterList list) {
        if (list.getParameters().length > 0) {
            this.builder.append("...");
        }
    }

    public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
        this.builder.append(StringUtil.shortenTextWithEllipsis((String)expression.getText(), (int)25, (int)4));
    }

    public void visitPhpFunction(Function function) {
        this.builder.append("function(");
        if (function.getParameters().length > 0) {
            this.builder.append("...");
        }
        this.builder.append("){...}");
    }

    public void visitWhiteSpace(@NotNull PsiWhiteSpace space) {
        if (space == null) {
            PhpTrimRendererVisitor.$$$reportNull$$$0(1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "space";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/util/PhpTrimRendererVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitWhiteSpace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

