/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.uml.providers.member;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UpDownHandler;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CreateNewPhpFieldDialog
extends DialogWrapper {
    JTextField myName;
    private JComboBox myVisibility;
    private JBLabel myUpDownIcon;
    private JPanel myPanel;
    private JBCheckBox myStaticCb;
    private final PhpClass myClass;

    protected CreateNewPhpFieldDialog(Project project, PhpClass cls) {
        super(project);
        this.myClass = cls;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(PhpBundle.message("create.new.field.dialog.title", objectArray));
        this.init();
    }

    protected JComponent createCenterPanel() {
        UpDownHandler.register((JComponent)this.myName, (JComponent)this.myVisibility);
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myName;
    }

    protected ValidationInfo doValidate() {
        String name = this.myName.getText().trim();
        if (!PhpLangUtil.isPhpIdentifier(name)) {
            return new ValidationInfo(PhpBundle.message("uml.wrong.name", new Object[0]), (JComponent)this.myName);
        }
        for (Field field : this.myClass.getFields()) {
            if (!name.equals(field.getName())) continue;
            return new ValidationInfo(PhpBundle.message("uml.0.already.exists.in.class.1", name, this.myClass.getName()), (JComponent)this.myName);
        }
        return super.doValidate();
    }

    protected String getDimensionServiceKey() {
        return "php.uml.create.field.dialog";
    }

    private void createUIComponents() {
        this.myUpDownIcon = new JBLabel(PlatformIcons.UP_DOWN_ARROWS);
    }

    public String getNewFieldText() {
        return this.myVisibility.getSelectedItem() + (this.myStaticCb.isSelected() ? " static" : "") + " $" + this.myName.getText() + ";";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        JComboBox jComboBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", CreateNewPhpFieldDialog.class).getString("label.visibility2"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVisibility = jComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("public");
        defaultComboBoxModel.addElement("protected");
        defaultComboBoxModel.addElement("private");
        defaultComboBoxModel.addElement("var");
        jComboBox.setModel(defaultComboBoxModel);
        jPanel.add(jComboBox, new GridConstraints(1, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", CreateNewPhpFieldDialog.class).getString("label.name"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = this.myUpDownIcon;
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myStaticCb = jBCheckBox = new JBCheckBox();
        jBCheckBox.setEnabled(true);
        jBCheckBox.setSelected(false);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", CreateNewPhpFieldDialog.class).getString("checkbox.static"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(1, 1, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

