/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.uml;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUmlElementManager
extends AbstractDiagramElementManager<PsiElement> {
    private static SimpleColoredText getClassPresentableName(PhpClass phpClass) {
        int style = 1;
        if (!phpClass.isPhysical()) {
            style |= 2;
        }
        return new SimpleColoredText(phpClass.getName(), new SimpleTextAttributes(style, DEFAULT_TITLE_ATTR.getFgColor()));
    }

    private static SimpleColoredText getMethodPresentableName(Method method) {
        int style = 0;
        if (!method.isPhysical()) {
            style |= 2;
        }
        SimpleColoredText text = new SimpleColoredText();
        text.append(PhpUmlElementManager.getMethodSignature(method), new SimpleTextAttributes(style, DEFAULT_TITLE_ATTR.getFgColor()));
        return text;
    }

    private static SimpleColoredText getFieldPresentableName(@NotNull Field field) {
        if (field == null) {
            PhpUmlElementManager.$$$reportNull$$$0(0);
        }
        int style = 0;
        if (!field.isPhysical()) {
            style |= 2;
        }
        return new SimpleColoredText(field.getName(), new SimpleTextAttributes(style, DEFAULT_TITLE_ATTR.getFgColor()));
    }

    private static SimpleColoredText getDirectoryPresentableName(@NotNull PsiDirectory directory) {
        if (directory == null) {
            PhpUmlElementManager.$$$reportNull$$$0(1);
        }
        int style = 1;
        if (!directory.isPhysical()) {
            style |= 2;
        }
        return new SimpleColoredText(directory.getName(), new SimpleTextAttributes(style, DEFAULT_TITLE_ATTR.getFgColor()));
    }

    @NlsSafe
    private static String getMethodSignature(@NotNull Method method) {
        if (method == null) {
            PhpUmlElementManager.$$$reportNull$$$0(2);
        }
        StringBuilder signature = new StringBuilder(method.getName());
        signature.append("(");
        for (Parameter param : method.getParameters()) {
            signature.append(param.getName());
            signature.append(", ");
        }
        if (method.getParameters().length != 0) {
            signature.delete(signature.length() - 2, signature.length());
        }
        signature.append(")");
        return signature.toString();
    }

    public boolean isAcceptableAsNode(@Nullable Object element) {
        return element instanceof PhpClass || element instanceof PsiDirectory;
    }

    @Nullable
    public PsiElement findInDataContext(@NotNull DataContext context) {
        Collection<PhpClass> classes;
        if (context == null) {
            PhpUmlElementManager.$$$reportNull$$$0(3);
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            return null;
        }
        if (element instanceof PhpClass) {
            return element;
        }
        if (element instanceof PsiDirectory) {
            return element;
        }
        if (element instanceof PhpFile && (classes = PhpPsiUtil.findAllClasses((PhpFile)element)).size() > 0) {
            return (PsiElement)classes.iterator().next();
        }
        return null;
    }

    @NotNull
    public Collection<PsiElement> findElementsInDataContext(@NotNull DataContext context) {
        if (context == null) {
            PhpUmlElementManager.$$$reportNull$$$0(4);
        }
        ArrayList<PsiElement> classes = new ArrayList<PsiElement>();
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context);
        if (elements != null) {
            for (PsiElement file : elements) {
                if (!(file instanceof PhpFile)) continue;
                classes.addAll(PhpPsiUtil.findAllClasses((PhpFile)file));
            }
        }
        ArrayList<PsiElement> arrayList = classes;
        if (arrayList == null) {
            PhpUmlElementManager.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public PsiElement @NotNull [] getNodeItems(PsiElement psiElement) {
        if (psiElement instanceof PhpClass) {
            ArrayList elements = new ArrayList();
            if (!psiElement.isValid()) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    PhpUmlElementManager.$$$reportNull$$$0(6);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            ContainerUtil.addAll(elements, (Object[])((PhpClass)psiElement).getOwnFields());
            ContainerUtil.addAll(elements, (Object[])((PhpClass)psiElement).getOwnMethods());
            PsiElement[] psiElementArray = elements.isEmpty() ? PsiElement.EMPTY_ARRAY : PsiUtilCore.toPsiElementArray(elements);
            if (psiElementArray == null) {
                PhpUmlElementManager.$$$reportNull$$$0(7);
            }
            return psiElementArray;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            PhpUmlElementManager.$$$reportNull$$$0(8);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public boolean canCollapse(PsiElement element) {
        return false;
    }

    public boolean isContainerFor(PsiElement parent, PsiElement child) {
        return false;
    }

    @Nullable
    public String getElementTitle(PsiElement element) {
        if (element instanceof PhpClass) {
            return ((PhpClass)element).getName();
        }
        return ((PsiDirectory)element).getName();
    }

    @Nullable
    public SimpleColoredText getItemName(@Nullable Object element, @NotNull DiagramState presentation) {
        if (presentation == null) {
            PhpUmlElementManager.$$$reportNull$$$0(9);
        }
        if (element instanceof Method) {
            return PhpUmlElementManager.getMethodPresentableName((Method)element);
        }
        if (element instanceof Field) {
            return PhpUmlElementManager.getFieldPresentableName((Field)element);
        }
        if (element instanceof PhpClass) {
            return PhpUmlElementManager.getClassPresentableName((PhpClass)element);
        }
        if (element instanceof PsiDirectory) {
            return PhpUmlElementManager.getDirectoryPresentableName((PsiDirectory)element);
        }
        return null;
    }

    @Nullable
    public SimpleColoredText getItemType(@Nullable Object element) {
        return null;
    }

    @Nullable
    @Nls
    public String getNodeTooltip(PsiElement element) {
        ItemPresentation presentation = null;
        if (element instanceof PhpClass) {
            PhpClass klass = (PhpClass)element;
            presentation = PhpPresentationUtil.getClassPresentation(klass);
            presentation = new PresentationData(klass.getNamespaceName() + presentation.getPresentableText(), presentation.getLocationString(), klass.getIcon(), null);
        } else if (element instanceof PsiDirectory) {
            presentation = PhpPresentationUtil.getDirectoryPresentation((PsiDirectory)element);
        }
        if (presentation != null) {
            return presentation.getPresentableText() + " " + presentation.getLocationString();
        }
        return "";
    }

    @Nullable
    @Nls
    public String getEditorTitle(PsiElement element, @NotNull Collection<PsiElement> additionalElements) {
        PsiDirectory dir;
        if (additionalElements == null) {
            PhpUmlElementManager.$$$reportNull$$$0(10);
        }
        if (additionalElements.size() > 0 && (dir = element instanceof PsiDirectory ? (PsiDirectory)element.getParent() : element.getContainingFile().getParent()) != null) {
            return PhpBundle.message("display.name.directory.0", dir.getName());
        }
        return super.getEditorTitle((Object)element, additionalElements);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/uml/PhpUmlElementManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/uml/PhpUmlElementManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsInDataContext";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFieldPresentableName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoryPresentableName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMethodSignature";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findInDataContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findElementsInDataContext";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getItemName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

