/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.ui;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.DumbAwareActionButton;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.phpInfo.PhpInfoDialog;
import com.jetbrains.php.config.phpInfo.PhpNonPersistedInfo;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.ui.PhpSingleConfigurableEditor;
import com.jetbrains.php.ui.ResultMessage;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUiUtil {
    private PhpUiUtil() {
    }

    @Nullable
    public static VirtualFile getFileOrProjectRoot(@NotNull Project project, @Nullable String path) {
        if (project == null) {
            PhpUiUtil.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return project.getBaseDir();
        }
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    public static void show(@NotNull DialogWrapper dialog) {
        if (dialog == null) {
            PhpUiUtil.$$$reportNull$$$0(1);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> dialog.show());
    }

    public static void requestFocusIfAppInactive(@NotNull DialogWrapper dialog) {
        Project project;
        Window owner;
        if (dialog == null) {
            PhpUiUtil.$$$reportNull$$$0(2);
        }
        if ((owner = dialog.getOwner()) instanceof IdeFrame && (project = ((IdeFrame)owner).getProject()) != null) {
            ProjectUtil.focusProjectWindow((Project)project, (boolean)true);
        }
    }

    public static int getIntValue(@NotNull String value) {
        if (value == null) {
            PhpUiUtil.$$$reportNull$$$0(3);
        }
        return StringUtilRt.parseInt((String)value, (int)-1);
    }

    @NotNull
    @NlsContexts.Label
    public static String toRedColorHtml(@NotNull @NlsContexts.Label String text) {
        if (text == null) {
            PhpUiUtil.$$$reportNull$$$0(4);
        }
        String string = PhpUiUtil.surroundWithHtml(PhpUiUtil.surroundFontColorRed(text));
        if (string == null) {
            PhpUiUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NlsContexts.Label
    public static String surroundWithHtml(@NotNull @NlsContexts.Label String text) {
        if (text == null) {
            PhpUiUtil.$$$reportNull$$$0(6);
        }
        return "<html>" + text + "</html>";
    }

    public static String surroundFontColorRed(@NotNull String text) {
        if (text == null) {
            PhpUiUtil.$$$reportNull$$$0(7);
        }
        return "<font color='red'>" + text + "</font>";
    }

    public static boolean editConfigurable(@NotNull Project project, @NotNull Configurable configurable) {
        if (project == null) {
            PhpUiUtil.$$$reportNull$$$0(8);
        }
        if (configurable == null) {
            PhpUiUtil.$$$reportNull$$$0(9);
        }
        PhpSingleConfigurableEditor editor = new PhpSingleConfigurableEditor(project, configurable);
        return editor.showAndGet();
    }

    @NotNull
    public static AnActionButton createSimpleAction(@NotNull @NlsActions.ActionText String text, @NotNull Icon icon, final @NotNull Runnable runnable, final @NotNull NotNullComputable<Boolean> isEnabledComputable) {
        if (text == null) {
            PhpUiUtil.$$$reportNull$$$0(10);
        }
        if (icon == null) {
            PhpUiUtil.$$$reportNull$$$0(11);
        }
        if (runnable == null) {
            PhpUiUtil.$$$reportNull$$$0(12);
        }
        if (isEnabledComputable == null) {
            PhpUiUtil.$$$reportNull$$$0(13);
        }
        return new DumbAwareActionButton(text, null, icon){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                UIUtil.invokeLaterIfNeeded((Runnable)runnable);
            }

            public void updateButton(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(((Boolean)isEnabledComputable.compute()).booleanValue());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/jetbrains/php/ui/PhpUiUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateButton";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static AnActionButton createReloadAction(final @NotNull Computable<ResultMessage> computable, final @NotNull NotNullComputable<Boolean> isEnabledComputable) {
        if (computable == null) {
            PhpUiUtil.$$$reportNull$$$0(14);
        }
        if (isEnabledComputable == null) {
            PhpUiUtil.$$$reportNull$$$0(15);
        }
        String tooltip = PhpBundle.message("PhpInterpreterConfigurable.reload.phpinfo", new Object[0]);
        return new DumbAwareActionButton(tooltip, null, PlatformIcons.SYNCHRONIZE_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    ResultMessage result = (ResultMessage)computable.compute();
                    InputEvent event = e.getInputEvent();
                    if (event instanceof MouseEvent) {
                        PhpUiUtil.showBalloon(result.getMessage(), result.getType(), (MouseEvent)event);
                    }
                });
            }

            public void updateButton(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(((Boolean)isEnabledComputable.compute()).booleanValue());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/jetbrains/php/ui/PhpUiUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateButton";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static AnActionButton createShowPhpInfoAction(@NotNull JComponent parent, @NotNull NullableComputable<Pair<PhpInfo, PhpNonPersistedInfo>> runnable, @NotNull NullableComputable<Pair<PhpInfo, PhpNonPersistedInfo>> isEnabledComputable) {
        if (parent == null) {
            PhpUiUtil.$$$reportNull$$$0(16);
        }
        if (runnable == null) {
            PhpUiUtil.$$$reportNull$$$0(17);
        }
        if (isEnabledComputable == null) {
            PhpUiUtil.$$$reportNull$$$0(18);
        }
        return PhpUiUtil.createSimpleAction(PhpBundle.message("PhpInterpreterConfigurable.show.phpinfo", new Object[0]), UIUtil.getBalloonInformationIcon(), () -> {
            Pair phpInfo = (Pair)runnable.compute();
            if (phpInfo != null) {
                PhpInfoDialog.show(parent, (PhpInfo)phpInfo.getFirst(), (PhpNonPersistedInfo)phpInfo.getSecond());
            }
        }, (NotNullComputable<Boolean>)((NotNullComputable)() -> isEnabledComputable.compute() != null));
    }

    @NotNull
    public static JComponent createHorizontalActionsToolbar(@NotNull String place, AnAction ... actions) {
        if (place == null) {
            PhpUiUtil.$$$reportNull$$$0(19);
        }
        if (actions == null) {
            PhpUiUtil.$$$reportNull$$$0(20);
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (AnAction action : actions) {
            actionGroup.addAction(action);
        }
        JComponent jComponent = ActionManager.getInstance().createActionToolbar(place, (ActionGroup)actionGroup, true).getComponent();
        if (jComponent == null) {
            PhpUiUtil.$$$reportNull$$$0(21);
        }
        return jComponent;
    }

    public static String getShortcutTextByActionName(@NotNull String actionName) {
        if (actionName == null) {
            PhpUiUtil.$$$reportNull$$$0(22);
        }
        return KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction(actionName));
    }

    public static void showBalloon(@NotNull @NlsContexts.PopupContent String message, @NotNull MessageType messageType, @NotNull Component component) {
        if (message == null) {
            PhpUiUtil.$$$reportNull$$$0(23);
        }
        if (messageType == null) {
            PhpUiUtil.$$$reportNull$$$0(24);
        }
        if (component == null) {
            PhpUiUtil.$$$reportNull$$$0(25);
        }
        Rectangle rect = component.getBounds();
        Point p = new Point(rect.x, rect.y + rect.height);
        PhpUiUtil.showBalloon(message, messageType, new RelativePoint(component, p));
    }

    public static void showBalloon(@NotNull @NlsContexts.PopupContent String message, @NotNull MessageType messageType, @NotNull MouseEvent event) {
        if (message == null) {
            PhpUiUtil.$$$reportNull$$$0(26);
        }
        if (messageType == null) {
            PhpUiUtil.$$$reportNull$$$0(27);
        }
        if (event == null) {
            PhpUiUtil.$$$reportNull$$$0(28);
        }
        PhpUiUtil.showBalloon(message, messageType, new RelativePoint(event));
    }

    private static void showBalloon(@NotNull @NlsContexts.PopupContent String message, @NotNull MessageType messageType, @NotNull RelativePoint point) {
        if (message == null) {
            PhpUiUtil.$$$reportNull$$$0(29);
        }
        if (messageType == null) {
            PhpUiUtil.$$$reportNull$$$0(30);
        }
        if (point == null) {
            PhpUiUtil.$$$reportNull$$$0(31);
        }
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, messageType.getDefaultIcon(), messageType.getPopupBackground(), null);
        balloonBuilder.setFadeoutTime(messageType == MessageType.INFO ? 1500L : 10000L);
        Balloon balloon = balloonBuilder.createBalloon();
        balloon.show(point, Balloon.Position.below);
        Disposer.register((Disposable)PhpRefactoringSettings.getInstance(), (Disposable)balloon);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/ui/PhpUiUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isEnabledComputable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 23: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 24: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/ui/PhpUiUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toRedColorHtml";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createHorizontalActionsToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFileOrProjectRoot";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "requestFocusIfAppInactive";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIntValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toRedColorHtml";
                break;
            }
            case 5: 
            case 21: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "surroundWithHtml";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "surroundFontColorRed";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "editConfigurable";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleAction";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createReloadAction";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createShowPhpInfoAction";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createHorizontalActionsToolbar";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getShortcutTextByActionName";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "showBalloon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

