/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.ui;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.ui.PhpExpandableInfoComponent;
import com.jetbrains.php.ui.PhpInfoLabelPanel;
import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpExpandableInfoLabelPanel
extends PhpInfoLabelPanel {
    protected final PhpExpandableInfoComponent myExpandableLabel;

    protected PhpExpandableInfoLabelPanel(@NotNull String title, @NotNull Icon icon, @NotNull @Nls String additionalInfo, boolean adjustWindow, boolean isExpanded) {
        if (title == null) {
            PhpExpandableInfoLabelPanel.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            PhpExpandableInfoLabelPanel.$$$reportNull$$$0(1);
        }
        if (additionalInfo == null) {
            PhpExpandableInfoLabelPanel.$$$reportNull$$$0(2);
        }
        super(new BorderLayout());
        String fullTitle = "<html>" + title + " <a href=\"#\">(...)</a>";
        this.myExpandableLabel = this.createInfoComponent(fullTitle, icon, adjustWindow);
        JTextPane infoArea = new JTextPane();
        infoArea.setEditorKit(UIUtil.getHTMLEditorKit());
        this.installHyperlinkSupport(infoArea);
        infoArea.setText(this.prepareAdditionalInfo(additionalInfo));
        infoArea.setEditable(false);
        infoArea.setBackground(UIUtil.getPanelBackground().brighter());
        infoArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIUtil.getBoundsColor()), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        infoArea.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HelpManager.getInstance().invokeHelp(e.getDescription());
                }
            }
        });
        this.myExpandableLabel.setContentComponent(infoArea);
        this.myExpandableLabel.setOn(isExpanded);
    }

    @NotNull
    @Nls
    protected String prepareAdditionalInfo(@NotNull @Nls String additionalInfo) {
        if (additionalInfo == null) {
            PhpExpandableInfoLabelPanel.$$$reportNull$$$0(3);
        }
        String string = additionalInfo;
        if (string == null) {
            PhpExpandableInfoLabelPanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected void installHyperlinkSupport(@NotNull JTextPane infoArea) {
        if (infoArea == null) {
            PhpExpandableInfoLabelPanel.$$$reportNull$$$0(5);
        }
        Messages.installHyperlinkSupport((JTextPane)infoArea);
    }

    @NotNull
    public PhpExpandableInfoComponent createInfoComponent(@NotNull String title, @NotNull Icon icon, boolean adjustWindow) {
        if (title == null) {
            PhpExpandableInfoLabelPanel.$$$reportNull$$$0(6);
        }
        if (icon == null) {
            PhpExpandableInfoLabelPanel.$$$reportNull$$$0(7);
        }
        PhpExpandableInfoLabel phpExpandableInfoLabel = PhpExpandableInfoLabel.create(this, title, icon, adjustWindow);
        if (phpExpandableInfoLabel == null) {
            PhpExpandableInfoLabelPanel.$$$reportNull$$$0(8);
        }
        return phpExpandableInfoLabel;
    }

    public void setOn(boolean on) {
        this.myExpandableLabel.setOn(on);
    }

    public boolean isExpanded() {
        return this.myExpandableLabel.isExpanded();
    }

    public void setText(@NlsContexts.Label String title) {
        this.myExpandableLabel.setText(title);
    }

    public String getText() {
        return this.myExpandableLabel.getText();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myExpandableLabel.setEnabled(enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalInfo";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/ui/PhpExpandableInfoLabelPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/ui/PhpExpandableInfoLabelPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareAdditionalInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createInfoComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareAdditionalInfo";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "installHyperlinkSupport";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createInfoComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpExpandableInfoLabel
    extends PhpExpandableInfoComponent<JLabel> {
        public static PhpExpandableInfoLabel create(JPanel panel2, String title, Icon icon, boolean adjustWindow) {
            PhpExpandableInfoLabel label = new PhpExpandableInfoLabel(panel2, adjustWindow);
            label.init(title, icon);
            return label;
        }

        PhpExpandableInfoLabel(JPanel panel2, boolean adjustWindow) {
            super(panel2, adjustWindow);
        }

        @Override
        protected JLabel createCenterComponent(@NotNull @Nls String text, @NotNull Icon icon) {
            if (text == null) {
                PhpExpandableInfoLabel.$$$reportNull$$$0(0);
            }
            if (icon == null) {
                PhpExpandableInfoLabel.$$$reportNull$$$0(1);
            }
            JLabel label = new JLabel(text);
            label.setIcon(icon);
            return label;
        }

        @Override
        protected JLabel getLabel() {
            return (JLabel)this.myComponent;
        }

        @Override
        public void setText(@NlsContexts.Label String title) {
            this.getLabel().setText(title);
        }

        @Override
        @NlsSafe
        public String getText() {
            return this.getLabel().getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/ui/PhpExpandableInfoLabelPanel$PhpExpandableInfoLabel";
            objectArray[2] = "createCenterComponent";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

