/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.ui;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpExpandableInfoComponent<L extends JComponent> {
    private final JPanel myPanel;
    protected L myComponent;
    private final boolean myAdjustWindow;
    private boolean myOn;
    private JComponent myContent;
    private Dimension myPreviousContentSize;

    public PhpExpandableInfoComponent(JPanel panel2, boolean adjustWindow) {
        this.myPanel = panel2;
        this.myAdjustWindow = adjustWindow;
    }

    public void init(@NotNull String title, @NotNull Icon icon) {
        if (title == null) {
            PhpExpandableInfoComponent.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            PhpExpandableInfoComponent.$$$reportNull$$$0(1);
        }
        this.init(title, icon, null);
    }

    public void init(@NotNull String title, @NotNull Icon icon, @Nullable JComponent northEastComponent) {
        if (title == null) {
            PhpExpandableInfoComponent.$$$reportNull$$$0(2);
        }
        if (icon == null) {
            PhpExpandableInfoComponent.$$$reportNull$$$0(3);
        }
        this.myComponent = this.createCenterComponent(title, icon);
        this.getLabel().setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)this.myComponent, "Center");
        if (northEastComponent != null) {
            northPanel.add((Component)northEastComponent, "East");
        }
        this.myPanel.add((Component)northPanel, "North");
        ((Component)this.myComponent).setCursor(Cursor.getPredefinedCursor(12));
        this.updateIcon();
        ((Component)this.myComponent).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PhpExpandableInfoComponent.this.myOn) {
                    PhpExpandableInfoComponent.this.off();
                } else {
                    PhpExpandableInfoComponent.this.on();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/ui/PhpExpandableInfoComponent$1", "mouseReleased"));
            }
        });
    }

    protected abstract L createCenterComponent(@NotNull String var1, @NotNull Icon var2);

    protected abstract JLabel getLabel();

    protected void updateIcon() {
    }

    public void setContentComponent(@Nullable JComponent content) {
        if (content == null && this.myContent != null) {
            this.myPanel.remove(this.myContent);
        }
        this.myContent = content;
        if (this.myContent != null) {
            this.myContent.setVisible(this.myOn);
            this.myPanel.add((Component)this.myContent, "Center");
        }
    }

    public void setOn(boolean on) {
        this.myOn = on;
        if (this.myOn) {
            this.on();
        } else {
            this.off();
        }
    }

    public boolean isExpanded() {
        return this.myOn;
    }

    public abstract void setText(@NlsContexts.Label String var1);

    @NlsSafe
    public abstract String getText();

    protected void on() {
        this.myOn = true;
        this.updateIcon();
        this.getLabel().setIconTextGap(5);
        if (this.myContent != null) {
            this.myContent.setVisible(true);
        }
        this.adjustWindow();
        this.myPanel.invalidate();
        this.myPanel.repaint();
    }

    protected void off() {
        this.myOn = false;
        this.updateIcon();
        if (this.myContent != null) {
            this.myContent.setVisible(false);
            this.myPreviousContentSize = this.myContent.getSize();
        }
        this.adjustWindow();
        this.myPanel.invalidate();
        this.myPanel.repaint();
    }

    private void adjustWindow() {
        if (!this.myAdjustWindow) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(this.myPanel);
        if (window == null) {
            return;
        }
        Dimension size = window.getSize();
        Dimension contentSize = this.myPreviousContentSize != null && this.myPreviousContentSize.width > 0 && this.myPreviousContentSize.height > 0 ? this.myPreviousContentSize : this.myContent.getPreferredSize();
        Dimension newSize = this.myOn ? new Dimension(Math.max(size.width, this.myContent.getSize().width), size.height + contentSize.height) : new Dimension(size.width, size.height - contentSize.height);
        if (!newSize.equals(size)) {
            SwingUtilities.invokeLater(() -> {
                if (window.isShowing()) {
                    window.setSize(newSize);
                }
            });
        }
    }

    public void setEnabled(boolean enabled) {
        ((JComponent)this.myComponent).setEnabled(enabled);
        this.myContent.setEnabled(enabled);
    }

    private void registerMnemonic() {
        int mnemonicIndex = UIUtil.getDisplayMnemonicIndex((String)this.getText());
        if (mnemonicIndex != -1) {
            this.myPanel.getActionMap().put("Collapse/Expand on mnemonic", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PhpExpandableInfoComponent.this.myOn) {
                        PhpExpandableInfoComponent.this.off();
                    } else {
                        PhpExpandableInfoComponent.this.on();
                    }
                }
            });
            char mnemonicCharacter = StringUtil.toUpperCase((String)UIUtil.removeMnemonic((String)this.getText())).charAt(mnemonicIndex);
            this.myPanel.getInputMap(2).put(KeyStroke.getKeyStroke(mnemonicCharacter, 8, false), "Collapse/Expand on mnemonic");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "icon";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/ui/PhpExpandableInfoComponent";
        objectArray[2] = "init";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

