/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.ui;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.php.PhpBundle;
import gnu.trove.THashMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class PhpAbstractFileTreeTable<T>
extends TreeTable {
    private final MyModel<T> myModel;
    private final Project myProject;

    public PhpAbstractFileTreeTable(@NotNull Project project, @NotNull Class<T> valueClass, @NotNull @NlsContexts.ColumnName String valueTitle) {
        if (project == null) {
            PhpAbstractFileTreeTable.$$$reportNull$$$0(0);
        }
        if (valueClass == null) {
            PhpAbstractFileTreeTable.$$$reportNull$$$0(1);
        }
        if (valueTitle == null) {
            PhpAbstractFileTreeTable.$$$reportNull$$$0(2);
        }
        this(project, valueClass, valueTitle, new ProjectContentFileFilter(project));
    }

    public PhpAbstractFileTreeTable(@NotNull Project project, @NotNull Class<T> valueClass, @NotNull @NlsContexts.ColumnName String valueTitle, @NotNull VirtualFileFilter filter) {
        if (project == null) {
            PhpAbstractFileTreeTable.$$$reportNull$$$0(3);
        }
        if (valueClass == null) {
            PhpAbstractFileTreeTable.$$$reportNull$$$0(4);
        }
        if (valueTitle == null) {
            PhpAbstractFileTreeTable.$$$reportNull$$$0(5);
        }
        if (filter == null) {
            PhpAbstractFileTreeTable.$$$reportNull$$$0(6);
        }
        this(project, new MyModel<T>(project, valueClass, valueTitle, filter), valueClass, valueTitle);
    }

    public PhpAbstractFileTreeTable(@NotNull Project project, @NotNull Class<T> valueClass, @NotNull @NlsContexts.ColumnName String valueTitle, ProjectRootNode @NotNull [] roots) {
        if (project == null) {
            PhpAbstractFileTreeTable.$$$reportNull$$$0(7);
        }
        if (valueClass == null) {
            PhpAbstractFileTreeTable.$$$reportNull$$$0(8);
        }
        if (valueTitle == null) {
            PhpAbstractFileTreeTable.$$$reportNull$$$0(9);
        }
        if (roots == null) {
            PhpAbstractFileTreeTable.$$$reportNull$$$0(10);
        }
        this(project, new MyModel<T>(project, valueClass, valueTitle, roots), valueClass, valueTitle);
    }

    private PhpAbstractFileTreeTable(Project project, TreeTableModel model, Class<T> valueClass, String valueTitle) {
        super(model);
        this.myProject = project;
        this.myModel = (MyModel)this.getTableModel();
        this.myModel.setTreeTable(this);
        new TreeTableSpeedSearch((TreeTable)this, o -> {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)o.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (userObject == null) {
                return this.getProjectNodeText();
            }
            if (userObject instanceof VirtualFile) {
                return ((VirtualFile)userObject).getName();
            }
            return node.toString();
        });
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)this.getTree());
        CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)treeExpander, (JComponent)((Object)this));
        CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)treeExpander, (JComponent)((Object)this));
        this.getTree().setShowsRootHandles(true);
        this.getTree().setRootVisible(false);
        this.getTree().setCellRenderer((TreeCellRenderer)new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof MyRootNode) {
                    return this;
                }
                if (value instanceof ProjectRootNode) {
                    this.setText(((ProjectRootNode)value).getPresentableText());
                    this.setIcon(((ProjectRootNode)value).getIcon(expanded));
                    return this;
                }
                FileNode fileNode = (FileNode)value;
                VirtualFile file = (VirtualFile)fileNode.getObject();
                if (fileNode.getParent() instanceof FileNode) {
                    this.setText(file.getName());
                } else {
                    this.setText(file.getPresentableUrl());
                }
                Icon icon = file.isDirectory() ? PlatformIcons.FOLDER_ICON : IconUtil.getIcon((VirtualFile)file, (int)0, null);
                this.setIcon(icon);
                return this;
            }
        });
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(0);
        this.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)300, (int)-1));
        this.setVisibleRowCount(10);
        this.getColumnModel().getColumn(0).setPreferredWidth(280);
        this.getColumnModel().getColumn(1).setPreferredWidth(280);
    }

    protected boolean isNullObject(T value) {
        return false;
    }

    private String getProjectNodeText() {
        return "Project";
    }

    public TableColumn getValueColumn() {
        return this.getColumnModel().getColumn(1);
    }

    protected boolean isValueEditableForFile(VirtualFile virtualFile) {
        return true;
    }

    public static void press(Container comboComponent) {
        if (comboComponent instanceof JButton) {
            JButton button = (JButton)comboComponent;
            button.doClick();
        } else {
            for (int i = 0; i < comboComponent.getComponentCount(); ++i) {
                Component child = comboComponent.getComponent(i);
                if (!(child instanceof Container)) continue;
                PhpAbstractFileTreeTable.press((Container)child);
            }
        }
    }

    public boolean clearSubdirectoriesOnDemandOrCancel(VirtualFile parent, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title) {
        Map mappings = this.myModel.myCurrentMapping;
        THashMap subdirectoryMappings = new THashMap();
        for (VirtualFile file : mappings.keySet()) {
            if (file == null || parent != null && !VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)file, (boolean)true)) continue;
            subdirectoryMappings.put(file, mappings.get(file));
        }
        if (subdirectoryMappings.isEmpty()) {
            return true;
        }
        int ret = Messages.showYesNoCancelDialog((Project)this.myProject, (String)message, (String)title, (String)PhpBundle.message("override", new Object[0]), (String)PhpBundle.message("do.not.override", new Object[0]), (String)PhpBundle.message("cancel", new Object[0]), (Icon)Messages.getWarningIcon());
        if (ret == 0) {
            for (VirtualFile file : subdirectoryMappings.keySet()) {
                this.myModel.setValueAt(null, new DefaultMutableTreeNode(file), 1);
            }
        }
        return ret != 2;
    }

    public Map<VirtualFile, T> getValues() {
        return this.myModel.getValues();
    }

    public TreeTableCellRenderer createTableRenderer(TreeTableModel treeTableModel) {
        TreeTableCellRenderer tableRenderer = super.createTableRenderer(treeTableModel);
        tableRenderer.setRootVisible(false);
        tableRenderer.setShowsRootHandles(true);
        return tableRenderer;
    }

    public void reset(Map<VirtualFile, T> mappings) {
        this.myModel.reset(mappings);
        TreeNode root = (TreeNode)this.myModel.getRoot();
        this.myModel.nodeChanged(root);
        this.getTree().setModel(null);
        this.getTree().setModel(this.myModel);
    }

    public void select(VirtualFile toSelect) {
        if (toSelect != null) {
            this.select(toSelect, (TreeNode)this.myModel.getRoot());
        }
    }

    private void select(@NotNull VirtualFile toSelect, TreeNode root) {
        if (toSelect == null) {
            PhpAbstractFileTreeTable.$$$reportNull$$$0(11);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            TreeNode child = root.getChildAt(i);
            VirtualFile file = (VirtualFile)((FileNode)child).getObject();
            if (!VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)toSelect, (boolean)false)) continue;
            if (Comparing.equal((Object)file, (Object)toSelect)) {
                TreeUtil.selectNode((JTree)this.getTree(), (TreeNode)child);
                this.getSelectionModel().clearSelection();
                this.addSelectedPath(TreeUtil.getPathFromRoot((TreeNode)child));
                TableUtil.scrollSelectionToVisible((JTable)((Object)this));
            } else {
                this.select(toSelect, child);
            }
            return;
        }
    }

    public void expandValues(@NotNull Component parent) {
        if (parent == null) {
            PhpAbstractFileTreeTable.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Map values = this.getValues();
            HashSet treeNodes = new HashSet();
            TreeNode root = (TreeNode)this.getTableModel().getRoot();
            Ref wasShown = new Ref((Object)false);
            TreeUtil.traverse((TreeNode)root, node -> {
                VirtualFile file;
                if (!((Boolean)wasShown.get()).booleanValue() && parent.isShowing()) {
                    wasShown.set((Object)true);
                }
                if (((Boolean)wasShown.get()).booleanValue() && !parent.isShowing()) {
                    return false;
                }
                if (node instanceof ProjectRootNode) {
                    treeNodes.add((TreeNode)node);
                } else if (node instanceof FileNode && values.containsKey(file = (VirtualFile)((FileNode)node).getObject())) {
                    treeNodes.add(((TreeNode)node).getParent());
                }
                return true;
            });
            ArrayList<TreePath> pathsToExpand = new ArrayList<TreePath>();
            for (TreeNode treeNode : treeNodes) {
                pathsToExpand.add(TreeUtil.getPath((TreeNode)root, (TreeNode)treeNode));
            }
            UIUtil.invokeLaterIfNeeded(() -> TreeUtil.restoreExpandedPaths((JTree)this.getTree(), (List)pathsToExpand));
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueTitle";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/ui/PhpAbstractFileTreeTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "expandValues";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ProjectContentFileFilter
    implements VirtualFileFilter {
        private final ProjectFileIndex myFileIndex;

        public ProjectContentFileFilter(Project project) {
            this.myFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        }

        public boolean accept(@NotNull VirtualFile file) {
            if (file == null) {
                ProjectContentFileFilter.$$$reportNull$$$0(0);
            }
            return this.myFileIndex.isInContent(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/php/ui/PhpAbstractFileTreeTable$ProjectContentFileFilter", "accept"));
        }
    }

    public static class FileNode
    extends ConvenientNode<VirtualFile> {
        private final Project myProject;
        private final VirtualFileFilter myFilter;

        public FileNode(@NotNull VirtualFile file, @NotNull Project project) {
            if (file == null) {
                FileNode.$$$reportNull$$$0(0);
            }
            if (project == null) {
                FileNode.$$$reportNull$$$0(1);
            }
            this(file, project, VirtualFileFilter.ALL);
        }

        public FileNode(@NotNull VirtualFile file, @NotNull Project project, @NotNull VirtualFileFilter filter) {
            if (file == null) {
                FileNode.$$$reportNull$$$0(2);
            }
            if (project == null) {
                FileNode.$$$reportNull$$$0(3);
            }
            if (filter == null) {
                FileNode.$$$reportNull$$$0(4);
            }
            super(file);
            this.myProject = project;
            this.myFilter = filter;
        }

        @Override
        protected void appendChildrenTo(Collection<ConvenientNode> children) {
            VirtualFile[] childrenf;
            for (VirtualFile child : childrenf = ((VirtualFile)this.getObject()).getChildren()) {
                if (!this.myFilter.accept(child)) continue;
                children.add(new FileNode(child, this.myProject, this.myFilter));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filter";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/ui/PhpAbstractFileTreeTable$FileNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ProjectRootContentsNode
    extends ProjectRootNode {
        public ProjectRootContentsNode(@NotNull Project project) {
            if (project == null) {
                ProjectRootContentsNode.$$$reportNull$$$0(0);
            }
            super(project);
        }

        public ProjectRootContentsNode(@NotNull Project project, @NotNull VirtualFileFilter filter) {
            if (project == null) {
                ProjectRootContentsNode.$$$reportNull$$$0(1);
            }
            if (filter == null) {
                ProjectRootContentsNode.$$$reportNull$$$0(2);
            }
            super(project, filter);
        }

        @Override
        protected VirtualFile[] getRoots() {
            return ProjectRootManager.getInstance((Project)((Project)this.getObject())).getContentRoots();
        }

        @Override
        @Nls
        protected String getPresentableText() {
            return PhpBundle.message("project.files", new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filter";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/ui/PhpAbstractFileTreeTable$ProjectRootContentsNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ProjectRootNode
    extends ConvenientNode<Project> {
        private final VirtualFileFilter myFilter;

        public ProjectRootNode(@NotNull Project project) {
            if (project == null) {
                ProjectRootNode.$$$reportNull$$$0(0);
            }
            this(project, VirtualFileFilter.ALL);
        }

        public ProjectRootNode(@NotNull Project project, @NotNull VirtualFileFilter filter) {
            if (project == null) {
                ProjectRootNode.$$$reportNull$$$0(1);
            }
            if (filter == null) {
                ProjectRootNode.$$$reportNull$$$0(2);
            }
            super(project);
            this.myFilter = filter;
        }

        @Override
        protected final void appendChildrenTo(Collection<ConvenientNode> children) {
            VirtualFile[] roots;
            Project project = (Project)this.getObject();
            block0: for (VirtualFile root : roots = this.getRoots()) {
                for (VirtualFile candidate : roots) {
                    if (VfsUtilCore.isAncestor((VirtualFile)candidate, (VirtualFile)root, (boolean)true)) continue block0;
                }
                if (!this.myFilter.accept(root)) continue;
                children.add(new FileNode(root, project, this.myFilter));
            }
        }

        protected VirtualFileFilter getFilter() {
            return this.myFilter;
        }

        protected abstract VirtualFile[] getRoots();

        @Nls
        protected abstract String getPresentableText();

        public Icon getIcon(boolean expanded) {
            return PlatformIcons.FOLDER_ICON;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filter";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/ui/PhpAbstractFileTreeTable$ProjectRootNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyRootNode
    extends ConvenientNode<Project> {
        final ProjectRootNode[] myProjectRoots;

        public MyRootNode(Project project, ProjectRootNode[] projectRoots) {
            super(project);
            this.myProjectRoots = projectRoots;
        }

        @Override
        protected void appendChildrenTo(Collection<ConvenientNode> children) {
            children.addAll(Arrays.asList(this.myProjectRoots));
        }
    }

    public static abstract class ConvenientNode<T>
    extends DefaultMutableTreeNode {
        private final T myObject;

        private ConvenientNode(T object) {
            this.myObject = object;
        }

        public T getObject() {
            return this.myObject;
        }

        protected abstract void appendChildrenTo(Collection<ConvenientNode> var1);

        @Override
        public int getChildCount() {
            this.init();
            return super.getChildCount();
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            this.init();
            return super.getChildAt(childIndex);
        }

        public Enumeration children() {
            this.init();
            return super.children();
        }

        private void init() {
            if (this.getUserObject() == null) {
                this.setUserObject(this.myObject);
                ArrayList<ConvenientNode> children = new ArrayList<ConvenientNode>();
                this.appendChildrenTo(children);
                children.sort((node1, node2) -> {
                    Object o2;
                    Object o1 = node1.getObject();
                    if (o1 == (o2 = node2.getObject())) {
                        return 0;
                    }
                    if (o1 instanceof Project) {
                        return -1;
                    }
                    if (o2 instanceof Project) {
                        return 1;
                    }
                    VirtualFile file1 = (VirtualFile)o1;
                    VirtualFile file2 = (VirtualFile)o2;
                    if (file1.isDirectory() != file2.isDirectory()) {
                        return file1.isDirectory() ? -1 : 1;
                    }
                    return file1.getName().compareTo(file2.getName());
                });
                int i = 0;
                for (ConvenientNode child : children) {
                    this.insert(child, i++);
                }
            }
        }

        public void clearCachedChildren() {
            if (this.children != null) {
                for (Object child : this.children) {
                    ConvenientNode node = (ConvenientNode)child;
                    node.clearCachedChildren();
                }
            }
            this.removeAllChildren();
            this.setUserObject(null);
        }
    }

    private static final class MyModel<T>
    extends DefaultTreeModel
    implements TreeTableModel {
        private final Map<VirtualFile, T> myCurrentMapping;
        private final Class<T> myValueClass;
        private final @NlsContexts.ColumnName String myValueTitle;
        private PhpAbstractFileTreeTable<T> myTreeTable;

        private MyModel(Project project, Class<T> valueClass, @NlsContexts.ColumnName String valueTitle, VirtualFileFilter filter) {
            this(project, valueClass, valueTitle, new ProjectRootNode[]{new ProjectRootContentsNode(project, filter)});
        }

        private MyModel(Project project, Class<T> valueClass, @NlsContexts.ColumnName String valueTitle, ProjectRootNode @NotNull [] roots) {
            if (roots == null) {
                MyModel.$$$reportNull$$$0(0);
            }
            super(new MyRootNode(project, roots));
            this.myCurrentMapping = new HashMap<VirtualFile, T>();
            this.myValueClass = valueClass;
            this.myValueTitle = valueTitle;
        }

        private Map<VirtualFile, T> getValues() {
            return new HashMap<VirtualFile, T>(this.myCurrentMapping);
        }

        public void setTree(JTree tree) {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return PhpBundle.message("column.name.file.directory", new Object[0]);
                }
                case 1: {
                    return this.myValueTitle;
                }
            }
            throw new RuntimeException("invalid column " + column);
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return TreeTableModel.class;
                }
                case 1: {
                    return this.myValueClass;
                }
            }
            throw new RuntimeException("invalid column " + column);
        }

        public Object getValueAt(Object node, int column) {
            Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
            if (userObject instanceof Project) {
                switch (column) {
                    case 0: {
                        return userObject;
                    }
                    case 1: {
                        return this.myCurrentMapping.get(null);
                    }
                }
            }
            VirtualFile file = (VirtualFile)userObject;
            switch (column) {
                case 0: {
                    return file;
                }
                case 1: {
                    return this.myCurrentMapping.get(file);
                }
            }
            throw new RuntimeException("invalid column " + column);
        }

        public boolean isCellEditable(Object node, int column) {
            switch (column) {
                case 0: {
                    return false;
                }
                case 1: {
                    Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
                    return userObject instanceof VirtualFile && this.myTreeTable.isValueEditableForFile((VirtualFile)userObject);
                }
            }
            throw new RuntimeException("invalid column " + column);
        }

        public void setValueAt(Object aValue, Object node, int column) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
            Object userObject = treeNode.getUserObject();
            if (userObject instanceof Project) {
                return;
            }
            VirtualFile file = (VirtualFile)userObject;
            Object t = aValue;
            if (t == null || this.myTreeTable.isNullObject(t)) {
                this.myCurrentMapping.remove(file);
            } else {
                this.myCurrentMapping.put(file, t);
            }
            this.fireTreeNodesChanged(this, new Object[]{this.getRoot()}, null, null);
        }

        public void reset(Map<VirtualFile, T> mappings) {
            this.myCurrentMapping.clear();
            this.myCurrentMapping.putAll(mappings);
            ((MyRootNode)this.getRoot()).clearCachedChildren();
        }

        void setTreeTable(PhpAbstractFileTreeTable<T> treeTable) {
            this.myTreeTable = treeTable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/jetbrains/php/ui/PhpAbstractFileTreeTable$MyModel", "<init>"));
        }
    }
}

