/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpcs;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.tools.quality.QualityToolAnnotatorInfo;
import com.jetbrains.php.tools.quality.QualityToolMessage;
import com.jetbrains.php.tools.quality.QualityToolType;
import com.jetbrains.php.tools.quality.QualityToolXmlMessageProcessor;
import com.jetbrains.php.tools.quality.phpcs.PhpCSBeautifierReformatFileAction;
import com.jetbrains.php.tools.quality.phpcs.PhpCSQualityToolType;
import com.jetbrains.php.tools.quality.phpcs.PhpCSValidationInspection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public class PhpCSXmlMessageProcessor
extends QualityToolXmlMessageProcessor {
    private static final String ERROR_MESSAGE_START = "<error";
    @NonNls
    private static final String ERROR_MESSAGE_END = "</error>";
    private static final String ERROR_TAG = "error";
    private static final String WARNING_MESSAGE_START = "<warning";
    @NonNls
    private static final String WARNING_MESSAGE_END = "</warning>";
    private static final String WARNING_TAG = "warning";
    @NonNls
    private static final String LINE_NUMBER_ATTR = "line";
    @NonNls
    private static final String SNIFF_NAME_ATTR = "source";
    @NonNls
    private static final String FIXABLE_NAME_ATTR = "fixable";
    public static final PhpCSBeautifierReformatFileAction REFORMAT_FILE_ACTION = new PhpCSBeautifierReformatFileAction();
    private final HighlightDisplayLevel myWarningsHighlightLevel;
    private final boolean myShowSniffNames;

    protected PhpCSXmlMessageProcessor(QualityToolAnnotatorInfo info, boolean showSniffNames) {
        super(info);
        this.myWarningsHighlightLevel = ((PhpCSValidationInspection)((Object)info.getInspection())).getWarningLevel();
        this.myShowSniffNames = showSniffNames;
    }

    @Override
    protected QualityToolXmlMessageProcessor.XMLMessageHandler getXmlMessageHandler() {
        return new PhpCsXmlMessageHandler();
    }

    @Override
    public int getMessageStart(@NotNull String line) {
        int messageStart;
        if (line == null) {
            PhpCSXmlMessageProcessor.$$$reportNull$$$0(0);
        }
        if ((messageStart = line.indexOf(ERROR_MESSAGE_START)) < 0) {
            messageStart = line.indexOf(WARNING_MESSAGE_START);
        }
        return messageStart;
    }

    @Override
    public int getMessageEnd(@NotNull String line) {
        int messageEnd;
        if (line == null) {
            PhpCSXmlMessageProcessor.$$$reportNull$$$0(1);
        }
        if ((messageEnd = line.indexOf(ERROR_MESSAGE_END)) < 0) {
            messageEnd = line.indexOf(WARNING_MESSAGE_END);
        }
        return messageEnd;
    }

    @Override
    protected IntentionAction @NotNull [] getQuickFix(QualityToolXmlMessageProcessor.XMLMessageHandler messageHandler) {
        if (messageHandler instanceof PhpCsXmlMessageHandler && ((PhpCsXmlMessageHandler)messageHandler).myFixable) {
            IntentionAction[] intentionActionArray = new IntentionAction[]{REFORMAT_FILE_ACTION};
            if (intentionActionArray == null) {
                PhpCSXmlMessageProcessor.$$$reportNull$$$0(2);
            }
            return intentionActionArray;
        }
        if (IntentionAction.EMPTY_ARRAY == null) {
            PhpCSXmlMessageProcessor.$$$reportNull$$$0(3);
        }
        return IntentionAction.EMPTY_ARRAY;
    }

    @Override
    @NonNls
    @Nullable
    protected String getMessagePrefix() {
        return "phpcs";
    }

    @Override
    @Nullable
    protected HighlightDisplayLevel severityToDisplayLevel(@NotNull QualityToolMessage.Severity severity) {
        if (severity == null) {
            PhpCSXmlMessageProcessor.$$$reportNull$$$0(4);
        }
        return QualityToolMessage.Severity.WARNING.equals((Object)severity) ? this.myWarningsHighlightLevel : null;
    }

    @Override
    protected QualityToolType getQualityToolType() {
        return PhpCSQualityToolType.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = LINE_NUMBER_ATTR;
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/phpcs/PhpCSXmlMessageProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/phpcs/PhpCSXmlMessageProcessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMessageStart";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMessageEnd";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "severityToDisplayLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PhpCsXmlMessageHandler
    extends QualityToolXmlMessageProcessor.XMLMessageHandler {
        private String mySniffName;
        private boolean myFixable = false;

        private PhpCsXmlMessageHandler() {
        }

        @Override
        protected void parseTag(@NotNull String tagName, @NotNull Attributes attributes) {
            if (tagName == null) {
                PhpCsXmlMessageHandler.$$$reportNull$$$0(0);
            }
            if (attributes == null) {
                PhpCsXmlMessageHandler.$$$reportNull$$$0(1);
            }
            if (PhpCSXmlMessageProcessor.ERROR_TAG.equals(tagName)) {
                this.mySeverity = QualityToolMessage.Severity.ERROR;
            } else if (PhpCSXmlMessageProcessor.WARNING_TAG.equals(tagName)) {
                this.mySeverity = QualityToolMessage.Severity.WARNING;
            }
            this.myLineNumber = PhpCsXmlMessageHandler.parseLineNumber(attributes.getValue(PhpCSXmlMessageProcessor.LINE_NUMBER_ATTR));
            this.mySniffName = attributes.getValue(PhpCSXmlMessageProcessor.SNIFF_NAME_ATTR);
            this.myFixable = StringUtil.equals((CharSequence)attributes.getValue(PhpCSXmlMessageProcessor.FIXABLE_NAME_ATTR), (CharSequence)"1");
        }

        @Override
        public String getMessageText() {
            String messageText = super.getMessageText();
            return PhpCSXmlMessageProcessor.this.myShowSniffNames && this.mySniffName != null ? this.mySniffName + ": " + messageText : messageText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tagName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "attributes";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/tools/quality/phpcs/PhpCSXmlMessageProcessor$PhpCsXmlMessageHandler";
            objectArray[2] = "parseTag";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

