/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpcs;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.util.SmartList;
import com.jetbrains.php.tools.quality.QualityToolAnnotator;
import com.jetbrains.php.tools.quality.QualityToolValidationInspection;
import com.jetbrains.php.tools.quality.phpcs.PhpCSAnnotatorProxy;
import com.jetbrains.php.tools.quality.phpcs.PhpCSOptionsPanel;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PhpCSValidationInspection
extends QualityToolValidationInspection
implements CleanupLocalInspectionTool {
    public static final String DISPLAY_NAME = "PHP_CodeSniffer Validation";
    public boolean IGNORE_WARNINGS = false;
    @NlsSafe
    public String CODING_STANDARD = "PSR2";
    public String CUSTOM_RULESET_PATH = "";
    public String WARNING_HIGHLIGHT_LEVEL_NAME;
    public boolean SHOW_SNIFF_NAMES;
    public boolean USE_INSTALLED_PATHS;
    @NlsSafe
    public String INSTALLED_PATHS;
    public boolean CHECK_PHP;
    public boolean CHECK_INC;
    public boolean CHECK_JS;
    public boolean CHECK_CSS;
    public String EXTENSIONS;

    public PhpCSValidationInspection() {
        this.WARNING_HIGHLIGHT_LEVEL_NAME = HighlightSeverity.WARNING.myName;
        this.SHOW_SNIFF_NAMES = false;
        this.USE_INSTALLED_PATHS = false;
        this.INSTALLED_PATHS = "";
        this.CHECK_PHP = true;
        this.CHECK_INC = true;
        this.CHECK_JS = true;
        this.CHECK_CSS = true;
        this.EXTENSIONS = null;
    }

    public JComponent createOptionsPanel() {
        PhpCSOptionsPanel optionsPanel = new PhpCSOptionsPanel(this);
        optionsPanel.init();
        return optionsPanel.getOptionsPanel();
    }

    @Override
    @NotNull
    protected QualityToolAnnotator getAnnotator() {
        PhpCSAnnotatorProxy phpCSAnnotatorProxy = PhpCSAnnotatorProxy.INSTANCE;
        if (phpCSAnnotatorProxy == null) {
            PhpCSValidationInspection.$$$reportNull$$$0(0);
        }
        return phpCSAnnotatorProxy;
    }

    @Override
    @NlsSafe
    public String getToolName() {
        return "PHP_CodeSniffer";
    }

    HighlightDisplayLevel getWarningLevel() {
        HighlightDisplayLevel level;
        HighlightSeverity severity = InspectionProfileManager.getInstance().getSeverityRegistrar().getSeverity(this.WARNING_HIGHLIGHT_LEVEL_NAME);
        if (severity != null && (level = HighlightDisplayLevel.find((HighlightSeverity)severity)) != null) {
            return level;
        }
        return HighlightDisplayLevel.WARNING;
    }

    void setWarningLevel(HighlightDisplayLevel level) {
        this.WARNING_HIGHLIGHT_LEVEL_NAME = level.getSeverity().myName;
    }

    public String getExtensions() {
        if (this.EXTENSIONS == null) {
            this.transferOldSettings();
        }
        return StringUtil.isEmpty((String)this.EXTENSIONS) ? "" : "--extensions=" + StringUtil.strip((String)this.EXTENSIONS, (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
    }

    void transferOldSettings() {
        SmartList enabledExtensions = new SmartList();
        if (this.CHECK_PHP) {
            enabledExtensions.add("php");
        }
        if (this.CHECK_JS) {
            enabledExtensions.add("js");
        }
        if (this.CHECK_CSS) {
            enabledExtensions.add("css");
        }
        if (this.CHECK_INC) {
            enabledExtensions.add("inc");
        }
        this.EXTENSIONS = StringUtil.join((Collection)enabledExtensions, (String)",");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/tools/quality/phpcs/PhpCSValidationInspection", "getAnnotator"));
    }
}

