/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpcs;

import com.intellij.DynamicBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.DataManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpTextFieldWithSdkBasedBrowse;
import com.jetbrains.php.lang.inspections.PhpInspectionsUtil;
import com.jetbrains.php.tools.quality.QualityToolCommonConfigurable;
import com.jetbrains.php.tools.quality.QualityToolProcessCreator;
import com.jetbrains.php.tools.quality.QualityToolValidationException;
import com.jetbrains.php.tools.quality.QualityToolsOptionsPanel;
import com.jetbrains.php.tools.quality.phpcs.PhpCSConfiguration;
import com.jetbrains.php.tools.quality.phpcs.PhpCSCustomRulesSetupDialog;
import com.jetbrains.php.tools.quality.phpcs.PhpCSProjectConfiguration;
import com.jetbrains.php.tools.quality.phpcs.PhpCSValidationInspection;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.stream.IntStream;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCSOptionsPanel
extends QualityToolsOptionsPanel {
    private static final Logger LOG = Logger.getInstance(PhpCSOptionsPanel.class);
    private JPanel myOptionsPanel;
    private JCheckBox myShowWarningsBox;
    private JComboBox<String> myStandardCombo;
    private JButton mySetupCustomStandardButton;
    private JPanel myWarningsPanel;
    private JCheckBox myShowSniffNamesBox;
    private JCheckBox myUseInstalledPaths;
    private PhpTextFieldWithSdkBasedBrowse myInstalledPathsTextField;
    private JBTextField myExtensionsTextField;
    private JPanel myLinkPanel;
    private final PhpCSValidationInspection myInspection;
    private LevelChooserAction myWarningLevelChooser;

    public PhpCSOptionsPanel(PhpCSValidationInspection inspection) {
        this.myInspection = inspection;
        this.$$$setupUI$$$();
        this.myShowWarningsBox.setSelected(!this.myInspection.IGNORE_WARNINGS);
        this.myShowWarningsBox.addActionListener(e -> {
            this.myInspection.IGNORE_WARNINGS = !this.myShowWarningsBox.isSelected();
        });
        this.mySetupCustomStandardButton.addActionListener(e -> {
            if (this.checkCustomStandardEnabled()) {
                this.setupCustomRules();
            }
        });
        this.myUseInstalledPaths.setSelected(this.myInspection.USE_INSTALLED_PATHS);
        this.myUseInstalledPaths.addActionListener(e -> this.myInstalledPathsTextField.setEnabled(this.myUseInstalledPaths.isSelected()));
        this.myUseInstalledPaths.addActionListener(e -> {
            this.myInspection.USE_INSTALLED_PATHS = this.myUseInstalledPaths.isSelected();
        });
        this.myInstalledPathsTextField.setText(this.myInspection.INSTALLED_PATHS);
        this.myInstalledPathsTextField.setEnabled(this.myInspection.USE_INSTALLED_PATHS);
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
            Project project = (Project)CommonDataKeys.PROJECT.getData(context);
            if (project == null) {
                project = ProjectManager.getInstance().getDefaultProject();
            }
            this.myInstalledPathsTextField.init(project, this.getSdkAdditionalData(project), PhpBundle.message("quality.tool.phpcs.installed.paths", new Object[0]), false, true);
        });
        this.myInstalledPathsTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpCSOptionsPanel.this.myInspection.INSTALLED_PATHS = PhpCSOptionsPanel.this.myInstalledPathsTextField.getText();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/phpcs/PhpCSOptionsPanel$1", "textChanged"));
            }
        });
        this.mySetupCustomStandardButton.setText("");
        this.myShowSniffNamesBox.setSelected(this.myInspection.SHOW_SNIFF_NAMES);
        this.myShowSniffNamesBox.addActionListener(e -> {
            this.myInspection.SHOW_SNIFF_NAMES = this.myShowSniffNamesBox.isSelected();
        });
        this.myWarningLevelChooser.setChosen(this.myInspection.getWarningLevel().getSeverity());
        if (this.myInspection.EXTENSIONS == null) {
            this.myInspection.transferOldSettings();
        }
        this.myExtensionsTextField.setText(this.myInspection.EXTENSIONS);
        this.myExtensionsTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                PhpCSOptionsPanel.this.myInspection.EXTENSIONS = PhpCSOptionsPanel.this.myExtensionsTextField.getText();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/phpcs/PhpCSOptionsPanel$2", "textChanged"));
            }
        });
    }

    public void init() {
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
            Project project = this.getCurrentProject((DataContext)context);
            try {
                PhpCSConfiguration configuration = (PhpCSConfiguration)PhpCSProjectConfiguration.getInstance(project).findSelectedConfiguration(project, false);
                if (configuration != null) {
                    Object[] installedStandards;
                    if (PhpCSOptionsPanel.standardsMatch(this.myInspection.CODING_STANDARD, configuration.getStandards())) {
                        this.myStandardCombo.setModel(new DefaultComboBoxModel<String>(configuration.getStandards()));
                        if (!this.myInspection.CODING_STANDARD.isEmpty()) {
                            this.myStandardCombo.setSelectedItem(this.myInspection.CODING_STANDARD);
                        }
                    }
                    if ((installedStandards = PhpCSOptionsPanel.getInstalledStandards(project, configuration, this.getOptionsPanel(), this.myInspection.USE_INSTALLED_PATHS ? this.myInspection.INSTALLED_PATHS : null)).length == 0) {
                        PhpUiUtil.showBalloon(PhpBundle.message("quality.tool.phpcs.can.not.retrieve.standards", new Object[0]), MessageType.ERROR, this.myStandardCombo);
                        return;
                    }
                    installedStandards = (String[])ArrayUtil.append((Object[])installedStandards, (Object)"Custom");
                    configuration.setStandards((String[])installedStandards);
                    String currentStandard = (String)this.myStandardCombo.getSelectedItem();
                    this.myStandardCombo.setModel(new DefaultComboBoxModel<Object>(installedStandards));
                    this.myStandardCombo.setSelectedItem(PhpCSOptionsPanel.standardsMatch(currentStandard, (String[])installedStandards) ? currentStandard : installedStandards[0]);
                    PhpUiUtil.showBalloon(PhpBundle.message("quality.tool.coding.stardards.has.been.updated", new Object[0]), MessageType.INFO, this.myStandardCombo);
                } else {
                    this.myStandardCombo.setModel(new DefaultComboBoxModel<String>(new String[]{this.myInspection.CODING_STANDARD}));
                }
            }
            catch (QualityToolValidationException e) {
                PhpUiUtil.showBalloon(e.getMessage(), MessageType.ERROR, this.myStandardCombo);
                this.myStandardCombo.setModel(new DefaultComboBoxModel<String>(new String[]{this.myInspection.CODING_STANDARD}));
            }
        });
        this.myStandardCombo.addActionListener(e -> {
            this.myInspection.CODING_STANDARD = (String)this.myStandardCombo.getSelectedItem();
        });
    }

    private void createUIComponents() {
        this.mySetupCustomStandardButton = new FixedSizeButton();
        this.myWarningsPanel = new JPanel();
        this.myWarningsPanel.setLayout(new BorderLayout());
        this.myWarningLevelChooser = new LevelChooserAction(InspectionProfileManager.getInstance().getSeverityRegistrar()){

            protected void onChosen(HighlightSeverity severity) {
                PhpCSOptionsPanel.this.myInspection.setWarningLevel(HighlightDisplayLevel.find((HighlightSeverity)severity));
            }
        };
        this.myWarningsPanel.add(this.myWarningLevelChooser.createCustomComponent(this.myWarningLevelChooser.getTemplatePresentation(), "unknown"));
        this.myLinkPanel = PhpInspectionsUtil.createPanelWithSettingsLink("PHP_CodeSniffer", QualityToolCommonConfigurable.class, QualityToolCommonConfigurable::new, commonConfigurable -> commonConfigurable.showConfigurable("PHP_CodeSniffer"));
    }

    private static boolean standardsMatch(String current, String[] collected) {
        return Arrays.asList(collected).contains(current);
    }

    @Override
    public JPanel getOptionsPanel() {
        return this.myOptionsPanel;
    }

    static String @NotNull [] getInstalledStandards(@Nullable Project project, @NotNull PhpCSConfiguration config, @Nullable JComponent component, @Nullable String installedPaths) {
        block9: {
            String[] stringArray;
            if (config == null) {
                PhpCSOptionsPanel.$$$reportNull$$$0(0);
            }
            String standardsPrefix = "The installed coding standards are";
            String title = PhpBundle.message("getting.installed.standards", new Object[0]);
            try {
                String[] stringArray2;
                if (installedPaths == null) {
                    String[] stringArray3 = new String[1];
                    stringArray2 = stringArray3;
                    stringArray3[0] = "-i";
                } else {
                    String[] stringArray4 = new String[4];
                    stringArray4[0] = "--runtime-set";
                    stringArray4[1] = "installed_paths";
                    stringArray4[2] = installedPaths;
                    stringArray2 = stringArray4;
                    stringArray4[3] = "-i";
                }
                String[] params = stringArray2;
                ProcessOutput output = QualityToolProcessCreator.getToolOutput(project != null ? project : ProjectManager.getInstance().getDefaultProject(), config.getInterpreterId(), config.getToolPath(), config.getTimeout(), title, component, params);
                TreeSet<String> standards = new TreeSet<String>();
                Iterator iterator = output.getStdoutLines().iterator();
                if (!iterator.hasNext()) break block9;
                String line = (String)iterator.next();
                if (line.contains("The installed coding standards are")) {
                    String[] resultChunks;
                    line = line.replace("The installed coding standards are", "");
                    for (String resultChunk : resultChunks = line.split(",?\\s+")) {
                        String standardStr = resultChunk.trim();
                        if (standardStr.isEmpty() || "and".equals(standardStr)) continue;
                        standards.add(resultChunk.trim());
                    }
                }
                stringArray = ArrayUtilRt.toStringArray(standards);
            }
            catch (ExecutionException e) {
                LOG.warn("Failed getting installed standards for " + config.getToolPath(), (Throwable)e);
            }
            if (stringArray == null) {
                PhpCSOptionsPanel.$$$reportNull$$$0(1);
            }
            return stringArray;
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            PhpCSOptionsPanel.$$$reportNull$$$0(2);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    private boolean checkCustomStandardEnabled() {
        boolean enabled = "Custom".equals(this.myInspection.CODING_STANDARD);
        if (!enabled) {
            PhpUiUtil.showBalloon(PhpBundle.message("quality.tool.phpcs.custom.rules.warning", new Object[0]), MessageType.ERROR, this.myStandardCombo);
        }
        return enabled;
    }

    private void setupCustomRules() {
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
            Project project = (Project)CommonDataKeys.PROJECT.getData(context);
            if (project == null) {
                project = ProjectManager.getInstance().getDefaultProject();
            }
            try {
                PhpCSConfiguration configuration = (PhpCSConfiguration)PhpCSProjectConfiguration.getInstance(project).findSelectedConfiguration(project, false);
                if (configuration == null) {
                    PhpUiUtil.showBalloon(PhpBundle.message("validation.value.is.not.specified.or.invalid", "PHP_CodeSniffer"), MessageType.ERROR, this.myStandardCombo);
                    return;
                }
                PhpInterpreter interpreter = StringUtil.isEmpty((String)configuration.getInterpreterId()) ? null : PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(configuration.getInterpreterId());
                PhpCSCustomRulesSetupDialog dialog = new PhpCSCustomRulesSetupDialog(project, interpreter, this.myOptionsPanel, this.myInspection.CUSTOM_RULESET_PATH);
                if (dialog.showAndGet()) {
                    this.myInspection.CUSTOM_RULESET_PATH = dialog.getCustomRulesPath();
                    this.reselectCustomStandard();
                }
            }
            catch (QualityToolValidationException e) {
                PhpUiUtil.showBalloon(e.getMessage(), MessageType.ERROR, this.myStandardCombo);
            }
        });
    }

    private void reselectCustomStandard() {
        this.myStandardCombo.setSelectedIndex(0);
        IntStream.range(0, this.myStandardCombo.getItemCount()).filter(i -> this.myStandardCombo.getItemAt(i).equals("Custom")).findFirst().ifPresent(this.myStandardCombo::setSelectedIndex);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/phpcs/PhpCSOptionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/phpcs/PhpCSOptionsPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledStandards";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstalledStandards";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTextField jBTextField;
        PhpTextFieldWithSdkBasedBrowse phpTextFieldWithSdkBasedBrowse;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        this.createUIComponents();
        this.myOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 5, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpCSOptionsPanel.class).getString("quality.tool.label.coding.standard"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JButton jButton = this.mySetupCustomStandardButton;
        jButton.setText("...");
        jPanel2.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, new Dimension(24, 24), new Dimension(24, 24)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myStandardCombo = jComboBox;
        ((Component)jComboBox).setEnabled(true);
        jPanel3.add(jComboBox, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = this.myWarningsPanel;
        jPanel4.add((Component)jPanel5, new GridConstraints(1, 1, 1, 4, 8, 2, 0, 3, null, null, null));
        this.myShowWarningsBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setHorizontalAlignment(2);
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpCSOptionsPanel.class).getString("quality.tool.checkbox.show.warning.as"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShowSniffNamesBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpCSOptionsPanel.class).getString("quality.tool.checkbox.show.sniff.name"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseInstalledPaths = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpCSOptionsPanel.class).getString("quality.tool.checkbox.installed.standard.paths"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInstalledPathsTextField = phpTextFieldWithSdkBasedBrowse = new PhpTextFieldWithSdkBasedBrowse();
        ((Component)((Object)phpTextFieldWithSdkBasedBrowse)).setEnabled(false);
        jPanel4.add((Component)((Object)phpTextFieldWithSdkBasedBrowse), new GridConstraints(3, 1, 1, 4, 0, 1, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setAlignmentY(0.5f);
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpCSOptionsPanel.class).getString("quality.tool.label.check.files.with.extensions"));
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExtensionsTextField = jBTextField = new JBTextField();
        jPanel4.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = this.myLinkPanel;
        jPanel.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myOptionsPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

