/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpcs;

import com.google.gson.JsonElement;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.InstalledPackageData;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.tools.quality.QualityToolConfigurationManager;
import com.jetbrains.php.tools.quality.QualityToolsComposerConfig;
import com.jetbrains.php.tools.quality.phpcs.PhpCSConfiguration;
import com.jetbrains.php.tools.quality.phpcs.PhpCSConfigurationManager;
import com.jetbrains.php.tools.quality.phpcs.PhpCSCustomRulesSetupDialog;
import com.jetbrains.php.tools.quality.phpcs.PhpCSOptionsPanel;
import com.jetbrains.php.tools.quality.phpcs.PhpCSQualityToolType;
import com.jetbrains.php.tools.quality.phpcs.PhpCSValidationInspection;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCSComposerConfig
extends QualityToolsComposerConfig<PhpCSConfiguration, PhpCSValidationInspection> {
    @NonNls
    public static final String PACKAGE = "squizlabs/php_codesniffer";
    @NonNls
    private static final String RELATIVE_PATH = "bin/phpcs" + (SystemInfo.isWindows ? ".bat" : "");
    @NonNls
    private static final String PHPCS_XML = "phpcs.xml";
    private String myDefaultStandard;

    public PhpCSComposerConfig() {
        super(PACKAGE, RELATIVE_PATH);
    }

    @Override
    @NotNull
    public QualityToolConfigurationManager<PhpCSConfiguration> getConfigurationManager(@NotNull Project project) {
        if (project == null) {
            PhpCSComposerConfig.$$$reportNull$$$0(0);
        }
        PhpCSConfigurationManager phpCSConfigurationManager = PhpCSConfigurationManager.getInstance(project);
        if (phpCSConfigurationManager == null) {
            PhpCSComposerConfig.$$$reportNull$$$0(1);
        }
        return phpCSConfigurationManager;
    }

    @Override
    protected boolean applyRulesetFromRoot(@NotNull Project project) {
        VirtualFile customRulesetFile;
        if (project == null) {
            PhpCSComposerConfig.$$$reportNull$$$0(2);
        }
        if ((customRulesetFile = this.detectCustomRulesetFile(project.getBaseDir(), PHPCS_XML)) == null) {
            customRulesetFile = this.detectCustomRulesetFile(project.getBaseDir(), "phpcs.xml.dist");
        }
        if (customRulesetFile != null) {
            String path = customRulesetFile.getPath();
            return this.modifyRulesetInspectionSetting(project, tool -> PhpCSComposerConfig.applyRuleset(tool, "Custom", path));
        }
        return false;
    }

    @Override
    protected boolean applyRulesetFromComposer(@NotNull Project project, PhpCSConfiguration configuration) {
        if (project == null) {
            PhpCSComposerConfig.$$$reportNull$$$0(3);
        }
        String configPath = ComposerDataService.getInstance(project).getConfigPath();
        VirtualFile config = LocalFileSystem.getInstance().refreshAndFindFileByPath(configPath);
        if (config == null) {
            return false;
        }
        String standardPaths = this.setupInstalledStandardPaths(config, project);
        String ruleset = this.getRuleset(config);
        if (ruleset == null) {
            return false;
        }
        if (ArrayUtil.contains((String)ruleset, (String[])PhpCSOptionsPanel.getInstalledStandards(project, configuration, null, standardPaths))) {
            return this.modifyRulesetInspectionSetting(project, tool -> PhpCSComposerConfig.applyRuleset(tool, ruleset, ""));
        }
        VirtualFile customRulesetFile = this.detectCustomRulesetFile(config.getParent(), ruleset);
        if (customRulesetFile != null) {
            return this.modifyRulesetInspectionSetting(project, tool -> PhpCSComposerConfig.applyRuleset(tool, "Custom", customRulesetFile.getPath()));
        }
        return false;
    }

    @Override
    protected boolean applyRulesetExtended(@NotNull Project project, PhpCSConfiguration configuration) {
        if (project == null) {
            PhpCSComposerConfig.$$$reportNull$$$0(4);
        }
        if (!StringUtil.isEmpty((String)this.myDefaultStandard)) {
            return this.modifyRulesetInspectionSetting(project, tool -> PhpCSComposerConfig.applyRuleset(tool, this.myDefaultStandard, ""));
        }
        return false;
    }

    @Override
    @Nullable
    public ComposerLogMessageBuilder.Settings getSettings() {
        return ComposerLogMessageBuilder.Settings.CODE_SNIFFER;
    }

    private static void applyRuleset(PhpCSValidationInspection tool, String codingStandard, String customRuleset) {
        tool.CUSTOM_RULESET_PATH = customRuleset;
        tool.CODING_STANDARD = codingStandard;
    }

    @Nullable
    private String setupInstalledStandardPaths(@NotNull VirtualFile configFile, @NotNull Project project) {
        if (configFile == null) {
            PhpCSComposerConfig.$$$reportNull$$$0(5);
        }
        if (project == null) {
            PhpCSComposerConfig.$$$reportNull$$$0(6);
        }
        for (InstalledPackageData packageData : ComposerConfigUtils.getInstalledPackagesFromConfig(configFile)) {
            NonPSRStandard codingStandard = NonPSRStandard.findById(packageData.getName());
            if (codingStandard == null) continue;
            this.myDefaultStandard = codingStandard.getDefaultStandard();
            String installedPaths = this.findFromComposerVendor(project, codingStandard.getId() + codingStandard.getRelativePath());
            this.modifyRulesetInspectionSetting(project, tool -> PhpCSComposerConfig.applyInstalledPaths(tool, installedPaths));
            return installedPaths;
        }
        return null;
    }

    private static void applyInstalledPaths(PhpCSValidationInspection tool, String installedPaths) {
        tool.USE_INSTALLED_PATHS = true;
        tool.INSTALLED_PATHS = installedPaths;
    }

    @Override
    protected void updateCustomSettings(PhpCSConfiguration config) {
        VirtualFile phpcbf;
        VirtualFile phpcs = VfsUtil.findFile((Path)Paths.get(config.getToolPath(), new String[0]), (boolean)true);
        if (phpcs != null && (phpcbf = phpcs.getParent().findChild("phpcbf" + (SystemInfo.isWindows ? ".bat" : ""))) != null) {
            config.setPhpCodeBeautifierPath(phpcbf.getPath());
        }
    }

    @Override
    protected boolean checkRulesetFile(VirtualFile file) {
        return PhpCSCustomRulesSetupDialog.isCodingStandardFile(file.getPath());
    }

    @Override
    protected ComposerLogMessageBuilder.Settings getQualityToolsInspectionSettings() {
        return ComposerLogMessageBuilder.Settings.CODE_SNIFFER_INSPECTION;
    }

    @Override
    public String getQualityInspectionShortName() {
        return PhpCSQualityToolType.INSTANCE.getInspectionId();
    }

    @Override
    protected void checkComposerScriptsLeaves(JsonElement element, Ref<String> result) {
        String string = element.getAsString();
        if (string != null && string.contains("phpcs")) {
            for (String arg : StringUtil.split((String)string, (String)" ")) {
                String prefix = "--standard=";
                if (!StringUtil.startsWith((CharSequence)arg, (CharSequence)"--standard=")) continue;
                result.set((Object)StringUtil.trimStart((String)arg, (String)"--standard="));
            }
        }
    }

    @Override
    public boolean canBeEnabled(@NotNull Project project) {
        InspectionToolWrapper tool;
        if (project == null) {
            PhpCSComposerConfig.$$$reportNull$$$0(7);
        }
        if ((tool = InspectionProfileManager.getInstance((Project)project).getCurrentProfile().getInspectionTool(this.getQualityInspectionShortName(), project)) != null) {
            PhpCSValidationInspection inspection = (PhpCSValidationInspection)((Object)ObjectUtils.tryCast((Object)tool.getTool(), PhpCSValidationInspection.class));
            return super.canBeEnabled(project) && inspection != null && !StringUtil.isEmpty((String)inspection.CODING_STANDARD);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/phpcs/PhpCSComposerConfig";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/phpcs/PhpCSComposerConfig";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationManager";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyRulesetFromRoot";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyRulesetFromComposer";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyRulesetExtended";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setupInstalledStandardPaths";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canBeEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum NonPSRStandard {
        DOCTRINE("doctrine/coding-standard", "Doctrine", "/lib/Doctrine"),
        DRUPAL("drupal/coder", "Drupal", "/coder_sniffer"),
        WP("wp-coding-standards/wpcs", "WordPress"),
        PHP_COMPATIBILITY("phpcompatibility/php-compatibility", "PHPCompatibility", "/PHPCompatibility"),
        JOOMLA("joomla/coding-standards", "Joomla"),
        SYMFONY("escapestudios/symfony2-coding-standard", "Symfony"),
        YII("yiisoft/yii2-coding-standards", "Yii2"),
        WIMG_COMPATIBILITY("wimg/php-compatibility", "PHPCompatibility"),
        MAGENTO("magento-ecg/coding-standard", "Ecg"),
        MEDIAWIKI("mediawiki/mediawiki-codesniffer", "MediaWiki"),
        CAKE_PHP("cakephp/cakephp-codesniffer", "CakePHP");

        private final String myId;
        private final String myDefaultStandard;
        private final String myRelativePath;

        private NonPSRStandard(@NotNull String id, String standard, String relativePath) {
            if (id == null) {
                NonPSRStandard.$$$reportNull$$$0(0);
            }
            if (standard == null) {
                NonPSRStandard.$$$reportNull$$$0(1);
            }
            if (relativePath == null) {
                NonPSRStandard.$$$reportNull$$$0(2);
            }
            this.myId = id;
            this.myDefaultStandard = standard;
            this.myRelativePath = relativePath;
        }

        private NonPSRStandard(String id, String standard) {
            if (id == null) {
                NonPSRStandard.$$$reportNull$$$0(3);
            }
            if (standard == null) {
                NonPSRStandard.$$$reportNull$$$0(4);
            }
            this(id, standard, "");
        }

        @NotNull
        private String getId() {
            String string = this.myId;
            if (string == null) {
                NonPSRStandard.$$$reportNull$$$0(5);
            }
            return string;
        }

        private String getDefaultStandard() {
            return this.myDefaultStandard;
        }

        private String getRelativePath() {
            return this.myRelativePath;
        }

        @Nullable
        private static NonPSRStandard findById(String id) {
            if (id == null) {
                return null;
            }
            return (NonPSRStandard)((Object)ContainerUtil.find((Object[])NonPSRStandard.values(), standard -> standard.getId().equals(id)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "standard";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relativePath";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/tools/quality/phpcs/PhpCSComposerConfig$NonPSRStandard";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/tools/quality/phpcs/PhpCSComposerConfig$NonPSRStandard";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

