/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpCSFixer;

import com.intellij.DynamicBundle;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.lang.inspections.PhpInspectionsUtil;
import com.jetbrains.php.tools.quality.QualityToolCommonConfigurable;
import com.jetbrains.php.tools.quality.QualityToolValidationException;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerConfiguration;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerCustomRulesSetupDialog;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerProjectConfiguration;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerValidationInspection;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.stream.IntStream;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCSFixerOptionsPanel {
    private final PhpCSFixerValidationInspection myInspection;
    private JPanel myOptionsPanel;
    private JButton mySetupCustomStandardButton;
    private JComboBox<String> myStandardCombo;
    private JBCheckBox myAllowRiskyRules;
    private JPanel myLinkPanel;

    public PhpCSFixerOptionsPanel(PhpCSFixerValidationInspection inspection) {
        this.myInspection = inspection;
        this.$$$setupUI$$$();
        this.mySetupCustomStandardButton.addActionListener(e -> {
            if (this.checkCustomStandardEnabled()) {
                this.setupCustomRules();
            }
        });
        this.mySetupCustomStandardButton.setText("");
        this.myAllowRiskyRules.setSelected(this.myInspection.ALLOW_RISKY_RULES);
        this.myAllowRiskyRules.addActionListener(e -> {
            this.myInspection.ALLOW_RISKY_RULES = this.myAllowRiskyRules.isSelected();
        });
    }

    public void init() {
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
            Project project = (Project)CommonDataKeys.PROJECT.getData(context);
            if (project == null) {
                project = ProjectManager.getInstance().getDefaultProject();
            }
            String codingStandard = this.myInspection.CODING_STANDARD;
            try {
                PhpCSFixerConfiguration configuration = (PhpCSFixerConfiguration)PhpCSFixerProjectConfiguration.getInstance(project).findSelectedConfiguration(project, false);
                if (configuration != null) {
                    Object[] installedStandards;
                    if (PhpCSFixerOptionsPanel.standardsMatch(codingStandard, configuration.getStandards())) {
                        this.myStandardCombo.setModel(new DefaultComboBoxModel<String>(configuration.getStandards()));
                        if (!StringUtil.isEmpty((String)codingStandard)) {
                            this.myStandardCombo.setSelectedItem(codingStandard);
                        }
                    }
                    if ((installedStandards = PhpCSFixerOptionsPanel.getInstalledStandards(project, configuration)).length == 0) {
                        PhpUiUtil.showBalloon(PhpBundle.message("quality.tool.can.not.retrieve.standards", new Object[0]), MessageType.ERROR, this.myStandardCombo);
                        return;
                    }
                    installedStandards = (String[])ArrayUtil.append((Object[])installedStandards, (Object)"Custom");
                    configuration.setStandards((String[])installedStandards);
                    String currentStandard = (String)this.myStandardCombo.getSelectedItem();
                    this.myStandardCombo.setModel(new DefaultComboBoxModel<Object>(installedStandards));
                    this.myStandardCombo.setSelectedItem(PhpCSFixerOptionsPanel.standardsMatch(currentStandard, (String[])installedStandards) ? currentStandard : installedStandards[0]);
                    PhpUiUtil.showBalloon(PhpBundle.message("quality.tool.stardards.has.been.updated", new Object[0]), MessageType.INFO, this.myStandardCombo);
                } else {
                    this.myStandardCombo.setModel(new DefaultComboBoxModel<String>(new String[]{codingStandard}));
                }
            }
            catch (QualityToolValidationException e) {
                this.myStandardCombo.setModel(new DefaultComboBoxModel<String>(new String[]{codingStandard}));
                PhpUiUtil.showBalloon(e.getMessage(), MessageType.ERROR, this.myStandardCombo);
            }
        });
        this.myStandardCombo.addActionListener(e -> {
            this.myInspection.CODING_STANDARD = (String)this.myStandardCombo.getSelectedItem();
        });
    }

    private void createUIComponents() {
        this.mySetupCustomStandardButton = new FixedSizeButton();
        this.myLinkPanel = PhpInspectionsUtil.createPanelWithSettingsLink("PHP CS Fixer", QualityToolCommonConfigurable.class, QualityToolCommonConfigurable::new, commonConfigurable -> commonConfigurable.showConfigurable("PHP CS Fixer"));
    }

    private static boolean standardsMatch(String current, String[] collected) {
        if (StringUtil.isEmpty((String)current)) {
            return true;
        }
        return Arrays.asList(collected).contains(current);
    }

    public JPanel getOptionsPanel() {
        return this.myOptionsPanel;
    }

    static String @NotNull [] getInstalledStandards(@Nullable Project project, @NotNull PhpCSFixerConfiguration configuration) {
        if (configuration == null) {
            PhpCSFixerOptionsPanel.$$$reportNull$$$0(0);
        }
        String[] stringArray = new String[]{"PSR1", "PSR2", "Symfony", "DoctrineAnnotation", "PHP70Migration", "PHP71Migration"};
        if (stringArray == null) {
            PhpCSFixerOptionsPanel.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    private boolean checkCustomStandardEnabled() {
        boolean enabled = "Custom".equals(this.myInspection.CODING_STANDARD);
        if (!enabled) {
            PhpUiUtil.showBalloon(PhpBundle.message("quality.tool.cs.fixer.custom.rules.warning", new Object[0]), MessageType.ERROR, this.myStandardCombo);
        }
        return enabled;
    }

    private void setupCustomRules() {
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
            Project project = (Project)CommonDataKeys.PROJECT.getData(context);
            if (project == null) {
                project = ProjectManager.getInstance().getDefaultProject();
            }
            try {
                PhpCSFixerConfiguration configuration = (PhpCSFixerConfiguration)PhpCSFixerProjectConfiguration.getInstance(project).findSelectedConfiguration(project, false);
                if (configuration == null) {
                    PhpUiUtil.showBalloon(PhpBundle.message("validation.value.is.not.specified.or.invalid", "PHP CS Fixer"), MessageType.ERROR, this.myStandardCombo);
                    return;
                }
                PhpInterpreter interpreter = StringUtil.isEmpty((String)configuration.getInterpreterId()) ? null : PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(configuration.getInterpreterId());
                PhpCSFixerCustomRulesSetupDialog dialog = new PhpCSFixerCustomRulesSetupDialog(project, interpreter, this.myOptionsPanel, this.myInspection.CUSTOM_RULESET_PATH);
                if (dialog.showAndGet()) {
                    this.myInspection.CUSTOM_RULESET_PATH = dialog.getCustomRulesPath();
                    this.reselectCustomStandard();
                }
            }
            catch (QualityToolValidationException e) {
                PhpUiUtil.showBalloon(e.getMessage(), MessageType.ERROR, this.myStandardCombo);
            }
        });
    }

    private void reselectCustomStandard() {
        this.myStandardCombo.setSelectedIndex(0);
        IntStream.range(0, this.myStandardCombo.getItemCount()).filter(i -> this.myStandardCombo.getItemAt(i).equals("Custom")).findFirst().ifPresent(this.myStandardCombo::setSelectedIndex);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/phpCSFixer/PhpCSFixerOptionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/phpCSFixer/PhpCSFixerOptionsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledStandards";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstalledStandards";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 5, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(5, 5, 0, 0), -1, -1, false, false));
        jPanel2.setAlignmentY(0.5f);
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAllowRiskyRules = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpCSFixerOptionsPanel.class).getString("quality.tool.cs.fixer.allow.risky.rules"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpCSFixerOptionsPanel.class).getString("quality.tool.cs.fixer.ruleset"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JButton jButton = this.mySetupCustomStandardButton;
        jButton.setText("...");
        jPanel3.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, new Dimension(24, 24), new Dimension(24, 24)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myStandardCombo = jComboBox;
        ((Component)jComboBox).setEnabled(true);
        jPanel4.add(jComboBox, "Center");
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = this.myLinkPanel;
        jPanel.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myOptionsPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

