/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.messDetector;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.lang.inspections.PhpInspectionsUtil;
import com.jetbrains.php.tools.quality.QualityToolCommonConfigurable;
import com.jetbrains.php.tools.quality.QualityToolValidationException;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorConfiguration;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorProjectConfiguration;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorRulesetAnalyzer;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorValidationInspection;
import com.jetbrains.php.tools.quality.messDetector.RulesetDescriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessDetectorOptionsPanel {
    private static final Logger LOG = Logger.getInstance(MessDetectorOptionsPanel.class);
    private JPanel myContentPane;
    private JPanel myRulesOptions;
    private JBTable myCustomRulesetTable;
    private JPanel myToolBarPanel;
    private JPanel myLinkPanel;
    private final MessDetectorValidationInspection myInspection;
    private final CustomRulesetTableModel myRulesetTableModelModel;

    public MessDetectorOptionsPanel(MessDetectorValidationInspection inspection) {
        this.myInspection = inspection;
        this.$$$setupUI$$$();
        DefaultActionGroup group = new DefaultActionGroup();
        JComponent toolBar = ActionManager.getInstance().createActionToolbar("PhpMessDetector", (ActionGroup)group, true).getComponent();
        this.myRulesetTableModelModel = new CustomRulesetTableModel();
        this.myCustomRulesetTable.setModel((TableModel)this.myRulesetTableModelModel);
        group.add(new AnAction(PhpBundle.message("add.rule", new Object[0]), null, AllIcons.General.Add){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                MessDetectorOptionsPanel.this.addCustomRule();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/messDetector/MessDetectorOptionsPanel$1", "actionPerformed"));
            }
        });
        group.add(new AnAction(PhpBundle.message("remove.rule", new Object[0]), null, AllIcons.General.Remove){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                MessDetectorOptionsPanel.this.removeCustomRule();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(MessDetectorOptionsPanel.this.myCustomRulesetTable.getSelectedRows().length > 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/jetbrains/php/tools/quality/messDetector/MessDetectorOptionsPanel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myToolBarPanel.add((Component)toolBar, "Center");
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    private void createUIComponents() {
        this.myRulesOptions = new JPanel();
        this.myRulesOptions.setLayout(new BoxLayout(this.myRulesOptions, 1));
        new MyRuleSetOption(this.myRulesOptions, "codesize", PhpBundle.message("code.size.rules", new Object[0]));
        new MyRuleSetOption(this.myRulesOptions, "controversial", PhpBundle.message("controversial.rules", new Object[0]));
        new MyRuleSetOption(this.myRulesOptions, "design", PhpBundle.message("design.rules", new Object[0]));
        new MyRuleSetOption(this.myRulesOptions, "naming", PhpBundle.message("naming.rules", new Object[0]));
        new MyRuleSetOption(this.myRulesOptions, "unusedcode", PhpBundle.message("unused.code.rules", new Object[0]));
        this.myLinkPanel = PhpInspectionsUtil.createPanelWithSettingsLink("Mess Detector", QualityToolCommonConfigurable.class, QualityToolCommonConfigurable::new, commonConfigurable -> commonConfigurable.showConfigurable("Mess Detector"));
    }

    @Nullable
    private PhpInterpreter getSelectedInterpreter() {
        Project project = this.getCurrentProject();
        try {
            MessDetectorConfiguration configuration = (MessDetectorConfiguration)MessDetectorProjectConfiguration.getInstance(project).findSelectedConfiguration(project, false);
            if (configuration == null || StringUtil.isEmpty((String)configuration.getInterpreterId())) {
                return null;
            }
            return PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(configuration.getInterpreterId());
        }
        catch (QualityToolValidationException e) {
            return null;
        }
    }

    @NotNull
    private Project getCurrentProject() {
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myContentPane));
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        Project project2 = project;
        if (project2 == null) {
            MessDetectorOptionsPanel.$$$reportNull$$$0(0);
        }
        return project2;
    }

    private void addCustomRule() {
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                return MessDetectorOptionsPanel.containsRulesetXml(file) && super.isFileSelectable(file);
            }

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return file.isDirectory() || "xml".equals(file.getExtension()) || "dist".equals(file.getExtension());
            }
        };
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor, (Component)this.myContentPane, null, (VirtualFile)this.getPreselectedFile());
        if (file != null) {
            this.addRuleDescriptor(file.getPath(), file);
        }
    }

    void addRuleDescriptor(@NotNull String originalPath, @NotNull VirtualFile file) {
        RulesetDescriptor descriptor;
        if (originalPath == null) {
            MessDetectorOptionsPanel.$$$reportNull$$$0(1);
        }
        if (file == null) {
            MessDetectorOptionsPanel.$$$reportNull$$$0(2);
        }
        if ((descriptor = MessDetectorRulesetAnalyzer.readRulesetFile(originalPath, file)) != null) {
            int row = this.myRulesetTableModelModel.addDescriptor(descriptor);
            this.myCustomRulesetTable.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    @Nullable
    private VirtualFile getPreselectedFile() {
        File file;
        RulesetDescriptor descriptor;
        int[] selectedRows = this.myCustomRulesetTable.getSelectedRows();
        if (selectedRows.length > 0 && (descriptor = this.myRulesetTableModelModel.getDescriptorAt(selectedRows[0])).isValid(false) && (file = new File(descriptor.getPath())).exists()) {
            return VfsUtil.findFileByIoFile((File)file, (boolean)true);
        }
        return null;
    }

    static boolean containsRulesetXml(VirtualFile file) {
        return MessDetectorRulesetAnalyzer.readRulesetFile(file) != null;
    }

    private void removeCustomRule() {
        int[] selectedRows = this.myCustomRulesetTable.getSelectedRows();
        if (selectedRows.length > 0) {
            this.myRulesetTableModelModel.removeDescriptors(selectedRows);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/messDetector/MessDetectorOptionsPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentProject";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/messDetector/MessDetectorOptionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addRuleDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTable jBTable;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = this.myRulesOptions;
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", MessDetectorOptionsPanel.class).getString("quality.tool.label.custom.rulesets"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myToolBarPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 7, new Dimension(-1, 70), null, null));
        this.myCustomRulesetTable = jBTable = new JBTable();
        jBTable.setAutoCreateRowSorter(false);
        jBTable.setFillsViewportHeight(true);
        jBScrollPane.setViewportView((Component)jBTable);
        JPanel jPanel5 = this.myLinkPanel;
        jPanel4.add((Component)jPanel5, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class CustomRulesetTableModel
    extends AbstractTableModel {
        private CustomRulesetTableModel() {
        }

        @Override
        public int getRowCount() {
            return MessDetectorOptionsPanel.this.myInspection.customRulesets == null ? 0 : MessDetectorOptionsPanel.this.myInspection.customRulesets.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return PhpBundle.message("name", new Object[0]);
                }
                case 1: {
                    return PhpBundle.message("file", new Object[0]);
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return MessDetectorOptionsPanel.this.myInspection.customRulesets.get(rowIndex).getName();
                }
                case 1: {
                    RulesetDescriptor descriptor = MessDetectorOptionsPanel.this.myInspection.customRulesets.get(rowIndex);
                    PhpInterpreter interpreter = MessDetectorOptionsPanel.this.getSelectedInterpreter();
                    boolean remote = interpreter != null && interpreter.isRemote();
                    return descriptor.isValid(remote) ? descriptor.getPath() : "<does not exist>";
                }
            }
            return null;
        }

        public int addDescriptor(RulesetDescriptor rulesetDescriptor) {
            MessDetectorOptionsPanel.this.myInspection.customRulesets.add(rulesetDescriptor);
            this.fireTableDataChanged();
            return MessDetectorOptionsPanel.this.myInspection.customRulesets.size() - 1;
        }

        public void removeDescriptors(int[] rowIndices) {
            ArrayList<RulesetDescriptor> toRemove = new ArrayList<RulesetDescriptor>();
            for (int rowIndex : rowIndices) {
                toRemove.add(MessDetectorOptionsPanel.this.myInspection.customRulesets.get(rowIndex));
            }
            MessDetectorOptionsPanel.this.myInspection.customRulesets.removeAll(toRemove);
            this.fireTableDataChanged();
        }

        public RulesetDescriptor getDescriptorAt(int rowIndex) {
            return rowIndex < 0 || rowIndex >= MessDetectorOptionsPanel.this.myInspection.customRulesets.size() ? null : MessDetectorOptionsPanel.this.myInspection.customRulesets.get(rowIndex);
        }
    }

    private final class MyRuleSetOption {
        private final JCheckBox myCheckBox;
        private final String myOptionName;

        private MyRuleSetOption(JPanel contentPane, @Nls String optionName, String optionTitle) {
            this.myCheckBox = new JCheckBox(optionTitle);
            this.myOptionName = optionName;
            this.myCheckBox.setSelected(MessDetectorOptionsPanel.this.myInspection.getRulesetOptionValue(optionName));
            this.myCheckBox.addActionListener(e -> MessDetectorOptionsPanel.this.myInspection.setRulesetOptionValue(this.myOptionName, this.myCheckBox.isSelected()));
            contentPane.add(this.myCheckBox);
        }
    }
}

