/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.messDetector;

import com.google.gson.JsonElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.tools.quality.QualityToolConfigurationManager;
import com.jetbrains.php.tools.quality.QualityToolsComposerConfig;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorConfiguration;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorConfigurationManager;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorOptionsPanel;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorQualityToolType;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorRulesetAnalyzer;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorValidationInspection;
import com.jetbrains.php.tools.quality.messDetector.RulesetDescriptor;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MessDetectorComposerConfig
extends QualityToolsComposerConfig<MessDetectorConfiguration, MessDetectorValidationInspection> {
    @NonNls
    private static final String PACKAGE = "phpmd/phpmd";
    @NonNls
    private static final String RELATIVE_PATH = "bin/phpmd" + (SystemInfo.isWindows ? ".bat" : "");
    @NonNls
    private static final String PHPMD_XML = "phpmd.xml";

    public MessDetectorComposerConfig() {
        super(PACKAGE, RELATIVE_PATH);
    }

    @Override
    @NotNull
    public QualityToolConfigurationManager<MessDetectorConfiguration> getConfigurationManager(@NotNull Project project) {
        if (project == null) {
            MessDetectorComposerConfig.$$$reportNull$$$0(0);
        }
        MessDetectorConfigurationManager messDetectorConfigurationManager = MessDetectorConfigurationManager.getInstance(project);
        if (messDetectorConfigurationManager == null) {
            MessDetectorComposerConfig.$$$reportNull$$$0(1);
        }
        return messDetectorConfigurationManager;
    }

    @Override
    protected boolean applyRulesetFromRoot(@NotNull Project project) {
        VirtualFile customRulesetFile;
        if (project == null) {
            MessDetectorComposerConfig.$$$reportNull$$$0(2);
        }
        if ((customRulesetFile = this.detectCustomRulesetFile(project.getBaseDir(), PHPMD_XML)) == null) {
            customRulesetFile = this.detectCustomRulesetFile(project.getBaseDir(), "phpmd.xml.dist");
        }
        if (customRulesetFile != null) {
            RulesetDescriptor descriptor = MessDetectorRulesetAnalyzer.readRulesetFile(customRulesetFile.getPath(), customRulesetFile);
            return this.modifyRulesetInspectionSetting(project, tool -> tool.customRulesets.add(descriptor));
        }
        return false;
    }

    @Override
    protected boolean applyRulesetFromComposer(@NotNull Project project, MessDetectorConfiguration configuration) {
        if (project == null) {
            MessDetectorComposerConfig.$$$reportNull$$$0(3);
        }
        String configPath = ComposerDataService.getInstance(project).getConfigPath();
        VirtualFile config = LocalFileSystem.getInstance().refreshAndFindFileByPath(configPath);
        if (config == null) {
            return false;
        }
        String ruleset = this.getRuleset(config);
        boolean rulesetChanged = false;
        if (!StringUtil.isEmpty((String)ruleset)) {
            for (String rule : StringUtil.split((String)ruleset, (String)",")) {
                if (ArrayUtil.contains((String)rule, (String[])MessDetectorValidationInspection.RULESET_OPTIONS)) {
                    rulesetChanged = this.modifyRulesetInspectionSetting(project, tool -> tool.setRulesetOptionValue(rule, true));
                    continue;
                }
                VirtualFile customRulesetFile = this.detectCustomRulesetFile(config.getParent(), rule);
                if (customRulesetFile == null) continue;
                rulesetChanged = this.modifyRulesetInspectionSetting(project, tool -> tool.customRulesets.add(MessDetectorRulesetAnalyzer.readRulesetFile(customRulesetFile.getPath(), customRulesetFile)));
            }
        }
        return rulesetChanged;
    }

    @Override
    protected boolean checkRulesetFile(VirtualFile file) {
        return MessDetectorOptionsPanel.containsRulesetXml(file);
    }

    @Override
    protected void checkComposerScriptsLeaves(JsonElement element, Ref<String> result) {
        List args;
        String string = element.getAsString();
        if (string != null && string.contains("phpmd") && (args = StringUtil.split((String)string, (String)" ")).size() >= 4) {
            int index = StringUtil.endsWith((CharSequence)((CharSequence)args.get(0)), (CharSequence)"phpmd") || StringUtil.endsWith((CharSequence)((CharSequence)args.get(0)), (CharSequence)"phpmd.bat") ? 3 : 4;
            result.set((Object)((String)args.get(index)));
        }
    }

    @Override
    protected ComposerLogMessageBuilder.Settings getQualityToolsInspectionSettings() {
        return ComposerLogMessageBuilder.Settings.MESS_DETECTOR_INSPECTION;
    }

    @Override
    public String getQualityInspectionShortName() {
        return MessDetectorQualityToolType.INSTANCE.getInspectionId();
    }

    @Override
    public ComposerLogMessageBuilder.Settings getSettings() {
        return ComposerLogMessageBuilder.Settings.MESS_DETECTOR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/messDetector/MessDetectorComposerConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/messDetector/MessDetectorComposerConfig";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationManager";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyRulesetFromRoot";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyRulesetFromComposer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

