/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.Consumer;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.configData.PackageComposerConfigClient;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolConfigurationManager;
import com.jetbrains.php.tools.quality.QualityToolValidationInspection;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolsComposerConfig<C extends QualityToolConfiguration, T extends QualityToolValidationInspection>
extends PackageComposerConfigClient {
    public QualityToolsComposerConfig(@NotNull String frameworkPackage, @NotNull String relativePath) {
        if (frameworkPackage == null) {
            QualityToolsComposerConfig.$$$reportNull$$$0(0);
        }
        if (relativePath == null) {
            QualityToolsComposerConfig.$$$reportNull$$$0(1);
        }
        super(frameworkPackage, relativePath);
    }

    @Override
    public void updateSettings(@NotNull Project project, @Nullable PhpInterpreter interpreter) {
        QualityToolConfigurationManager<C> manager;
        C configuration;
        if (project == null) {
            QualityToolsComposerConfig.$$$reportNull$$$0(2);
        }
        if ((configuration = (manager = this.getConfigurationManager(project)).getConfigurationByInterpreter(interpreter)) == null || StringUtil.isEmpty((String)configuration.getToolPath())) {
            String executable = this.findFromComposerVendor(project);
            if (StringUtil.isEmpty((String)executable) || !FileUtil.exists((String)executable) && !ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            C newConfig = manager.getOrCreateConfigurationByInterpreter(interpreter);
            newConfig.setToolPath(executable);
            this.updateCustomSettings(newConfig);
            this.notify(project, manager.getQualityToolName(), this.getSettings());
            this.updateInspectionSettings(project, newConfig, manager.getQualityToolName());
        }
    }

    @Nullable
    public C getSettings(@NotNull Project project, @Nullable PhpInterpreter interpreter) {
        if (project == null) {
            QualityToolsComposerConfig.$$$reportNull$$$0(3);
        }
        QualityToolConfigurationManager<C> manager = this.getConfigurationManager(project);
        return manager.getConfigurationByInterpreter(interpreter);
    }

    protected void updateCustomSettings(C config) {
    }

    @Nullable
    public String getRuleset(@NotNull VirtualFile config) {
        JsonElement scriptElement;
        JsonElement element;
        if (config == null) {
            QualityToolsComposerConfig.$$$reportNull$$$0(4);
        }
        try {
            element = ComposerConfigUtils.parseJson(config);
        }
        catch (JsonParseException | IOException e) {
            return null;
        }
        if (element instanceof JsonObject && (scriptElement = ((JsonObject)element).get("scripts")) != null) {
            Ref result = new Ref();
            this.parse(scriptElement, (Ref<String>)result);
            return result.isNull() ? null : (String)result.get();
        }
        return null;
    }

    private void parse(@Nullable JsonElement element, Ref<String> result) {
        if (!result.isNull()) {
            return;
        }
        if (element instanceof JsonPrimitive) {
            this.checkComposerScriptsLeaves(element, result);
        } else if (element instanceof JsonArray) {
            ((JsonArray)element).iterator().forEachRemaining(el -> this.parse((JsonElement)el, result));
        } else if (element instanceof JsonObject) {
            ((JsonObject)element).entrySet().stream().map(Map.Entry::getValue).forEach(el -> this.parse((JsonElement)el, result));
        }
    }

    @Nullable
    protected VirtualFile detectCustomRulesetFile(@NotNull VirtualFile base, @NotNull String relativeRulesetPath) {
        VirtualFile file;
        if (base == null) {
            QualityToolsComposerConfig.$$$reportNull$$$0(5);
        }
        if (relativeRulesetPath == null) {
            QualityToolsComposerConfig.$$$reportNull$$$0(6);
        }
        return (file = VfsUtil.findRelativeFile((String)FileUtil.toCanonicalPath((String)relativeRulesetPath), (VirtualFile)base)) == null || file.isDirectory() || !this.checkRulesetFile(file) ? null : file;
    }

    protected boolean checkRulesetFile(VirtualFile file) {
        return true;
    }

    protected void checkComposerScriptsLeaves(JsonElement element, Ref<String> result) {
    }

    protected void updateInspectionSettings(@NotNull Project project, C configuration, String toolName) {
        if (project == null) {
            QualityToolsComposerConfig.$$$reportNull$$$0(7);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.applyRulesetFromRoot(project) || this.applyRulesetFromComposer(project, configuration) || this.applyRulesetExtended(project, configuration)) {
                    InspectionProfileManager.getInstance((Project)project).getCurrentProfile().enableTool(this.getQualityInspectionShortName(), project);
                    this.notify(project, toolName + " inspection", this.getQualityToolsInspectionSettings());
                }
            }, project.getDisposed());
        }
    }

    protected boolean applyRulesetFromRoot(@NotNull Project project) {
        if (project == null) {
            QualityToolsComposerConfig.$$$reportNull$$$0(8);
        }
        return false;
    }

    protected boolean applyRulesetFromComposer(@NotNull Project project, C configuration) {
        if (project == null) {
            QualityToolsComposerConfig.$$$reportNull$$$0(9);
        }
        return false;
    }

    protected boolean applyRulesetExtended(@NotNull Project project, C configuration) {
        if (project == null) {
            QualityToolsComposerConfig.$$$reportNull$$$0(10);
        }
        return false;
    }

    protected abstract ComposerLogMessageBuilder.Settings getQualityToolsInspectionSettings();

    public abstract String getQualityInspectionShortName();

    protected boolean modifyRulesetInspectionSetting(@NotNull Project project, @NotNull Consumer<? super T> consumer) {
        VirtualFile projectDir;
        if (project == null) {
            QualityToolsComposerConfig.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            QualityToolsComposerConfig.$$$reportNull$$$0(12);
        }
        if ((projectDir = project.getBaseDir()) == null) {
            return false;
        }
        PsiDirectory file = PsiManager.getInstance((Project)project).findDirectory(projectDir);
        if (file != null) {
            Key key = Key.create((String)this.getQualityInspectionShortName());
            InspectionProfileManager.getInstance((Project)project).getCurrentProfile().modifyToolSettings(key, (PsiElement)file, consumer);
            return true;
        }
        return false;
    }

    public boolean canBeEnabled(@NotNull Project project) {
        if (project == null) {
            QualityToolsComposerConfig.$$$reportNull$$$0(13);
        }
        return true;
    }

    @NotNull
    public abstract QualityToolConfigurationManager<C> getConfigurationManager(@NotNull Project var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkPackage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeRulesetPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolsComposerConfig";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getRuleset";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "detectCustomRulesetFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "updateInspectionSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "applyRulesetFromRoot";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "applyRulesetFromComposer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "applyRulesetExtended";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyRulesetInspectionSetting";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

