/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.tools.quality.QualityToolAnnotationAppender;
import com.jetbrains.php.tools.quality.QualityToolAnnotator;
import com.jetbrains.php.tools.quality.QualityToolAnnotatorInfo;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class QualityToolValidationInspection
extends LocalInspectionTool {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            QualityToolValidationInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            QualityToolValidationInspection.$$$reportNull$$$0(1);
        }
        if (isOnTheFly) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!((Object)((Object)PhpFileType.INSTANCE)).equals(file.getFileType()) && this.hasPhpExtension(file)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        BatchAnnotationTarget annotationTarget = new BatchAnnotationTarget(manager, file);
        QualityToolAnnotator annotator = this.getAnnotator();
        QualityToolAnnotatorInfo info = annotator.collectAnnotatorInfo(file, null, file.getProject(), false);
        if (info != null) {
            new BatchAnnotationAppender(file, annotationTarget).apply(annotator.doAnnotate(info));
        }
        return annotationTarget.getDescriptors();
    }

    protected boolean hasPhpExtension(@NotNull PsiFile file) {
        if (file == null) {
            QualityToolValidationInspection.$$$reportNull$$$0(2);
        }
        String pathToFile = file.getVirtualFile().getPath();
        return ContainerUtil.exists((Object[])PhpFileType.INSTANCE.getExtensions(), extension -> FileUtilRt.extensionEquals((String)pathToFile, (String)extension));
    }

    public String @NotNull [] getGroupPath() {
        if (PhpInspection.GROUP_PATH_GENERAL == null) {
            QualityToolValidationInspection.$$$reportNull$$$0(3);
        }
        return PhpInspection.GROUP_PATH_GENERAL;
    }

    @NotNull
    public String getShortName() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        if (string == null) {
            QualityToolValidationInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected abstract QualityToolAnnotator getAnnotator();

    @NlsSafe
    public abstract String getToolName();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolValidationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolValidationInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasPhpExtension";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class BatchAnnotationTarget
    implements QualityToolAnnotationAppender.AnnotationTarget {
        private final List<ProblemDescriptor> myDescriptors = new ArrayList<ProblemDescriptor>();
        private final InspectionManager myManager;
        private final PsiFile myFile;

        BatchAnnotationTarget(InspectionManager manager, PsiFile file) {
            this.myManager = manager;
            this.myFile = file;
        }

        @Override
        public void createAnnotation(HighlightDisplayLevel severity, TextRange range, @InspectionMessage String messageText, IntentionAction ... actions) {
            ProblemHighlightType highlightType = ProblemHighlightType.WEAK_WARNING;
            if (severity == HighlightDisplayLevel.ERROR) {
                highlightType = ProblemHighlightType.ERROR;
            } else if (severity == HighlightDisplayLevel.WARNING) {
                highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            } else if (severity == HighlightDisplayLevel.WEAK_WARNING) {
                highlightType = ProblemHighlightType.WEAK_WARNING;
            }
            this.myDescriptors.add(this.myManager.createProblemDescriptor((PsiElement)this.myFile, range, messageText, highlightType, false, IntentionWrapper.wrapToQuickFixes((IntentionAction[])actions, (PsiFile)this.myFile)));
        }

        @Override
        public void creteInternalErrorAnnotation(@NotNull PsiFile file, @NotNull @InspectionMessage String messageText, IntentionAction ... quickFix) {
            if (file == null) {
                BatchAnnotationTarget.$$$reportNull$$$0(0);
            }
            if (messageText == null) {
                BatchAnnotationTarget.$$$reportNull$$$0(1);
            }
            this.myDescriptors.add(this.myManager.createProblemDescriptor((PsiElement)this.myFile, messageText, false, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.ERROR));
        }

        public ProblemDescriptor[] getDescriptors() {
            return this.myDescriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "messageText";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/tools/quality/QualityToolValidationInspection$BatchAnnotationTarget";
            objectArray[2] = "creteInternalErrorAnnotation";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BatchAnnotationAppender
    extends QualityToolAnnotationAppender {
        BatchAnnotationAppender(PsiFile file, QualityToolAnnotationAppender.AnnotationTarget target) {
            super(file, target);
        }
    }
}

