/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkFileTransfer;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolProcessCreator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolReformatFileAction<T>
implements IntentionAction {
    protected static final Logger LOG = Logger.getInstance(QualityToolReformatFileAction.class);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            QualityToolReformatFileAction.$$$reportNull$$$0(0);
        }
        VirtualFile virtualFile = file.getVirtualFile();
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(virtualFile);
        if (document != null) {
            QualityToolConfiguration settings;
            documentManager.saveDocument(document);
            T inspection = this.getInspection(project, file);
            if (inspection != null && (settings = this.getCurrentConfiguration(project)) != null) {
                String workDirectory = this.getWorkingDir(project, inspection);
                List<String> options = this.getOptions(virtualFile, inspection, project);
                String toolPath = this.getToolPath(settings);
                if (settings.isLocal()) {
                    QualityToolReformatFileAction.runLocalQuickFix(virtualFile, workDirectory, options, toolPath);
                } else {
                    this.runRemoteQuickFix(project, virtualFile, settings.getInterpreterId(), workDirectory, options, toolPath);
                }
            }
        }
    }

    protected String getToolPath(QualityToolConfiguration settings) {
        return settings.getToolPath();
    }

    private static void runLocalQuickFix(VirtualFile virtualFile, String workDirectory, List<String> options, String toolPath) {
        GeneralCommandLine cmd = new GeneralCommandLine();
        cmd.setExePath(toolPath);
        cmd.addParameters(options);
        cmd.setWorkDirectory(workDirectory);
        QualityToolProcessCreator.logProcessStart(cmd.getExePath(), workDirectory, true, ArrayUtil.toStringArray(options));
        try {
            OSProcessHandler processHandler = new OSProcessHandler(cmd);
            processHandler.addProcessListener((ProcessListener)new MyProcessAdapter(virtualFile, (ProcessHandler)processHandler));
            processHandler.startNotify();
        }
        catch (ExecutionException e) {
            LOG.warn("Can not execute " + toolPath + " with parameters: " + cmd.getPreparedCommandLine(), (Throwable)e);
        }
    }

    private void runRemoteQuickFix(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable String interpreterId, String workDirectory, List<String> options, String toolPath) {
        PhpCommandSettings command;
        PhpRemoteInterpreterManager manager;
        if (project == null) {
            QualityToolReformatFileAction.$$$reportNull$$$0(1);
        }
        if (virtualFile == null) {
            QualityToolReformatFileAction.$$$reportNull$$$0(2);
        }
        if ((manager = PhpRemoteInterpreterManager.getInstance()) == null) {
            return;
        }
        PhpSdkAdditionalData additionalData = PhpInterpretersManagerImpl.getInstance(project).findInterpreterDataById(interpreterId);
        if (additionalData == null) {
            return;
        }
        try {
            command = PhpCommandSettingsBuilder.create(toolPath, manager.createPathMapper(project, additionalData), additionalData);
        }
        catch (ExecutionException e) {
            LOG.warn("Couldn't create PHP command with remote interpreter");
            return;
        }
        this.fillArguments(options, command, workDirectory);
        PhpSdkFileTransfer.getSdkFileTransfer(additionalData).updateCommand(command);
        QualityToolProcessCreator.logProcessStart(toolPath, workDirectory, ArrayUtil.toStringArray(options));
        GeneralCommandLine commandLine = command.createGeneralCommandLine();
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                ProcessHandler processHandler = manager.getRemoteProcessHandler(project, additionalData, commandLine, true, new PathMappingSettings.PathMapping[0]);
                processHandler.addProcessListener((ProcessListener)new MyProcessAdapter(virtualFile, processHandler));
                processHandler.startNotify();
            }
            catch (Exception e) {
                LOG.warn("Can not execute PHP CS Fixer with parameters: " + commandLine.getPreparedCommandLine(), (Throwable)e);
            }
        });
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            QualityToolReformatFileAction.$$$reportNull$$$0(3);
        }
        return this.getCurrentConfiguration(project) != null;
    }

    protected abstract QualityToolConfiguration getCurrentConfiguration(@NotNull Project var1);

    protected abstract void fillArguments(List<String> var1, PhpCommandSettings var2, String var3);

    @Nullable
    protected String getWorkingDir(@NotNull Project project, @NotNull T inspection) {
        if (project == null) {
            QualityToolReformatFileAction.$$$reportNull$$$0(4);
        }
        if (inspection == null) {
            QualityToolReformatFileAction.$$$reportNull$$$0(5);
        }
        return project.getBasePath();
    }

    @Nullable
    protected abstract T getInspection(@NotNull Project var1, PsiFile var2);

    @NotNull
    protected abstract List<String> getOptions(@NotNull VirtualFile var1, @NotNull T var2, @NotNull Project var3);

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolReformatFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runRemoteQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getWorkingDir";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class MyProcessAdapter
    extends ProcessAdapter {
        @NotNull
        private final VirtualFile myVirtualFile;
        private final ProcessHandler myProcessHandler;

        private MyProcessAdapter(@NotNull VirtualFile virtualFile, ProcessHandler processHandler) {
            if (virtualFile == null) {
                MyProcessAdapter.$$$reportNull$$$0(0);
            }
            this.myVirtualFile = virtualFile;
            this.myProcessHandler = processHandler;
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                MyProcessAdapter.$$$reportNull$$$0(1);
            }
            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{this.myVirtualFile});
            this.myProcessHandler.removeProcessListener((ProcessListener)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolReformatFileAction$MyProcessAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

