/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.php.tools.quality.QualityToolExecutionException;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import com.jetbrains.php.tools.quality.QualityToolProcessHandler;
import org.jetbrains.annotations.NotNull;

public class QualityToolOutputProcessor {
    private static final Logger LOG = Logger.getInstance(QualityToolProcessHandler.class);
    static final int MAX_ERR_OUTPUT_LENGTH = 500;
    private final StringBuffer errOutput;
    private boolean errOutputTruncated;
    private final QualityToolMessageProcessor myMessageProcessor;
    private int myLineCount;

    public QualityToolOutputProcessor(@NotNull QualityToolMessageProcessor messageProcessor) {
        if (messageProcessor == null) {
            QualityToolOutputProcessor.$$$reportNull$$$0(0);
        }
        this.errOutput = new StringBuffer();
        this.errOutputTruncated = false;
        this.myLineCount = 0;
        this.myMessageProcessor = messageProcessor;
    }

    public void notifyTextAvailable(String text, Key outputType) {
        if (outputType == ProcessOutputTypes.STDOUT) {
            ++this.myLineCount;
            this.myMessageProcessor.parseLine(text);
        } else if (outputType == ProcessOutputTypes.STDERR) {
            this.processError(text);
        }
    }

    private void processError(String text) {
        if (!this.errOutputTruncated) {
            if (this.errOutput.length() < 500) {
                this.errOutput.append(text);
            } else {
                this.errOutputTruncated = true;
            }
        }
    }

    public void notifyProcessTerminated(int exitCode) {
        try {
            this.myMessageProcessor.done();
        }
        catch (QualityToolExecutionException e) {
            this.processError(e.getMessage());
        }
        if (exitCode != 0 && this.errOutput.length() > 0 && this.myMessageProcessor.getMessageCount() == 0 && this.myMessageProcessor.processStdErrMessages() && this.myMessageProcessor.processStdErrMessages(this.errOutput)) {
            @NlsSafe String text = this.errOutput.toString();
            this.myMessageProcessor.addInternalMessage(1, text);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageProcessor", "com/jetbrains/php/tools/quality/QualityToolOutputProcessor", "<init>"));
    }
}

