/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolConfigurationBaseManager;
import com.jetbrains.php.tools.quality.QualityToolConfigurationProvider;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolConfigurationManager<C extends QualityToolConfiguration> {
    @Nullable
    protected final Project myProject;
    protected QualityToolConfigurationBaseManager<C> myProjectManager;
    protected QualityToolConfigurationBaseManager<C> myApplicationManager;

    protected QualityToolConfigurationManager(@Nullable Project project) {
        this.myProject = project;
    }

    public List<C> getAllSettings() {
        if (this.myProjectManager == null) {
            return this.myApplicationManager.initLocalAndGetSettings();
        }
        ArrayList<C> settings = new ArrayList<C>(this.myApplicationManager.getSettings());
        settings.removeIf(QualityToolConfiguration::isLocal);
        return new ArrayList(ContainerUtil.concat(settings, this.myProjectManager.initLocalAndGetSettings()));
    }

    public void setSettings(@NotNull List<C> settings) {
        if (settings == null) {
            QualityToolConfigurationManager.$$$reportNull$$$0(0);
        }
        if (this.myProjectManager == null) {
            this.myApplicationManager.setSettings(settings);
            return;
        }
        ArrayList<QualityToolConfiguration> applicationLevel = new ArrayList<QualityToolConfiguration>();
        ArrayList<QualityToolConfiguration> projectLevel = new ArrayList<QualityToolConfiguration>();
        for (QualityToolConfiguration config : settings) {
            if (config.isProjectLevel()) {
                projectLevel.add(config);
                continue;
            }
            applicationLevel.add(config);
        }
        ContainerUtil.addIfNotNull(applicationLevel, (Object)((QualityToolConfiguration)ContainerUtil.find(this.myApplicationManager.getSettings(), QualityToolConfiguration::isLocal)));
        this.myApplicationManager.setSettings(applicationLevel);
        this.myProjectManager.setSettings(projectLevel);
    }

    @NotNull
    public C getLocalSettings() {
        QualityToolConfiguration localConfig = (QualityToolConfiguration)ContainerUtil.find(this.myProjectManager.getSettings(), QualityToolConfiguration::isLocal);
        QualityToolConfiguration qualityToolConfiguration = localConfig != null ? localConfig : this.myProjectManager.initLocalSettings();
        if (qualityToolConfiguration == null) {
            QualityToolConfigurationManager.$$$reportNull$$$0(1);
        }
        return (C)qualityToolConfiguration;
    }

    @NotNull
    public C getOrCreateConfigurationByInterpreter(@Nullable PhpInterpreter interpreter) {
        C c = this.getOrCreateConfigurationByInterpreter(interpreter, false);
        if (c == null) {
            QualityToolConfigurationManager.$$$reportNull$$$0(2);
        }
        return c;
    }

    @NotNull
    public C getOrCreateConfigurationByInterpreter(@Nullable PhpInterpreter interpreter, boolean onTheFly) {
        PhpRemoteInterpreterManager remoteInterpreterManager;
        QualityToolConfigurationBaseManager<C> manager;
        C configuration = this.getConfigurationByInterpreter(interpreter);
        if (configuration != null) {
            C c = configuration;
            if (c == null) {
                QualityToolConfigurationManager.$$$reportNull$$$0(3);
            }
            return c;
        }
        QualityToolConfigurationProvider<C> provider = this.myApplicationManager.getQualityToolType().getConfigurationProvider();
        if (interpreter == null || !interpreter.isRemote() || provider == null) {
            C c = this.myProjectManager.initLocalSettings();
            if (c == null) {
                QualityToolConfigurationManager.$$$reportNull$$$0(4);
            }
            return c;
        }
        C settings = provider.createConfigurationByInterpreter(interpreter);
        QualityToolConfigurationBaseManager<C> qualityToolConfigurationBaseManager = manager = interpreter.isProjectLevel() ? this.myProjectManager : this.myApplicationManager;
        if (!onTheFly) {
            manager.getSettings().add(settings);
        }
        if (onTheFly && (remoteInterpreterManager = PhpRemoteInterpreterManager.getInstance()) != null) {
            PathMappingSettings mappings = remoteInterpreterManager.createPathMappings(this.myProject, interpreter.getPhpSdkAdditionalData());
            provider.fillSettingsByDefaultValue(settings, this.getLocalSettings(), (NullableFunction<String, String>)((NullableFunction)localPath -> localPath == null ? null : mappings.convertToRemote(localPath)));
        }
        C c = settings;
        if (c == null) {
            QualityToolConfigurationManager.$$$reportNull$$$0(5);
        }
        return c;
    }

    @Nullable
    public C getConfigurationByInterpreter(@Nullable PhpInterpreter interpreter) {
        if (interpreter == null || !interpreter.isRemote()) {
            return this.getLocalSettings();
        }
        QualityToolConfigurationBaseManager<C> manager = interpreter.isProjectLevel() ? this.myProjectManager : this.myApplicationManager;
        return (C)((QualityToolConfiguration)ContainerUtil.find(manager.getSettings(), setting -> StringUtil.equals((CharSequence)setting.getId(), (CharSequence)interpreter.getId())));
    }

    public void onInterpretersUpdate() {
        this.setSettings(this.getAllSettings());
    }

    public String getQualityToolName() {
        return this.myApplicationManager.getQualityToolType().getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolConfigurationManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolConfigurationManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalSettings";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateConfigurationByInterpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

