/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolConfigurationProvider;
import com.jetbrains.php.tools.quality.QualityToolType;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolConfigurationBaseManager<C extends QualityToolConfiguration>
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(QualityToolConfigurationBaseManager.class);
    private static final String ROOT = "root";
    private List<C> mySettings = new ArrayList<C>();

    public List<C> initLocalAndGetSettings() {
        if (!ContainerUtil.exists(this.mySettings, config -> config != null && config.isLocal())) {
            this.initLocalSettings();
        }
        return this.mySettings;
    }

    public List<C> getSettings() {
        return this.mySettings;
    }

    public void setSettings(@NotNull List<C> settings) {
        if (settings == null) {
            QualityToolConfigurationBaseManager.$$$reportNull$$$0(0);
        }
        this.mySettings = settings;
    }

    @NotNull
    protected C initLocalSettings() {
        C local = this.getQualityToolType().createConfiguration();
        this.mySettings.add(local);
        C c = local;
        if (c == null) {
            QualityToolConfigurationBaseManager.$$$reportNull$$$0(1);
        }
        return c;
    }

    @Nullable
    public Element getState() {
        Element root = new Element(ROOT);
        if (this.mySettings.isEmpty()) {
            return root;
        }
        Element element = null;
        for (QualityToolConfiguration configurations : this.mySettings) {
            Element settingElement = XmlSerializer.serialize((Object)configurations);
            if (settingElement == null) continue;
            if (element == null) {
                element = new Element(this.getConfigurationRootName());
            }
            element.addContent(settingElement);
        }
        if (element != null) {
            root.addContent(element);
        }
        return root;
    }

    @Nullable
    private C load(@Nullable QualityToolConfigurationProvider<C> provider, @NotNull Element settingElement) {
        if (settingElement == null) {
            QualityToolConfigurationBaseManager.$$$reportNull$$$0(2);
        }
        if (provider == null || !provider.canLoad(settingElement.getName())) {
            return null;
        }
        return provider.load(settingElement);
    }

    @NotNull
    protected abstract QualityToolType<C> getQualityToolType();

    public void loadState(@NotNull Element element) {
        if (element == null) {
            QualityToolConfigurationBaseManager.$$$reportNull$$$0(3);
        }
        this.mySettings.clear();
        Element settings = element.getChild(this.getConfigurationRootName());
        if (settings == null) {
            C local = this.getQualityToolType().createConfiguration();
            List options = element.getChildren("option");
            for (Element option : options) {
                Attribute name = option.getAttribute("name");
                Attribute value = option.getAttribute("value");
                if (name == null || value == null) continue;
                if (this.getOldStyleToolPathName().equals(name.getValue())) {
                    String valuePresentation = value.getValue();
                    if (!StringUtil.isNotEmpty((String)valuePresentation)) continue;
                    local.setToolPath(valuePresentation);
                    continue;
                }
                if (!"timeoutMs".equals(name.getValue())) continue;
                try {
                    local.setTimeout(Integer.parseInt(value.getValue()));
                }
                catch (NumberFormatException e) {
                    LOG.warn(this.getQualityToolType().getDisplayName() + " - Can not parse old-style local configuration: timeout");
                }
            }
            this.mySettings.add(local);
        } else {
            boolean localIsLoaded = false;
            QualityToolConfigurationProvider<C> provider = this.getQualityToolType().getConfigurationProvider();
            for (Element settingElement : settings.getChildren()) {
                C configuration = this.load(provider, settingElement);
                if (configuration == null && !localIsLoaded) {
                    configuration = this.loadLocal(settingElement);
                    boolean bl = localIsLoaded = configuration != null;
                }
                if (configuration == null) continue;
                this.mySettings.add(configuration);
            }
        }
    }

    @NotNull
    protected abstract String getOldStyleToolPathName();

    @NotNull
    protected abstract String getConfigurationRootName();

    @Nullable
    protected abstract C loadLocal(Element var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolConfigurationBaseManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolConfigurationBaseManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "initLocalSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSettings";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

