/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.util.PhpConfigurationUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public interface QualityToolConfiguration
extends Comparable<QualityToolConfiguration> {
    @Nls
    public String getId();

    @NlsContexts.Label
    public String getPresentableName(@Nullable Project var1);

    public String getInterpreterId();

    public int getTimeout();

    public void setTimeout(int var1);

    @NlsSafe
    public String getToolPath();

    public void setToolPath(String var1);

    public int getMaxMessagesPerFile();

    default public boolean isLocal() {
        return StringUtil.equals((CharSequence)PhpBundle.message("local", new Object[0]), (CharSequence)this.getId());
    }

    default public boolean isProjectLevel() {
        return this.isLocal() || PhpInterpretersManagerImpl.getInstance(null).findInterpreterById(this.getInterpreterId()) == null;
    }

    default public String serialize(@Nullable String path) {
        String serializedPath = PhpConfigurationUtil.serializePath(path);
        return serializedPath != null ? StringUtil.trimEnd((String)serializedPath, (String)".bat") : null;
    }

    default public String deserialize(@Nullable String path) {
        String deserializePath = PhpConfigurationUtil.deserializePath(path);
        String trimmedPath = deserializePath != null ? StringUtil.trimEnd((String)deserializePath, (String)".bat") : "";
        return trimmedPath + (SystemInfo.isWindows ? ".bat" : "");
    }

    public QualityToolConfiguration clone();
}

