/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Namer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.tools.quality.QualityToolConfigurableForm;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolConfigurationProvider;
import com.jetbrains.php.tools.quality.QualityToolType;
import com.jetbrains.php.ui.PhpNamedCloneableItemsListEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolConfigurableList<C extends QualityToolConfiguration>
extends PhpNamedCloneableItemsListEditor<C> {
    private static final Comparator<MasterDetailsComponent.MyNode> COMPARATOR = (n1, n2) -> {
        Object o1 = n1.getConfigurable().getEditableObject();
        Object o2 = n2.getConfigurable().getEditableObject();
        if (o1 instanceof QualityToolConfiguration && o2 instanceof QualityToolConfiguration) {
            return ((QualityToolConfiguration)o1).compareTo((QualityToolConfiguration)o2);
        }
        return StringUtil.naturalCompare((String)n1.getDisplayName(), (String)n2.getDisplayName());
    };
    private final Project myProject;

    public QualityToolConfigurableList(@NotNull Project project, @NotNull QualityToolType<C> qualityToolType, @Nullable String initialElement) {
        if (project == null) {
            QualityToolConfigurableList.$$$reportNull$$$0(0);
        }
        if (qualityToolType == null) {
            QualityToolConfigurableList.$$$reportNull$$$0(1);
        }
        super(new QualityToolConfigurationNamer(project), () -> qualityToolType.createConfiguration(), settings -> settings.clone(), () -> qualityToolType.getConfigurationManager(project).getAllSettings(), settings -> qualityToolType.getConfigurationManager(project).setSettings(settings), settings -> {
            QualityToolConfigurableForm form;
            QualityToolConfigurationProvider<QualityToolConfiguration> provider = qualityToolType.getConfigurationProvider();
            if (provider != null && (form = provider.createConfigurationForm(project, (QualityToolConfiguration)settings)) != null) {
                return form;
            }
            return qualityToolType.createConfigurableForm(project, settings);
        }, new PhpNamedCloneableItemsListEditor.DefaultItemModelHandler(), initialElement);
        this.myProject = project;
        this.setSubjectDisplayName(qualityToolType.getDisplayName());
    }

    public String getHelpTopic() {
        return this.getQualityToolType().getHelpTopic();
    }

    @Nullable
    public String getLastSelectedItemId() {
        return this.myLastSelectedItem != null ? ((QualityToolConfiguration)this.myLastSelectedItem).getId() : null;
    }

    @Override
    @NotNull
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        List list = this.getQualityToolType().getConfigurationProvider() == null ? new ArrayList() : super.createActions(fromPopup);
        if (list == null) {
            QualityToolConfigurableList.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    protected boolean canDelete(C item) {
        return item != null && !item.isLocal();
    }

    @Override
    protected boolean isCopyAvailable() {
        return false;
    }

    @Override
    @NotNull
    protected String suggestName(C item) {
        String string = item.getPresentableName(this.myProject);
        if (string == null) {
            QualityToolConfigurableList.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected AnAction createAddAction() {
        return new PhpNamedCloneableItemsListEditor.AddAction(){

            @Override
            public void actionPerformed(@NotNull AnActionEvent event) {
                QualityToolConfigurationProvider provider;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((provider = QualityToolConfigurableList.this.getQualityToolType().getConfigurationProvider()) != null) {
                    ArrayList allSettings = new ArrayList();
                    QualityToolConfigurableList.this.getItemConfigurables().forEach(configurable -> ContainerUtil.addIfNotNull((Collection)allSettings, QualityToolConfigurableList.this.getConfiguration((QualityToolConfigurableForm)configurable)));
                    Object settings = provider.createNewInstance(QualityToolConfigurableList.this.myProject, allSettings);
                    if (settings != null) {
                        QualityToolConfigurableList.this.onItemCreated(settings);
                    }
                } else {
                    super.actionPerformed(event);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/tools/quality/QualityToolConfigurableList$1", "actionPerformed"));
            }
        };
    }

    @NlsContexts.ConfigurableName
    public String getDisplayName() {
        return this.getQualityToolType().getDisplayName();
    }

    protected abstract QualityToolType<C> getQualityToolType();

    @Nullable
    protected C getConfiguration(@Nullable QualityToolConfigurableForm<C> configurable) {
        return configurable != null ? (C)configurable.getConfiguration() : null;
    }

    protected Comparator<MasterDetailsComponent.MyNode> getNodeComparator() {
        return COMPARATOR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualityToolType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolConfigurableList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolConfigurableList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class QualityToolConfigurationNamer<C extends QualityToolConfiguration>
    implements Namer<C> {
        private final Project myProject;

        QualityToolConfigurationNamer(Project project) {
            this.myProject = project;
        }

        public String getName(C settings) {
            return settings.getPresentableName(this.myProject);
        }

        public boolean canRename(C item) {
            return false;
        }

        public void setName(C settings, String newName) {
        }
    }
}

