/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.HideableTitledPanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.SmartList;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.tools.quality.QualityToolProjectConfigurableForm;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualityToolCommonConfigurable
extends CompositeConfigurable<Configurable>
implements SearchableConfigurable {
    static final String ID = "settings.php.quality.tools";
    private JPanel myRootPanel;
    private JPanel myContentPanel;
    private final List<Pair<Configurable, HideableTitledPanel>> myConfigurables;
    private final Project myProject;

    public QualityToolCommonConfigurable(Project project) {
        this.$$$setupUI$$$();
        this.myConfigurables = new SmartList();
        this.myProject = project;
    }

    @Nullable
    public JComponent createComponent() {
        this.myContentPanel.removeAll();
        List configurables = this.getConfigurables();
        this.myContentPanel.setLayout((LayoutManager)new GridLayoutManager(configurables.size(), 1, (Insets)JBUI.emptyInsets(), -1, -1, false, false));
        for (int i = 0; i < configurables.size(); ++i) {
            Configurable configurable = (Configurable)configurables.get(i);
            HideableTitledPanel panel2 = new HideableTitledPanel("&" + configurable.getDisplayName(), false, configurable.createComponent(), false);
            this.myConfigurables.add((Pair<Configurable, HideableTitledPanel>)Pair.create((Object)configurable, (Object)panel2));
            this.myContentPanel.add((Component)panel2, QualityToolCommonConfigurable.getGridConstraints(i));
        }
        return this.myRootPanel;
    }

    public void showConfigurable(@NotNull String name) {
        if (name == null) {
            QualityToolCommonConfigurable.$$$reportNull$$$0(0);
        }
        this.myConfigurables.forEach(i -> {
            ((HideableTitledPanel)i.getSecond()).setOn(((Configurable)i.getFirst()).getDisplayName().equals(name));
            ((QualityToolProjectConfigurableForm)i.getFirst()).updateWarningLabel();
        });
    }

    @NotNull
    private static GridConstraints getGridConstraints(int row) {
        return new GridConstraints(row, 0, 1, 1, 9, 1, 0, 0, null, null, null);
    }

    @NotNull
    protected List<Configurable> createConfigurables() {
        ConfigurableEP[] extensions = (ConfigurableEP[])QualityToolProjectConfigurableForm.EP_NAME.getExtensions((AreaInstance)this.myProject);
        List<Configurable> list = Arrays.stream(extensions).filter(Objects::nonNull).map(ConfigurableWrapper::wrapConfigurable).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            QualityToolCommonConfigurable.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void reset() {
        super.reset();
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public String getDisplayName() {
        return PhpBundle.message("configurable.QualityToolCommonConfigurable.display.name", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.php.qualitytools";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolCommonConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolCommonConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showConfigurable";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

