/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolValidationInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualityToolAnnotatorInfo<T extends QualityToolValidationInspection> {
    private final VirtualFile myOriginalFile;
    private String myTempFile;
    private final PsiFile myPsiFile;
    @NotNull
    private final T myInspection;
    @NotNull
    private final Project myProject;
    private final boolean myIsOnTheFly;
    private PsiElement myContextElement;
    private final String myInterpreterId;
    private final String myToolPath;
    private final int myMaxMessagesPerFile;
    private final int myTimeout;

    public QualityToolAnnotatorInfo(@Nullable PsiFile psiFile, @NotNull T inspection, @NotNull Project project, @Nullable String interpreterId, @NotNull String toolPath, int maxMessagesPerFile, int timeout, boolean isOnTheFly) {
        if (inspection == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(0);
        }
        if (project == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(1);
        }
        if (toolPath == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(2);
        }
        this.myInspection = inspection;
        this.myProject = project;
        this.myPsiFile = psiFile;
        this.myOriginalFile = psiFile != null ? psiFile.getVirtualFile() : null;
        this.myInterpreterId = interpreterId;
        this.myToolPath = toolPath;
        this.myMaxMessagesPerFile = maxMessagesPerFile;
        this.myTimeout = timeout;
        this.myIsOnTheFly = isOnTheFly;
    }

    public QualityToolAnnotatorInfo(@Nullable PsiFile psiFile, @NotNull T inspection, @NotNull Project project, @NotNull QualityToolConfiguration configuration, boolean isOnTheFly) {
        if (inspection == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(3);
        }
        if (project == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(4);
        }
        if (configuration == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(5);
        }
        this(psiFile, inspection, project, configuration.getInterpreterId(), configuration.getToolPath(), configuration.getMaxMessagesPerFile(), configuration.getTimeout(), isOnTheFly);
    }

    public String getTempFile() {
        return this.myTempFile;
    }

    public void setTempFile(@NotNull String tempFile) {
        if (tempFile == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(6);
        }
        this.myTempFile = tempFile;
    }

    public String getTempFilePath() {
        return PathUtil.toSystemIndependentName((String)this.myTempFile);
    }

    public String getTempFileName() {
        return QualityToolAnnotatorInfo.truncateExtension(PathUtil.getFileName((String)this.myTempFile));
    }

    public PsiFile getPsiFile() {
        return this.myPsiFile;
    }

    @NotNull
    public T getInspection() {
        T t = this.myInspection;
        if (t == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(7);
        }
        return t;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(8);
        }
        return project;
    }

    @Nullable
    public String getInterpreterId() {
        return this.myInterpreterId;
    }

    @NotNull
    public String getToolPath() {
        String string = this.myToolPath;
        if (string == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public VirtualFile getOriginalFile() {
        return this.myOriginalFile;
    }

    public String getOriginalFileName() {
        return QualityToolAnnotatorInfo.truncateExtension(this.myOriginalFile.getName());
    }

    private static String truncateExtension(@NotNull String fileName) {
        int extPos;
        if (fileName == null) {
            QualityToolAnnotatorInfo.$$$reportNull$$$0(10);
        }
        return (extPos = fileName.lastIndexOf(".")) >= 0 ? fileName.substring(0, extPos) : fileName;
    }

    public boolean isOnTheFly() {
        return this.myIsOnTheFly;
    }

    public PsiElement getContextElement() {
        return this.myContextElement;
    }

    public void setContextElement(PsiElement contextElement) {
        this.myContextElement = contextElement;
    }

    public int getMaxMessagesPerFile() {
        return this.myMaxMessagesPerFile;
    }

    public int getTimeout() {
        return this.myTimeout;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolAnnotatorInfo";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolAnnotatorInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspection";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTempFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "truncateExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

