/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationBuilder;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkFileTransfer;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.tools.quality.QualityToolAnnotationAppender;
import com.jetbrains.php.tools.quality.QualityToolAnnotatorInfo;
import com.jetbrains.php.tools.quality.QualityToolBlackList;
import com.jetbrains.php.tools.quality.QualityToolConfigurableList;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import com.jetbrains.php.tools.quality.QualityToolProcessCreator;
import com.jetbrains.php.tools.quality.QualityToolType;
import com.jetbrains.php.tools.quality.QualityToolValidationException;
import com.jetbrains.php.tools.quality.QualityToolValidationInspection;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolAnnotator<T extends QualityToolValidationInspection>
extends ExternalAnnotator<QualityToolAnnotatorInfo, QualityToolMessageProcessor> {
    private static final Logger LOG = Logger.getInstance(QualityToolAnnotator.class);
    public static final String GROUP_ID = "PHP External Quality Tools";
    @NlsSafe
    public static final String NEW_LINE = "\n";

    public final QualityToolAnnotatorInfo<T> collectAnnotatorInfo(@Nullable PsiFile file, @Nullable Editor editor, @NotNull Project project, boolean isOnTheFly) {
        int caretPos;
        PsiElement currElement;
        LocalInspectionTool tool;
        String id;
        InspectionProfileImpl inspectionProfile;
        InspectionToolWrapper inspectionTool;
        if (project == null) {
            QualityToolAnnotator.$$$reportNull$$$0(0);
        }
        if ((inspectionTool = (inspectionProfile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile()).getInspectionTool(id = this.getQualityToolType().getInspectionId(), (PsiElement)file)) == null || isOnTheFly && !inspectionProfile.isToolEnabled(HighlightDisplayKey.find((String)id), (PsiElement)file)) {
            return null;
        }
        LocalInspectionTool localInspectionTool = tool = inspectionTool instanceof LocalInspectionToolWrapper ? (LocalInspectionTool)inspectionTool.getTool() : ((GlobalInspectionTool)inspectionTool.getTool()).getSharedLocalInspectionTool();
        if (tool == null) {
            return null;
        }
        if (file != null && !this.isFileSuitable(file, (QualityToolValidationInspection)tool)) {
            return null;
        }
        if (file != null && SuppressionUtil.inspectionResultSuppressed((PsiElement)file, (LocalInspectionTool)tool)) {
            return null;
        }
        QualityToolConfiguration configuration = this.getConfiguration(project, tool);
        if (configuration == null || StringUtil.isEmpty((String)configuration.getToolPath())) {
            return null;
        }
        QualityToolAnnotatorInfo<QualityToolValidationInspection> info = this.createAnnotatorInfo(file, (QualityToolValidationInspection)tool, project, configuration, isOnTheFly);
        if (isOnTheFly && editor != null && file != null && (currElement = file.findElementAt((caretPos = editor.getCaretModel().getOffset()) - 1)) != null) {
            PsiElement parent;
            for (parent = currElement; parent != null && !PhpElementTypes.ANY_GROUP_STATEMENT.contains(parent.getNode().getElementType()) && !(parent instanceof PsiFile); parent = parent.getParent()) {
            }
            if (parent == null) {
                parent = file;
            }
            info.setContextElement(parent);
        }
        this.addAdditionalAnnotatorInfo(info, (QualityToolValidationInspection)tool);
        return info;
    }

    @NotNull
    protected QualityToolAnnotatorInfo<T> createAnnotatorInfo(@Nullable PsiFile file, T tool, Project project, QualityToolConfiguration configuration, boolean isOnTheFly) {
        return new QualityToolAnnotatorInfo<T>(file, tool, project, configuration, isOnTheFly);
    }

    protected void addAdditionalAnnotatorInfo(QualityToolAnnotatorInfo<T> info, QualityToolValidationInspection tool) {
    }

    protected boolean isFileSuitable(@NotNull PsiFile file, @NotNull QualityToolValidationInspection inspection) {
        if (file == null) {
            QualityToolAnnotator.$$$reportNull$$$0(1);
        }
        if (inspection == null) {
            QualityToolAnnotator.$$$reportNull$$$0(2);
        }
        return file instanceof PhpFile && file.getViewProvider().getBaseLanguage() == PhpLanguage.INSTANCE && file.getContext() == null && !"/PHP Console".equals(file.getOriginalFile().getVirtualFile().getPath());
    }

    @Nullable
    public QualityToolAnnotatorInfo<T> collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        if (file == null) {
            QualityToolAnnotator.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            QualityToolAnnotator.$$$reportNull$$$0(4);
        }
        return hasErrors ? null : this.collectAnnotatorInfo(file, editor, file.getProject(), true);
    }

    @Nullable
    protected QualityToolConfiguration getConfiguration(@NotNull Project project, @NotNull LocalInspectionTool inspection) {
        if (project == null) {
            QualityToolAnnotator.$$$reportNull$$$0(5);
        }
        if (inspection == null) {
            QualityToolAnnotator.$$$reportNull$$$0(6);
        }
        try {
            return this.getQualityToolType().getProjectConfiguration(project).findSelectedConfiguration(project);
        }
        catch (QualityToolValidationException qualityToolValidationException) {
            return null;
        }
    }

    @NotNull
    protected abstract QualityToolType getQualityToolType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final QualityToolMessageProcessor doAnnotate(QualityToolAnnotatorInfo collectedInfo) {
        if (!this.isContextValid(collectedInfo)) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.testTool(collectedInfo);
        }
        if (collectedInfo.getPsiFile() != null && InjectedLanguageManager.getInstance((Project)collectedInfo.getProject()).isInjectedFragment(collectedInfo.getPsiFile())) {
            return null;
        }
        String id = collectedInfo.getInterpreterId();
        PhpSdkAdditionalData sdkData = StringUtil.isEmpty((String)id) ? null : PhpInterpretersManagerImpl.getInstance(collectedInfo.getProject()).findInterpreterDataById(id);
        PhpSdkFileTransfer transfer = PhpSdkFileTransfer.getSdkFileTransfer(sdkData);
        ProgressManager.checkCanceled();
        try {
            if (collectedInfo.getOriginalFile() != null) {
                this.createTempFile(collectedInfo, transfer);
            }
        }
        catch (ExecutionException e) {
            this.showProcessErrorMessage(collectedInfo, StringUtil.notNullize((String)e.getMessage(), (String)PhpBundle.message("quality.tool.can.not.create.temporary.file", new Object[0])));
            QualityToolAnnotator.logWarning(collectedInfo, "Can not create temporary file", (Exception)((Object)e));
            return null;
        }
        catch (IOException e) {
            this.showProcessErrorMessage(collectedInfo, e.getMessage());
            QualityToolAnnotator.logWarning(collectedInfo, "Can not create temporary file", e);
            return null;
        }
        ProgressManager.checkCanceled();
        QualityToolMessageProcessor messageProcessor = this.createMessageProcessor(collectedInfo);
        try {
            this.runTool(messageProcessor, collectedInfo, transfer);
        }
        catch (ExecutionException e) {
            this.showProcessErrorMessage(collectedInfo, e.getMessage());
            QualityToolAnnotator.logWarning(collectedInfo, "Can not execute quality tool", (Exception)((Object)e));
        }
        finally {
            try {
                if (collectedInfo.getOriginalFile() != null) {
                    QualityToolAnnotator.removeTempFile(collectedInfo, transfer);
                }
            }
            catch (ExecutionException e) {
                QualityToolAnnotator.logWarning(collectedInfo, "Can not remove temporary file", (Exception)((Object)e));
            }
        }
        return messageProcessor.isFatalError() ? null : messageProcessor;
    }

    protected boolean isContextValid(QualityToolAnnotatorInfo collectedInfo) {
        if (collectedInfo == null) {
            return false;
        }
        return collectedInfo.getPsiFile() == null || !collectedInfo.getProject().isDisposed() && new ContextValidator().isValid((PsiElement)collectedInfo.getPsiFile()) && (Boolean)ReadAction.compute(() -> collectedInfo.getPsiFile().isValid()) != false;
    }

    public static void logWarning(@NotNull QualityToolAnnotatorInfo collectedInfo, @NotNull String prefix, @Nullable Exception e) {
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(7);
        }
        if (prefix == null) {
            QualityToolAnnotator.$$$reportNull$$$0(8);
        }
        String message = prefix + " for '" + collectedInfo.getTempFilePath() + "' on " + QualityToolAnnotator.toPresentableLocation(collectedInfo);
        LOG.warn(message + (String)(e == null ? "" : ": " + e.getMessage()));
    }

    private void createTempFile(@NotNull QualityToolAnnotatorInfo collectedInfo, @NotNull PhpSdkFileTransfer transfer) throws IOException, ExecutionException {
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(9);
        }
        if (transfer == null) {
            QualityToolAnnotator.$$$reportNull$$$0(10);
        }
        Project project = collectedInfo.getProject();
        String path = null;
        String basePath = project.getBasePath();
        String pathToOriginalFile = FileUtil.toSystemIndependentName((String)collectedInfo.getOriginalFile().getPath());
        if (StringUtil.isNotEmpty((String)basePath) && FileUtil.isAncestor((String)basePath, (String)pathToOriginalFile, (boolean)true)) {
            path = FileUtil.getRelativePath((String)basePath, (String)pathToOriginalFile, (char)'/');
        }
        if (StringUtil.isEmpty(path)) {
            path = collectedInfo.getOriginalFile().getName();
        }
        if (project.isDisposed()) {
            throw new ExecutionException(PhpBundle.message("dialog.message.cannot.create.file.because.project.already.disposed", new Object[0]));
        }
        String file = transfer.createFile(project, path, QualityToolAnnotator.getFileContent(collectedInfo.getPsiFile()), this.getTemporaryFilesFolder(), collectedInfo.getTimeout() / 2);
        collectedInfo.setTempFile(file);
    }

    private static String getFileContent(@NotNull PsiFile file) {
        if (file == null) {
            QualityToolAnnotator.$$$reportNull$$$0(11);
        }
        return (String)ReadAction.compute(() -> file.getText());
    }

    private static void removeTempFile(@NotNull QualityToolAnnotatorInfo collectedInfo, @NotNull PhpSdkFileTransfer transfer) throws ExecutionException {
        String tempFile;
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(12);
        }
        if (transfer == null) {
            QualityToolAnnotator.$$$reportNull$$$0(13);
        }
        if ((tempFile = collectedInfo.getTempFile()) == null) {
            return;
        }
        transfer.delete(collectedInfo.getProject(), collectedInfo.getTimeout() / 2, false);
    }

    @NotNull
    protected String getTemporaryFilesFolder() {
        String string = this.getQualityToolType().getDisplayName() + "temp_folder";
        if (string == null) {
            QualityToolAnnotator.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static String toPresentableLocation(@NotNull QualityToolAnnotatorInfo collectedInfo) {
        PhpInterpreter interpreter;
        Project project;
        String interpreterId;
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(15);
        }
        if (StringUtil.isNotEmpty((String)(interpreterId = collectedInfo.getInterpreterId())) && !(project = collectedInfo.getProject()).isDisposed() && (interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(interpreterId)) != null) {
            return interpreter.getPhpSdkAdditionalData().toPresentablePath();
        }
        return "local";
    }

    protected void runTool(@NotNull QualityToolMessageProcessor messageProcessor, @NotNull QualityToolAnnotatorInfo<T> annotatorInfo, @NotNull PhpSdkFileTransfer transfer) throws ExecutionException {
        if (messageProcessor == null) {
            QualityToolAnnotator.$$$reportNull$$$0(16);
        }
        if (annotatorInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(17);
        }
        if (transfer == null) {
            QualityToolAnnotator.$$$reportNull$$$0(18);
        }
        T inspection = annotatorInfo.getInspection();
        Project project = annotatorInfo.getProject();
        String workingDirectory = this.getWorkingDir(project, inspection);
        List<String> options = this.getOptions(annotatorInfo.getTempFilePath(), inspection, project, annotatorInfo.isOnTheFly());
        if (options == null) {
            return;
        }
        this.checkOptions(options, workingDirectory, project);
        if (annotatorInfo.getOriginalFile() != null) {
            messageProcessor.addSubstitution(annotatorInfo.getTempFileName(), annotatorInfo.getOriginalFileName());
        }
        workingDirectory = QualityToolAnnotator.updateIfRemote(workingDirectory, project, messageProcessor.getQualityToolType());
        QualityToolProcessCreator.runToolProcess(annotatorInfo, this.getQualityToolType().getQualityToolBlackList(project), messageProcessor, workingDirectory, transfer, options);
        if (messageProcessor.getInternalErrorMessage() != null && annotatorInfo.isOnTheFly()) {
            if (annotatorInfo.isOnTheFly()) {
                String message = messageProcessor.getInternalErrorMessage().getMessageText();
                this.showProcessErrorMessage(annotatorInfo, messageProcessor.getType().equals((Object)QualityToolMessageProcessor.ErrorMessageType.TIMEOUT) ? this.getAdditionalTimeoutActions() : Collections.emptyList(), message);
                QualityToolAnnotator.logWarning(annotatorInfo, message, null);
            }
            messageProcessor.setFatalError();
        }
    }

    protected void checkOptions(@NotNull List<String> options, @NotNull String workingDir, @NotNull Project project) {
        if (options == null) {
            QualityToolAnnotator.$$$reportNull$$$0(19);
        }
        if (workingDir == null) {
            QualityToolAnnotator.$$$reportNull$$$0(20);
        }
        if (project == null) {
            QualityToolAnnotator.$$$reportNull$$$0(21);
        }
    }

    @Nullable
    protected abstract List<String> getOptions(@Nullable String var1, @NotNull T var2, @NotNull Project var3);

    @Nullable
    protected List<String> getOptions(@Nullable String filePath, @NotNull T inspection, @NotNull Project project, boolean isOnTheFly) {
        if (inspection == null) {
            QualityToolAnnotator.$$$reportNull$$$0(22);
        }
        if (project == null) {
            QualityToolAnnotator.$$$reportNull$$$0(23);
        }
        return this.getOptions(filePath, inspection, project);
    }

    protected String getWorkingDir(@NotNull Project project, @NotNull T inspection) {
        if (project == null) {
            QualityToolAnnotator.$$$reportNull$$$0(24);
        }
        if (inspection == null) {
            QualityToolAnnotator.$$$reportNull$$$0(25);
        }
        return project.getBasePath();
    }

    protected abstract QualityToolMessageProcessor createMessageProcessor(@NotNull QualityToolAnnotatorInfo var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private QualityToolMessageProcessor testTool(@NotNull QualityToolAnnotatorInfo<T> annotatorInfo) {
        if (annotatorInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(26);
        }
        QualityToolMessageProcessor messageProcessor = this.createMessageProcessor(annotatorInfo);
        try {
            File testFile = new File(FileUtilRt.getNameWithoutExtension((String)annotatorInfo.getOriginalFile().getPath()) + ".txt");
            if (!testFile.exists()) {
                return null;
            }
            try (BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(testFile), StandardCharsets.UTF_8));){
                input.lines().map(line -> line + NEW_LINE).forEach(messageProcessor::parseLine);
                messageProcessor.done();
            }
            return messageProcessor.isFatalError() ? null : messageProcessor;
        }
        catch (Exception e) {
            LOG.warn("Can not run quality tool: " + e.getMessage());
            return null;
        }
    }

    public void showProcessErrorMessage(@NotNull QualityToolAnnotatorInfo collectedInfo, @NotNull @NlsSafe String messageText) {
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(27);
        }
        if (messageText == null) {
            QualityToolAnnotator.$$$reportNull$$$0(28);
        }
        if (!collectedInfo.isOnTheFly() || collectedInfo.getProject().isDisposed()) {
            LOG.warn(messageText);
            return;
        }
        Object inspection = collectedInfo.getInspection();
        String text = MessageFormat.format("{0}{1}", messageText, StringUtil.endsWith((CharSequence)messageText, (CharSequence)"</a>") ? MessageFormat.format(" {0} ", PhpBundle.message("or.disable.inspection", new Object[0])) : "<br>");
        final QualityToolType type = this.getQualityToolType();
        AnAction openSettingsAction = new AnAction(PhpBundle.message("open.tool.settings", type.getDisplayName())){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((project = e.getProject()) != null && !project.isDisposed()) {
                    PhpUiUtil.editConfigurable(project, (Configurable)new QualityToolConfigurableList(project, type, null){

                        protected QualityToolType getQualityToolType() {
                            return type;
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/QualityToolAnnotator$1", "actionPerformed"));
            }
        };
        QualityToolAnnotator.showProcessErrorMessage(inspection, text, Collections.singletonList(openSettingsAction));
    }

    public void showProcessErrorMessage(@NotNull QualityToolAnnotatorInfo collectedInfo, @NotNull List<AnAction> timeoutActions, @NlsSafe @NotNull String messageText) {
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(29);
        }
        if (timeoutActions == null) {
            QualityToolAnnotator.$$$reportNull$$$0(30);
        }
        if (messageText == null) {
            QualityToolAnnotator.$$$reportNull$$$0(31);
        }
        Object inspection = collectedInfo.getInspection();
        HtmlBuilder builder = new HtmlBuilder();
        builder.append(messageText);
        builder.append((HtmlChunk)HtmlChunk.br());
        QualityToolAnnotator.showProcessErrorMessage(inspection, builder.toString(), ContainerUtil.concat(timeoutActions, Collections.singletonList(new AnAction(PhpBundle.message("open.inspection.settings", ((QualityToolValidationInspection)((Object)inspection)).getToolName())){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((project = e.getProject()) != null && !project.isDisposed()) {
                    EditInspectionToolsSettingsAction.editToolSettings((Project)project, (InspectionProfileImpl)ProjectInspectionProfileManager.getInstance((Project)project).getCurrentProfile(), (String)QualityToolAnnotator.this.getQualityToolType().getInspectionId());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/QualityToolAnnotator$2", "actionPerformed"));
            }
        })));
    }

    public void showProcessErrorMessage(final @NotNull QualityToolAnnotatorInfo collectedInfo, final @NotNull QualityToolBlackList blackList, @NlsSafe @NotNull String messageText) {
        if (collectedInfo == null) {
            QualityToolAnnotator.$$$reportNull$$$0(32);
        }
        if (blackList == null) {
            QualityToolAnnotator.$$$reportNull$$$0(33);
        }
        if (messageText == null) {
            QualityToolAnnotator.$$$reportNull$$$0(34);
        }
        Object inspection = collectedInfo.getInspection();
        HtmlBuilder builder = new HtmlBuilder();
        builder.append(messageText);
        builder.append((HtmlChunk)HtmlChunk.br());
        QualityToolAnnotator.showProcessErrorMessage(inspection, builder.toString(), ContainerUtil.concat((List)ContainerUtil.emptyList(), Collections.singletonList(new AnAction(PhpBundle.message("exclude.0.from.1.analysis.a", collectedInfo.getOriginalFile().getName(), ((QualityToolValidationInspection)((Object)inspection)).getToolName()), (QualityToolValidationInspection)((Object)inspection)){
            final /* synthetic */ QualityToolValidationInspection val$inspection;
            {
                this.val$inspection = qualityToolValidationInspection;
                super(arg0);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                VirtualFile originalFile;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (blackList.addFile(originalFile = collectedInfo.getOriginalFile())) {
                    Notifications.Bus.notify((Notification)new Notification(QualityToolAnnotator.GROUP_ID, this.val$inspection.getToolName(), PhpBundle.message("quality.tools.0.added.to.ignored.files.list", originalFile.getName()), NotificationType.INFORMATION));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/QualityToolAnnotator$3", "actionPerformed"));
            }
        })));
    }

    protected List<AnAction> getAdditionalTimeoutActions() {
        return Collections.emptyList();
    }

    public static void showProcessErrorMessage(@NotNull QualityToolValidationInspection inspection, @NotNull @NlsContexts.NotificationContent String messageText, @NotNull List<AnAction> actions) {
        if (inspection == null) {
            QualityToolAnnotator.$$$reportNull$$$0(35);
        }
        if (messageText == null) {
            QualityToolAnnotator.$$$reportNull$$$0(36);
        }
        if (actions == null) {
            QualityToolAnnotator.$$$reportNull$$$0(37);
        }
        NotificationBuilder builder = new NotificationBuilder(GROUP_ID, inspection.getToolName(), messageText, NotificationType.ERROR);
        actions.forEach(arg_0 -> ((NotificationBuilder)builder).addAction(arg_0));
        Notifications.Bus.notify((Notification)builder.build());
    }

    private static PhpPathMapper getPathMapper(Project project, QualityToolType type) {
        try {
            Object configuration = type.getProjectConfiguration(project).findSelectedConfiguration(project, false);
            if (configuration != null) {
                String interpreterId = configuration.getInterpreterId();
                PhpInterpreter id = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(interpreterId);
                PhpRemoteInterpreterManager instance = PhpRemoteInterpreterManager.getInstance();
                return instance != null && id != null && id.isRemote() ? PhpPathMapper.create(instance.createPathMappings(project, id.getPhpSdkAdditionalData()).getPathMappings()) : PhpPathMapper.createDefaultMapper();
            }
        }
        catch (QualityToolValidationException qualityToolValidationException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public static String updateToLocalIfRemote(@NotNull String path, Project project, QualityToolType type) {
        PhpPathMapper pathMapper;
        if (path == null) {
            QualityToolAnnotator.$$$reportNull$$$0(38);
        }
        String localPath = (pathMapper = QualityToolAnnotator.getPathMapper(project, type)) != null ? pathMapper.getLocalPath(path) : path;
        String string = localPath != null ? localPath : path;
        if (string == null) {
            QualityToolAnnotator.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    public static String updateIfRemote(@NotNull String path, Project project, QualityToolType type) {
        PhpPathMapper pathMapper;
        if (path == null) {
            QualityToolAnnotator.$$$reportNull$$$0(40);
        }
        String remotePath = (pathMapper = QualityToolAnnotator.getPathMapper(project, type)) != null ? pathMapper.getRemoteFilePath(path) : path;
        String string = remotePath != null ? remotePath : path;
        if (string == null) {
            QualityToolAnnotator.$$$reportNull$$$0(41);
        }
        return string;
    }

    public void apply(@NotNull PsiFile file, QualityToolMessageProcessor annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            QualityToolAnnotator.$$$reportNull$$$0(42);
        }
        if (holder == null) {
            QualityToolAnnotator.$$$reportNull$$$0(43);
        }
        new OnTheFlyAnnotationAppender(file, new OnTheFlyAnnotationTarget(file.getProject(), holder)).apply(annotationResult);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 39: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 39: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: 
            case 22: 
            case 25: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 27: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 10: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transfer";
                break;
            }
            case 14: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolAnnotator";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageProcessor";
                break;
            }
            case 17: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotatorInfo";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 28: 
            case 31: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageText";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeoutActions";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blackList";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolAnnotator";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemporaryFilesFolder";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "updateToLocalIfRemote";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "updateIfRemote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectAnnotatorInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isFileSuitable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectInformation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "logWarning";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFileContent";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeTempFile";
                break;
            }
            case 14: 
            case 39: 
            case 41: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "toPresentableLocation";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runTool";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkOptions";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getOptions";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDir";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "testTool";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "showProcessErrorMessage";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "updateToLocalIfRemote";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "updateIfRemote";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 39: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ContextValidator
    extends PsiRecursiveElementVisitor {
        private boolean myIsValid = true;

        private ContextValidator() {
        }

        public boolean isValid(PsiElement rootElement) {
            if (rootElement == null) {
                return true;
            }
            ApplicationManager.getApplication().runReadAction(() -> this.visitElement(rootElement));
            return this.myIsValid;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                ContextValidator.$$$reportNull$$$0(0);
            }
            if (!this.myIsValid) {
                return;
            }
            if (element instanceof PsiErrorElement) {
                this.myIsValid = false;
                return;
            }
            super.visitElement(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/tools/quality/QualityToolAnnotator$ContextValidator", "visitElement"));
        }
    }

    private static class OnTheFlyAnnotationAppender
    extends QualityToolAnnotationAppender {
        OnTheFlyAnnotationAppender(PsiFile file, QualityToolAnnotationAppender.AnnotationTarget holder) {
            super(file, holder);
        }
    }

    protected static class OnTheFlyAnnotationTarget
    implements QualityToolAnnotationAppender.AnnotationTarget {
        private final AnnotationHolder myHolder;
        private final Project myProject;

        public OnTheFlyAnnotationTarget(Project project, AnnotationHolder holder) {
            this.myHolder = holder;
            this.myProject = project;
        }

        @Override
        public void createAnnotation(HighlightDisplayLevel severity, TextRange range, @InspectionMessage String messageText, IntentionAction ... actions) {
            AnnotationBuilder builder = this.myHolder.newAnnotation(severity.getSeverity(), messageText).needsUpdateOnTyping().range(range);
            TextAttributes key = SeverityRegistrar.getSeverityRegistrar((Project)this.myProject).getTextAttributesBySeverity(severity.getSeverity());
            if (key != null) {
                builder = builder.enforcedTextAttributes(key);
            }
            for (IntentionAction fix : actions) {
                builder = builder.withFix(fix);
            }
            builder.create();
        }

        @Override
        public void creteInternalErrorAnnotation(@NotNull PsiFile file, @NotNull @InspectionMessage String messageText, IntentionAction ... quickFix) {
            if (file == null) {
                OnTheFlyAnnotationTarget.$$$reportNull$$$0(0);
            }
            if (messageText == null) {
                OnTheFlyAnnotationTarget.$$$reportNull$$$0(1);
            }
            AnnotationBuilder builder = this.myHolder.newAnnotation(HighlightSeverity.WARNING, messageText).range((PsiElement)file).fileLevel().needsUpdateOnTyping();
            Arrays.stream(quickFix).forEach(q -> builder.withFix(q));
            builder.create();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "messageText";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/tools/quality/QualityToolAnnotator$OnTheFlyAnnotationTarget";
            objectArray[2] = "creteInternalErrorAnnotation";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

