/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework.ui;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpTestFrameworkVersionDetector;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.testFramework.PhpTestFrameworkBySdkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import com.jetbrains.php.testFramework.PhpTestFrameworkVersionCache;
import com.jetbrains.php.testFramework.ui.PhpTestAdditionalInfoComponent;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkBaseConfigurableForm;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkVersionLabel;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.ui.ResultMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTestFrameworkVersionComponent
implements PhpTestAdditionalInfoComponent {
    private static final Logger LOG = Logger.getInstance(PhpTestFrameworkVersionComponent.class);
    private final Project myProject;
    private final JPanel myMainPanel;
    private final PhpTestFrameworkBaseConfigurableForm myForm;
    private final PhpTestFrameworkVersionLabel myVersionLabel;
    private final PhpTestFrameworkType myFrameworkType;
    private final PhpTestFrameworkVersionDetector myDetector;
    @Nullable
    private String myLastLoadedVersion;
    @NotNull
    private final Alarm myReloadAlarm;
    private boolean myDisposed;

    public PhpTestFrameworkVersionComponent(@NotNull Project project, @NotNull PhpTestFrameworkType frameworkType, @NotNull PhpTestFrameworkVersionDetector detector, @NotNull PhpTestFrameworkBaseConfigurableForm form) {
        if (project == null) {
            PhpTestFrameworkVersionComponent.$$$reportNull$$$0(0);
        }
        if (frameworkType == null) {
            PhpTestFrameworkVersionComponent.$$$reportNull$$$0(1);
        }
        if (detector == null) {
            PhpTestFrameworkVersionComponent.$$$reportNull$$$0(2);
        }
        if (form == null) {
            PhpTestFrameworkVersionComponent.$$$reportNull$$$0(3);
        }
        this.myLastLoadedVersion = null;
        this.myDisposed = false;
        this.myProject = project;
        this.myForm = form;
        this.myFrameworkType = frameworkType;
        this.myDetector = detector;
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myVersionLabel = new PhpTestFrameworkVersionLabel(frameworkType.getDisplayName());
        this.myMainPanel.add((Component)((Object)this.myVersionLabel), "West");
        this.myReloadAlarm = new Alarm();
        form.setActionsToolbar(new AnAction[]{PhpUiUtil.createReloadAction((Computable<ResultMessage>)((Computable)() -> this.reloadVersion()), (NotNullComputable<Boolean>)((NotNullComputable)() -> this.myReloadAlarm.isEmpty()))});
        form.addExecutionPathListener(new PhpTestFrameworkBaseConfigurableForm.PhpFilePathUpdateListener(){

            @Override
            public void onFileChosen(@NotNull String path) {
                if (path == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpTestFrameworkVersionComponent.this.scheduleInfoComputation();
            }

            @Override
            public void onFileUpdated(@NotNull String path) {
                if (path == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "path";
                objectArray2[1] = "com/jetbrains/php/testFramework/ui/PhpTestFrameworkVersionComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFileChosen";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFileUpdated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myLastLoadedVersion = PhpTestFrameworkVersionCache.getCache(this.myProject, this.myForm.getConfiguration());
    }

    @Nullable
    public String getVersion() {
        return this.myLastLoadedVersion;
    }

    public void scheduleInfoComputation() {
        if (this.myDisposed) {
            return;
        }
        this.myReloadAlarm.cancelAllRequests();
        this.myReloadAlarm.addRequest(() -> this.reloadVersion(), 200);
    }

    @NotNull
    private ResultMessage reloadVersion() {
        ResultMessage result;
        PhpInterpreter interpreter;
        Object configuration = this.myForm.getConfiguration();
        boolean tryAnotherLocal = false;
        if (configuration instanceof PhpTestFrameworkBySdkConfiguration) {
            String id = ((PhpTestFrameworkBySdkConfiguration)configuration).getInterpreterId();
            interpreter = PhpInterpretersManagerImpl.getInstance(this.myProject).findInterpreterById(id);
        } else {
            interpreter = PhpProjectConfigurationFacade.getInstance(this.myProject).getInterpreter();
            if (interpreter == null || interpreter.isRemote()) {
                interpreter = (PhpInterpreter)ContainerUtil.find(PhpInterpretersManagerImpl.getInstance(this.myProject).getInterpreters(), i -> !i.isRemote());
                tryAnotherLocal = true;
            }
        }
        if (interpreter == null) {
            return new ResultMessage(PhpBundle.message("php.test.framework.configuration.ui.select.interpreter", "PHPUnit"), MessageType.ERROR);
        }
        String path = this.myForm.getPathToExecutable();
        String toolName = this.myFrameworkType.getDisplayName();
        String newPath = PhpTestFrameworkVersionDetector.getPathToExecutable(toolName, path, configuration.isLocal());
        try {
            assert (interpreter != null);
            this.myLastLoadedVersion = StringUtil.nullize((String)this.myDetector.getVersion(this.myProject, interpreter, newPath).toString());
            String message = PhpBundle.message("php.test.framework.configuration.updated.version", toolName);
            result = new ResultMessage(message, MessageType.INFO);
        }
        catch (ExecutionException e) {
            this.myLastLoadedVersion = null;
            String message = StringUtil.notNullize((String)e.getMessage(), (String)PhpBundle.message("php.test.framework.configuration.can.not.update", toolName));
            result = new ResultMessage(message, MessageType.ERROR);
            LOG.warn((Throwable)e);
        }
        if (this.myLastLoadedVersion == null && tryAnotherLocal) {
            this.myLastLoadedVersion = PhpBundle.message("php.test.framework.default.interpreter.is.not.local", toolName);
        }
        this.resetVersion(newPath, this.myLastLoadedVersion);
        ResultMessage resultMessage = result;
        if (resultMessage == null) {
            PhpTestFrameworkVersionComponent.$$$reportNull$$$0(4);
        }
        return resultMessage;
    }

    private void resetVersion(@Nullable String path, @Nullable String version) {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            String oldPath = this.myForm.getPathToExecutable();
            if (StringUtil.isNotEmpty((String)path) && !FileUtil.pathsEqual((String)oldPath, (String)path)) {
                this.myForm.setPathToExecutable(path);
            }
            this.myVersionLabel.setVersion(version);
        });
    }

    @Nullable
    private String validateInterpreter(@Nullable PhpInterpreter interpreter, boolean localExpected) {
        if (interpreter == null) {
            return PhpBundle.message("php.test.framework.configuration.ui.select.interpreter", this.myFrameworkType.getDisplayName());
        }
        if (localExpected && interpreter.isRemote()) {
            return PhpBundle.message("php.test.framework.configuration.ui.select.local.interpreter", this.myFrameworkType.getDisplayName());
        }
        return null;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            PhpTestFrameworkVersionComponent.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @Override
    public boolean isModified(@NotNull PhpTestFrameworkConfiguration state) {
        if (state == null) {
            PhpTestFrameworkVersionComponent.$$$reportNull$$$0(6);
        }
        return !StringUtil.equals((CharSequence)PhpTestFrameworkVersionCache.getCache(this.myProject, state), (CharSequence)this.myLastLoadedVersion);
    }

    @Override
    public void apply(@NotNull PhpTestFrameworkConfiguration state) {
        if (state == null) {
            PhpTestFrameworkVersionComponent.$$$reportNull$$$0(7);
        }
        PhpTestFrameworkVersionCache.setCache(this.myProject, state, this.myLastLoadedVersion);
    }

    @Override
    public void reset(@NotNull PhpTestFrameworkConfiguration state) {
        if (state == null) {
            PhpTestFrameworkVersionComponent.$$$reportNull$$$0(8);
        }
        this.myLastLoadedVersion = PhpTestFrameworkVersionCache.getCache(this.myProject, state);
        if (this.myLastLoadedVersion == null && !ApplicationManager.getApplication().isUnitTestMode()) {
            UIUtil.invokeLaterIfNeeded(() -> this.scheduleInfoComputation());
        } else {
            this.resetVersion(state.getExecutablePath(), this.myLastLoadedVersion);
        }
    }

    @Override
    public void disposeUIResources() {
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myReloadAlarm);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "form";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/ui/PhpTestFrameworkVersionComponent";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/ui/PhpTestFrameworkVersionComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "reloadVersion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

