/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.ui.PhpTestAdditionalInfoComponent;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkBaseConfigurableForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpTestFrameworkConfigurationInfoComponent<T>
implements PhpTestAdditionalInfoComponent {
    @NotNull
    private static final Logger LOG = Logger.getInstance(PhpTestFrameworkConfigurationInfoComponent.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    private final JTextPane myTextPane;
    @NotNull
    private final JBLabel myLabel;
    @NotNull
    private final JPanel myComponent;

    public PhpTestFrameworkConfigurationInfoComponent(@NotNull Project project, @Nullable PhpTestFrameworkBaseConfigurableForm<?> form) {
        if (project == null) {
            PhpTestFrameworkConfigurationInfoComponent.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myComponent = new JPanel(new BorderLayout());
        this.myLabel = new JBLabel();
        this.myComponent.add((Component)this.myLabel, "North");
        this.myTextPane = new JTextPane();
        this.myTextPane.setEditable(false);
        this.myTextPane.setBackground(UIUtil.getPanelBackground());
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myTextPane);
        scrollPane.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        this.myComponent.add((Component)scrollPane, "West");
        if (form != null) {
            form.addConfigurationPathListener(this::updateConfigurations);
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            PhpTestFrameworkConfigurationInfoComponent.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    private void updateText(@NotNull String newPath) {
        if (newPath == null) {
            PhpTestFrameworkConfigurationInfoComponent.$$$reportNull$$$0(2);
        }
        this.myLabel.setText("");
        this.myLabel.setIcon(null);
        this.myTextPane.setText("");
        StyledDocument doc = (StyledDocument)this.myTextPane.getDocument();
        Style italicStyle = doc.addStyle("italicPhpTestFrameworkConfigurationInfoComponentStyle", null);
        StyleConstants.setItalic(italicStyle, true);
        String directoryPath = StringUtil.isNotEmpty((String)newPath) ? PathUtil.getParentPath((String)newPath) : StringUtil.notNullize((String)this.myProject.getBasePath());
        try {
            this.printConfigurationsHeader();
            this.printConfigurationsInfo(doc, italicStyle, directoryPath);
        }
        catch (BadLocationException e) {
            LOG.error((Throwable)e);
        }
        this.myComponent.updateUI();
    }

    private void printConfigurationsHeader() {
        if (this.getConfigurations().isEmpty()) {
            return;
        }
        this.myLabel.setText(this.getConfigurationsHeaderText());
        this.myLabel.setIcon(UIUtil.getBalloonInformationIcon());
    }

    @NotNull
    @Nls
    protected abstract String getConfigurationsHeaderText();

    protected abstract void printConfigurationsInfo(@NotNull StyledDocument var1, @NotNull Style var2, @NotNull String var3) throws BadLocationException;

    public abstract List<T> analyzeConfigurationFile(@NotNull String var1);

    public void updateConfigurations(@NotNull String newPath) {
        String canonicalNewPath;
        if (newPath == null) {
            PhpTestFrameworkConfigurationInfoComponent.$$$reportNull$$$0(3);
        }
        if (StringUtil.isNotEmpty((String)(canonicalNewPath = FileUtil.toCanonicalPath((String)newPath)))) {
            List<T> newConfigurations = this.analyzeConfigurationFile(canonicalNewPath);
            if (!this.getConfigurations().equals(newConfigurations)) {
                this.setConfigurations(newConfigurations);
            }
        } else {
            this.setConfigurations(this.getDefaultConfigurations());
        }
        this.updateText(canonicalNewPath);
    }

    @NotNull
    public abstract List<T> getDefaultConfigurations();

    @NotNull
    public abstract List<T> getConfigurations();

    @NotNull
    public abstract List<T> getConfigurationsFromSettings();

    public abstract void setConfigurations(@NotNull List<T> var1);

    public abstract void setConfigurationsToSettings(@NotNull List<T> var1);

    @Override
    public void reset(@NotNull PhpTestFrameworkConfiguration state) {
        if (state == null) {
            PhpTestFrameworkConfigurationInfoComponent.$$$reportNull$$$0(4);
        }
        this.setConfigurations(this.getConfigurationsFromSettings());
    }

    @Override
    public void apply(@NotNull PhpTestFrameworkConfiguration state) {
        if (state == null) {
            PhpTestFrameworkConfigurationInfoComponent.$$$reportNull$$$0(5);
        }
        this.setConfigurationsToSettings(this.getConfigurations());
    }

    @Override
    public boolean isModified(@NotNull PhpTestFrameworkConfiguration state) {
        if (state == null) {
            PhpTestFrameworkConfigurationInfoComponent.$$$reportNull$$$0(6);
        }
        return !this.getConfigurations().equals(this.getConfigurationsFromSettings());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/ui/PhpTestFrameworkConfigurationInfoComponent";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPath";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/ui/PhpTestFrameworkConfigurationInfoComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateConfigurations";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

