/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkSettingsManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkVersionCache;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTestFrameworkCollectorHelper {
    private static final PhpTestFrameworkCollectorHelper ourCollector = new PhpTestFrameworkCollectorHelper();

    @NotNull
    public Set<MetricEvent> collectUsages(@Nullable Project project) {
        PhpTestFrameworkSettingsManager manager = PhpTestFrameworkSettingsManager.getInstance(project);
        if (manager != null) {
            boolean isProjectLevel = project != null;
            Set<MetricEvent> frameworks = manager.getAllConfigurations().stream().filter(config -> config.isProjectLevel() == isProjectLevel).map(config -> this.toReportedData(project, (PhpTestFrameworkConfiguration)config)).filter(data -> data != null).collect(Collectors.toSet());
            if (!frameworks.isEmpty()) {
                Set<MetricEvent> set = frameworks;
                if (set == null) {
                    PhpTestFrameworkCollectorHelper.$$$reportNull$$$0(0);
                }
                return set;
            }
        }
        Set<MetricEvent> set = Collections.emptySet();
        if (set == null) {
            PhpTestFrameworkCollectorHelper.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Nullable
    protected MetricEvent toReportedData(@Nullable Project project, @NotNull PhpTestFrameworkConfiguration config) {
        if (config == null) {
            PhpTestFrameworkCollectorHelper.$$$reportNull$$$0(2);
        }
        String name = StringUtil.toLowerCase((String)config.getFrameworkType().getDisplayName());
        Version version = PhpTestFrameworkVersionCache.getCachedVersion(project, config);
        FeatureUsageData data = new FeatureUsageData().addData("framework", name).addData("version", (String)(version != null ? version.major + "." + version.minor : "unknown")).addData("level", project == null ? "ide" : "project");
        if (config instanceof PhpUnitSettings) {
            data.addData("config_type", ((PhpUnitSettings)config).getLoadMethod().name());
        }
        return new MetricEvent("configured.test.framework", data);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/statistics/PhpTestFrameworkCollectorHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUsages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/statistics/PhpTestFrameworkCollectorHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toReportedData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ApplicationUsageCollector
    extends ApplicationUsagesCollector {
        @NotNull
        public Set<MetricEvent> getMetrics() {
            Set<MetricEvent> set = ourCollector.collectUsages(null);
            if (set == null) {
                ApplicationUsageCollector.$$$reportNull$$$0(0);
            }
            return set;
        }

        @NotNull
        public String getGroupId() {
            return "php.test.framework";
        }

        public int getVersion() {
            return 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/testFramework/statistics/PhpTestFrameworkCollectorHelper$ApplicationUsageCollector", "getMetrics"));
        }
    }

    public static class ProjectUsageCollector
    extends ProjectUsagesCollector {
        @NotNull
        public Set<MetricEvent> getMetrics(@NotNull Project project) {
            if (project == null) {
                ProjectUsageCollector.$$$reportNull$$$0(0);
            }
            Set<MetricEvent> set = ourCollector.collectUsages(project);
            if (set == null) {
                ProjectUsageCollector.$$$reportNull$$$0(1);
            }
            return set;
        }

        @NotNull
        public String getGroupId() {
            return "php.test.framework";
        }

        public int getVersion() {
            return 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/testFramework/statistics/PhpTestFrameworkCollectorHelper$ProjectUsageCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/testFramework/statistics/PhpTestFrameworkCollectorHelper$ProjectUsageCollector";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetrics";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMetrics";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

