/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework.run;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpTestFrameworkVersionDetector;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTestFrameworkDefaultVersionDetector
extends PhpTestFrameworkVersionDetector<String> {
    private static final Logger LOG = Logger.getInstance(PhpTestFrameworkDefaultVersionDetector.class);
    private final String[] myOptions;
    @NlsSafe
    private final String myToolName;
    private final String myPrefix;

    public PhpTestFrameworkDefaultVersionDetector(@NonNls String @NotNull [] options, @NotNull @NlsSafe String toolName, @NotNull @NonNls String prefix) {
        if (options == null) {
            PhpTestFrameworkDefaultVersionDetector.$$$reportNull$$$0(0);
        }
        if (toolName == null) {
            PhpTestFrameworkDefaultVersionDetector.$$$reportNull$$$0(1);
        }
        if (prefix == null) {
            PhpTestFrameworkDefaultVersionDetector.$$$reportNull$$$0(2);
        }
        this.myOptions = options;
        this.myToolName = toolName;
        this.myPrefix = prefix;
    }

    @Override
    @Nls
    @NotNull
    protected String getPresentableName() {
        String string = this.myToolName;
        if (string == null) {
            PhpTestFrameworkDefaultVersionDetector.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected String @NotNull [] getVersionOptions() {
        if (this.myOptions == null) {
            PhpTestFrameworkDefaultVersionDetector.$$$reportNull$$$0(4);
        }
        return this.myOptions;
    }

    @Override
    @NotNull
    public String parse(@Nullable String output) throws ExecutionException {
        List split = StringUtil.split((String)StringUtil.notNullize((String)output).trim(), (String)" ");
        if (split.size() < 2) {
            String message = PhpBundle.message("php.test.framework.version.configuration.ui.can.not.parse.version", output);
            LOG.debug(message);
            throw new ExecutionException(message);
        }
        if (!StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)split.get(0)), (CharSequence)this.myPrefix)) {
            String message = PhpBundle.message("php.test.framework.version.configuration.ui.can.not.parse.version", output);
            LOG.debug(message);
            throw new ExecutionException(message);
        }
        String fullVersion = ((String)split.get(split.size() - 1)).trim();
        String shortVersion = ((String)StringUtil.split((String)fullVersion, (String)"-").get(0)).trim();
        if (shortVersion.isEmpty() || !StringUtil.isDecimalDigit((char)shortVersion.charAt(0))) {
            String message = PhpBundle.message("php.test.framework.version.configuration.ui.can.not.parse.version", output);
            LOG.debug(message);
            throw new ExecutionException(message);
        }
        String string = shortVersion;
        if (string == null) {
            PhpTestFrameworkDefaultVersionDetector.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/run/PhpTestFrameworkDefaultVersionDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/run/PhpTestFrameworkDefaultVersionDetector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionOptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

