/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpunit.PhpUnitDirectoriesManager;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.roots.PhpDirectoryByPsrProvider;
import com.jetbrains.php.testFramework.PhpTestCreateInfo;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpUnitAbstractTestCreateInfo
implements PhpTestCreateInfo {
    public static final String PHPUNIT_TEST_METHOD_TEMPLATE_NAME = "PHPUnit Test Method";
    public static final String PHPUNIT_SETUP_METHOD_TEMPLATE_NAME = "PHPUnit SetUp Method";
    public static final String PHPUNIT_TEARDOWN_METHOD_TEMPLATE_NAME = "PHPUnit TearDown Method";

    @Override
    @NotNull
    @NlsSafe
    public String getDefaultTestName(@NotNull String targetClassName) {
        if (targetClassName == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(0);
        }
        String string = targetClassName + "Test";
        if (string == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getTestNamespace(@NotNull Project project, @NotNull VirtualFile directory, @NotNull String namespace, @NotNull String fromNamespace, @NotNull String path) {
        if (project == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(2);
        }
        if (directory == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(3);
        }
        if (namespace == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(4);
        }
        if (fromNamespace == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(5);
        }
        if (path == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(6);
        }
        String string = PhpLangUtil.toName(PhpLangUtil.concat(namespace, PhpUnitAbstractTestCreateInfo.getNamespaceSuffix(project, directory, namespace, path)));
        if (string == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String getNamespaceSuffix(@NotNull Project project, @NotNull VirtualFile directory, @NotNull String namespace, @NotNull String path) {
        String namespaceWithoutPrefix;
        if (project == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(8);
        }
        if (directory == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(9);
        }
        if (namespace == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(10);
        }
        if (path == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(11);
        }
        SourceFolder sourceFolder = ProjectRootsUtil.getModuleSourceRoot((VirtualFile)directory, (Project)project);
        String relativePath = PhpUnitAbstractTestCreateInfo.getRelativePath(directory.getPath(), path);
        String namespaceSuffix = StringUtil.substringAfter((String)relativePath, (String)(namespaceWithoutPrefix = sourceFolder != null ? PhpDirectoryByPsrProvider.cutPrefix(namespace, sourceFolder.getPackagePrefix()) : namespace));
        if (namespaceSuffix == null) {
            return "";
        }
        String string = StringUtil.trimEnd((String)StringUtil.trimStart((String)namespaceSuffix, (String)"\\"), (String)"\\");
        if (string == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static String getRelativePath(@NotNull String rootPath, @NotNull String fullPath) {
        String relativePath;
        if (rootPath == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(13);
        }
        if (fullPath == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(14);
        }
        if ((relativePath = FileUtil.getRelativePath((String)rootPath, (String)fullPath, (char)'/')) == null) {
            return "";
        }
        relativePath = StringUtil.trimLeading((String)relativePath, (char)'.');
        relativePath = relativePath.replace('/', '\\');
        String string = StringUtil.trimEnd((String)StringUtil.trimStart((String)relativePath, (String)"\\"), (String)"\\");
        if (string == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    @Nullable
    public String getTestDirectory(@NotNull Project project, @NotNull SourceFolder sourceFolder, @NotNull String toNamespace, @NotNull String fromNamespace) {
        if (project == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(16);
        }
        if (sourceFolder == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(17);
        }
        if (toNamespace == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(18);
        }
        if (fromNamespace == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(19);
        }
        return PhpDirectoryByPsrProvider.suggestDirectory(PhpDirectoryByPsrProvider.getFolderPrefix(sourceFolder), sourceFolder.getFile(), toNamespace);
    }

    @Override
    public boolean isConfiguredFolder(@NotNull Project project, @Nullable VirtualFile directory) {
        if (project == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(20);
        }
        return directory != null && PhpUnitDirectoriesManager.getInstance(project).hasDirectory(directory.getPath());
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return PhpIcons.PHPUNIT;
    }

    @Override
    @NotNull
    public String getTestMethodText(@NotNull Project project, @NotNull String classFqn, @NotNull String methodName) {
        if (project == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(21);
        }
        if (classFqn == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(22);
        }
        if (methodName == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(23);
        }
        String string = PhpCodeUtil.getCodeTemplate(PHPUNIT_TEST_METHOD_TEMPLATE_NAME, this.getDefaultProperties(methodName, classFqn), project);
        if (string == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Override
    public boolean canCreateTestFor(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpUnitAbstractTestCreateInfo.$$$reportNull$$$0(25);
        }
        return !PhpUnitUtil.extendsRootTestClass(clazz);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 12: 
            case 15: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 12: 
            case 15: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClassName";
                break;
            }
            case 1: 
            case 7: 
            case 12: 
            case 15: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/PhpUnitAbstractTestCreateInfo";
                break;
            }
            case 2: 
            case 8: 
            case 16: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromNamespace";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullPath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFolder";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toNamespace";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpUnitAbstractTestCreateInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTestName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestNamespace";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceSuffix";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMethodText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTestName";
                break;
            }
            case 1: 
            case 7: 
            case 12: 
            case 15: 
            case 24: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTestNamespace";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceSuffix";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTestDirectory";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isConfiguredFolder";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTestMethodText";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "canCreateTestFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 12: 
            case 15: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

