/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Namer;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.testFramework.PhpInvalidTestFrameworkException;
import com.jetbrains.php.testFramework.PhpTestFrameworkComposerConfig;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfigurationFactory;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfigurationIml;
import com.jetbrains.php.testFramework.PhpTestFrameworkOldConfigHolder;
import com.jetbrains.php.testFramework.PhpTestFrameworkSettingsManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import com.jetbrains.php.testFramework.PhpTestFrameworkVersionCache;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkConfigurableForm;
import com.jetbrains.php.ui.PhpNamedCloneableItemsListEditor;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTestFrameworksConfigurable
extends PhpNamedCloneableItemsListEditor<PhpTestFrameworkConfiguration>
implements SearchableConfigurable,
Configurable.WithEpDependencies {
    private static final String DEFAULT_HELP_TOPIC = "reference.settings.php.test.frameworks";
    public static final String ID = "php.test.frameworks.configurable";
    private static final ArrayList<AnAction> NO_ACTIONS = new ArrayList();
    private final Comparator<MasterDetailsComponent.MyNode> COMPARATOR;
    @NotNull
    protected final Project myProject;
    @Nullable
    private final PhpTestFrameworkConfiguration myInitialItem;

    public PhpTestFrameworksConfigurable(@NotNull Project project) {
        if (project == null) {
            PhpTestFrameworksConfigurable.$$$reportNull$$$0(0);
        }
        this(project, null);
    }

    public PhpTestFrameworksConfigurable(final @NotNull Project project, @Nullable PhpTestFrameworkConfiguration initialItem) {
        if (project == null) {
            PhpTestFrameworksConfigurable.$$$reportNull$$$0(1);
        }
        super(new Namer<PhpTestFrameworkConfiguration>(){

            public String getName(PhpTestFrameworkConfiguration item) {
                return item.getPresentableName(project);
            }

            public boolean canRename(PhpTestFrameworkConfiguration item) {
                return false;
            }

            public void setName(PhpTestFrameworkConfiguration item, String newName) {
            }
        }, () -> new PhpTestFrameworkConfigurationIml(), configuration -> configuration.copy(), () -> ContainerUtil.filter(PhpTestFrameworkSettingsManager.getInstance(project).getAllConfigurations(), PhpTestFrameworkConfiguration::isAvailable), items -> PhpTestFrameworkSettingsManager.getInstance(project).setAllConfigurations(items), item -> {
            List<PhpTestFrameworkConfigurationFactory> types = PhpTestFrameworksConfigurable.getFactories();
            assert (!types.isEmpty());
            UnnamedConfigurable form = types.stream().filter(factory -> factory.accepts((PhpTestFrameworkConfiguration)item)).map(factory -> factory.createForm(project, (PhpTestFrameworkConfiguration)item)).filter(Objects::nonNull).findFirst().orElse(null);
            if (form == null) {
                throw new PhpInvalidTestFrameworkException("Cannot create form for framework '" + item.getFrameworkType() + "', '" + item.getClass() + "'");
            }
            return form;
        }, new PhpNamedCloneableItemsListEditor.DefaultItemModelHandler(), null, false);
        this.COMPARATOR = new Comparator<MasterDetailsComponent.MyNode>(){

            @Override
            public int compare(MasterDetailsComponent.MyNode n1, MasterDetailsComponent.MyNode n2) {
                Object o1 = n1.getConfigurable().getEditableObject();
                Object o2 = n2.getConfigurable().getEditableObject();
                if (o1 instanceof PhpTestFrameworkConfiguration && o2 instanceof PhpTestFrameworkConfiguration) {
                    return PhpTestFrameworkConfiguration.compareTo(PhpTestFrameworksConfigurable.this.myProject, (PhpTestFrameworkConfiguration)o1, (PhpTestFrameworkConfiguration)o2);
                }
                return StringUtil.naturalCompare((String)n1.getDisplayName(), (String)n2.getDisplayName());
            }
        };
        this.myProject = project;
        this.setSubjectDisplayName(PhpBundle.message("configurable.PhpTestFrameworksConfigurable.display.name", new Object[0]));
        this.setShowIcons(true);
        this.initTree();
        this.myToReInitWholePanel = true;
        this.reInitWholePanelIfNeeded();
        this.myInitialItem = initialItem;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        List<PhpTestFrameworkConfigurationFactory> types = PhpTestFrameworksConfigurable.getFactories();
        if (types.isEmpty()) {
            ArrayList<AnAction> arrayList = NO_ACTIONS;
            if (arrayList == null) {
                PhpTestFrameworksConfigurable.$$$reportNull$$$0(2);
            }
            return arrayList;
        }
        List list = super.createActions(fromPopup);
        if (list == null) {
            PhpTestFrameworksConfigurable.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    protected boolean isCopyAvailable() {
        return false;
    }

    @Override
    @NotNull
    protected String suggestName(PhpTestFrameworkConfiguration item) {
        String string = item.getPresentableName(this.myProject);
        if (string == null) {
            PhpTestFrameworksConfigurable.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    protected AnAction createAddAction() {
        return new PhpNamedCloneableItemsListEditor.AddAction(){

            @Override
            public void actionPerformed(@NotNull AnActionEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                List items = PhpTestFrameworksConfigurable.this.getItems();
                List factories = ContainerUtil.filter(PhpTestFrameworksConfigurable.getFactories(), factory -> !factory.isSingleInstance() || !PhpTestFrameworksConfigurable.hasConfig(factory, items));
                if (factories.isEmpty()) {
                    InputEvent inputEvent = event.getInputEvent();
                    RelativePoint point = inputEvent instanceof MouseEvent ? new RelativePoint((MouseEvent)inputEvent) : JBPopupFactory.getInstance().guessBestPopupLocation(event.getDataContext());
                    String message = PhpBundle.message("php.test.framework.no.configuration.types.are.available", new Object[0]);
                    JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.INFO, null).setFadeoutTime(1000L).createBalloon().show(point, Balloon.Position.below);
                } else if (factories.size() == 1) {
                    this.addConfiguration((PhpTestFrameworkConfigurationFactory)factories.iterator().next());
                } else {
                    ArrayList sorted = new ArrayList(factories);
                    ContainerUtil.sort(sorted);
                    final HashSet<String> isSeparatorsAbove = new HashSet<String>();
                    for (int i = 1; i < sorted.size(); ++i) {
                        PhpTestFrameworkConfigurationFactory factory2 = (PhpTestFrameworkConfigurationFactory)sorted.get(i);
                        if (factory2.getTestFrameworkType() == ((PhpTestFrameworkConfigurationFactory)sorted.get(i - 1)).getTestFrameworkType()) continue;
                        isSeparatorsAbove.add(factory2.getPresentableName());
                    }
                    BaseListPopupStep<PhpTestFrameworkConfigurationFactory> popupStep = new BaseListPopupStep<PhpTestFrameworkConfigurationFactory>(PhpBundle.message("php.test.framework.select.type.of.settings.popup.title", new Object[0]), factories){

                        public ListSeparator getSeparatorAbove(PhpTestFrameworkConfigurationFactory value) {
                            if (isSeparatorsAbove.contains(value.getPresentableName())) {
                                return new ListSeparator();
                            }
                            return null;
                        }

                        @NotNull
                        public String getTextFor(PhpTestFrameworkConfigurationFactory value) {
                            String string = value.getPresentableName();
                            if (string == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return string;
                        }

                        public PopupStep onChosen(PhpTestFrameworkConfigurationFactory selectedValue, boolean finalChoice) {
                            return this.doFinalStep(() -> this.addConfiguration(selectedValue));
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/testFramework/PhpTestFrameworksConfigurable$3$1", "getTextFor"));
                        }
                    };
                    ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)popupStep);
                    InputEvent inputEvent = event.getInputEvent();
                    if (inputEvent instanceof MouseEvent) {
                        Point locationOnScreen = ((MouseEvent)inputEvent).getLocationOnScreen();
                        popup.showInScreenCoordinates((Component)PhpTestFrameworksConfigurable.this.myWholePanel, locationOnScreen);
                    } else {
                        popup.showInBestPositionFor(event.getDataContext());
                    }
                }
            }

            private void addConfiguration(@NotNull PhpTestFrameworkConfigurationFactory factory) {
                List items;
                Object configuration;
                if (factory == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((configuration = factory.createNewInstance(PhpTestFrameworksConfigurable.this.myProject, items = ContainerUtil.filter(PhpTestFrameworksConfigurable.this.getItems(), config -> config.getFrameworkType() == factory.getTestFrameworkType()))) != null) {
                    PhpTestFrameworksConfigurable.this.onItemCreated(configuration);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factory";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworksConfigurable$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addConfiguration";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    public void reset() {
        super.reset();
        if (this.myInitialItem != null) {
            this.getItems().stream().filter(item -> item.equals(this.myInitialItem)).findFirst().ifPresent(arg_0 -> ((PhpTestFrameworksConfigurable)this).selectNodeInTree(arg_0));
        }
    }

    @Override
    protected void onApply() {
        Set<PhpTestFrameworkType> types = this.collectEnabledFrameworks();
        for (PhpTestFrameworkType frameworkType : types) {
            PhpTestFrameworkVersionCache.clearCache(this.myProject, frameworkType);
        }
        for (UnnamedConfigurable configurable : this.getItemConfigurables()) {
            PhpTestFrameworkConfigurableForm form;
            String version;
            if (!(configurable instanceof PhpTestFrameworkConfigurableForm) || !StringUtil.isNotEmpty((String)(version = (form = (PhpTestFrameworkConfigurableForm)configurable).getLastDetectedVersion()))) continue;
            PhpTestFrameworkVersionCache.setCache(this.myProject, form.getConfiguration(), version);
        }
        for (PhpTestFrameworkType type : PhpTestFrameworkType.EP_NAME.getExtensionList()) {
            type.onEnable(this.myProject, types.contains(type));
        }
    }

    @NotNull
    private Set<PhpTestFrameworkType> collectEnabledFrameworks() {
        Set<PhpTestFrameworkType> set = this.getItems().stream().map(config -> config.getFrameworkType()).collect(Collectors.toSet());
        if (set == null) {
            PhpTestFrameworksConfigurable.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public Collection<BaseExtensionPointName<?>> getDependencies() {
        List<BaseExtensionPointName<?>> list = Arrays.asList(PhpTestFrameworkType.EP_NAME, PhpTestFrameworkOldConfigHolder.EP_NAME);
        if (list == null) {
            PhpTestFrameworksConfigurable.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static List<PhpTestFrameworkConfigurationFactory> getFactories() {
        PhpTestFrameworkType[] frameworkTypes = PhpTestFrameworkType.getTestFrameworkTypes();
        if (frameworkTypes.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                PhpTestFrameworksConfigurable.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList<PhpTestFrameworkConfigurationFactory> result = new ArrayList<PhpTestFrameworkConfigurationFactory>();
        for (PhpTestFrameworkType frameworkType : frameworkTypes) {
            result.addAll(frameworkType.getFactories());
        }
        ArrayList<PhpTestFrameworkConfigurationFactory> arrayList = result;
        if (arrayList == null) {
            PhpTestFrameworksConfigurable.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static boolean hasConfig(@NotNull PhpTestFrameworkConfigurationFactory factory, @NotNull List<PhpTestFrameworkConfiguration> items) {
        if (factory == null) {
            PhpTestFrameworksConfigurable.$$$reportNull$$$0(9);
        }
        if (items == null) {
            PhpTestFrameworksConfigurable.$$$reportNull$$$0(10);
        }
        return !items.isEmpty() && items.stream().anyMatch(config -> factory.accepts((PhpTestFrameworkConfiguration)config));
    }

    protected Comparator<MasterDetailsComponent.MyNode> getNodeComparator() {
        return this.COMPARATOR;
    }

    @Nls
    public String getDisplayName() {
        return PhpBundle.message("configurable.PhpTestFrameworksConfigurable.display.name", new Object[0]);
    }

    public String getHelpTopic() {
        String topic = super.getHelpTopic();
        if (StringUtil.isNotEmpty((String)topic)) {
            return topic;
        }
        return DEFAULT_HELP_TOPIC;
    }

    @NotNull
    public static Runnable createFix(@NotNull Project project, @NotNull PhpTestFrameworkType frameworkType, @Nullable PhpInterpreter interpreter) {
        if (project == null) {
            PhpTestFrameworksConfigurable.$$$reportNull$$$0(11);
        }
        if (frameworkType == null) {
            PhpTestFrameworksConfigurable.$$$reportNull$$$0(12);
        }
        Runnable runnable = () -> {
            PhpTestFrameworkComposerConfig composerConfig;
            PhpTestFrameworkConfiguration config = PhpTestFrameworkSettingsManager.getInstance(project).getConfigByInterpreter(frameworkType, interpreter);
            if (PhpTestFrameworkSettingsManager.getInstance(project).getLocalConfig(frameworkType) == null && (composerConfig = PhpTestFrameworkComposerConfig.getTestFrameworkComposerConfig(frameworkType)) != null) {
                PhpUiUtil.editConfigurable(project, (Configurable)new PhpTestFrameworksConfigurable(project, composerConfig.updateSettings(project, null, false)));
                return;
            }
            PhpUiUtil.editConfigurable(project, (Configurable)new PhpTestFrameworksConfigurable(project, config));
        };
        if (runnable == null) {
            PhpTestFrameworksConfigurable.$$$reportNull$$$0(13);
        }
        return runnable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworksConfigurable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworksConfigurable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectEnabledFrameworks";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactories";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasConfig";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

