/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpTestFrameworkVersionCache
implements PersistentStateComponent<CacheState> {
    private CacheState myState = new CacheState();

    @Nullable
    public static Version getCachedVersion(@Nullable Project project, @NotNull PhpTestFrameworkConfiguration key) {
        String cache;
        if (key == null) {
            PhpTestFrameworkVersionCache.$$$reportNull$$$0(0);
        }
        return StringUtil.isNotEmpty((String)(cache = PhpTestFrameworkVersionCache.getCache(project, key))) ? Version.parseVersion((String)cache) : null;
    }

    public static String getCache(@Nullable Project project, @NotNull PhpTestFrameworkConfiguration key) {
        PhpTestFrameworkVersionCache instance;
        if (key == null) {
            PhpTestFrameworkVersionCache.$$$reportNull$$$0(1);
        }
        if ((instance = PhpTestFrameworkVersionCache.getInstance(project, key)) != null) {
            PhpTestFrameworkType frameworkType = key.getFrameworkType();
            assert (frameworkType != null);
            return instance.getCachedVersion(frameworkType, key.getId());
        }
        return null;
    }

    public static void setCache(@Nullable Project project, @NotNull PhpTestFrameworkConfiguration key, @Nullable String version) {
        PhpTestFrameworkVersionCache instance;
        if (key == null) {
            PhpTestFrameworkVersionCache.$$$reportNull$$$0(2);
        }
        if ((instance = PhpTestFrameworkVersionCache.getInstance(project, key)) != null) {
            PhpTestFrameworkType frameworkType = key.getFrameworkType();
            assert (frameworkType != null);
            instance.setCachedVersion(frameworkType, key.getId(), version);
        }
    }

    public static void clearCache(@Nullable Project project, @NotNull PhpTestFrameworkType frameworkType) {
        if (frameworkType == null) {
            PhpTestFrameworkVersionCache.$$$reportNull$$$0(3);
        }
        ((PhpFrameworkVersionApplicationCache)ApplicationManager.getApplication().getService(PhpFrameworkVersionApplicationCache.class)).clear(frameworkType);
        if (project != null) {
            ((PhpFrameworkVersionProjectCache)ServiceManager.getService((Project)project, PhpFrameworkVersionProjectCache.class)).clear(frameworkType);
        }
    }

    private static PhpTestFrameworkVersionCache getInstance(@Nullable Project project, @NotNull PhpTestFrameworkConfiguration key) {
        if (key == null) {
            PhpTestFrameworkVersionCache.$$$reportNull$$$0(4);
        }
        if (project == null || !key.isProjectLevel()) {
            return (PhpTestFrameworkVersionCache)ApplicationManager.getApplication().getService(PhpFrameworkVersionApplicationCache.class);
        }
        return (PhpTestFrameworkVersionCache)ServiceManager.getService((Project)project, PhpFrameworkVersionProjectCache.class);
    }

    public CacheState getState() {
        return this.myState;
    }

    public void loadState(@NotNull CacheState state) {
        if (state == null) {
            PhpTestFrameworkVersionCache.$$$reportNull$$$0(5);
        }
        this.myState = state;
    }

    public void setCachedVersion(@NotNull PhpTestFrameworkType frameworkType, @NotNull String id, @Nullable String version) {
        if (frameworkType == null) {
            PhpTestFrameworkVersionCache.$$$reportNull$$$0(6);
        }
        if (id == null) {
            PhpTestFrameworkVersionCache.$$$reportNull$$$0(7);
        }
        if (version == null) {
            this.myState.removeVersion(frameworkType.getID(), id);
        } else {
            this.myState.setVersion(frameworkType.getID(), id, version);
        }
    }

    @Nullable
    public String getCachedVersion(@NotNull PhpTestFrameworkType frameworkType, @Nullable String id) {
        if (frameworkType == null) {
            PhpTestFrameworkVersionCache.$$$reportNull$$$0(8);
        }
        return id != null ? this.myState.getVersion(frameworkType.getID(), id) : null;
    }

    public void clear(@NotNull PhpTestFrameworkType frameworkType) {
        if (frameworkType == null) {
            PhpTestFrameworkVersionCache.$$$reportNull$$$0(9);
        }
        String id = frameworkType.getID();
        this.myState.getVersionCache().remove(id);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkVersionCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCachedVersion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setCache";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "clearCache";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setCachedVersion";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "clear";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Tag(value="cache")
    private static class PhpTestFrameworkVersions {
        private Map<String, String> myVersionCache = new HashMap<String, String>();

        private PhpTestFrameworkVersions() {
        }

        @Tag(value="versions")
        @MapAnnotation(entryTagName="info", keyAttributeName="id", valueAttributeName="version", surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false)
        public Map<String, String> getVersionCache() {
            return this.myVersionCache;
        }

        public void setVersionCache(Map<String, String> versionCache) {
            this.myVersionCache = versionCache;
        }

        public void setCachedVersion(@NotNull String id, @Nullable String version) {
            if (id == null) {
                PhpTestFrameworkVersions.$$$reportNull$$$0(0);
            }
            if (version == null) {
                this.myVersionCache.remove(id);
            } else {
                this.myVersionCache.put(id, version);
            }
        }

        @Nullable
        public String getCachedVersion(@Nullable String id) {
            return id == null ? null : this.myVersionCache.get(id);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/php/testFramework/PhpTestFrameworkVersionCache$PhpTestFrameworkVersions", "setCachedVersion"));
        }
    }

    @State(name="PhpTestFrameworkVersionCache", storages={@Storage(value="php-test-framework.xml")})
    private static class PhpFrameworkVersionProjectCache
    extends PhpTestFrameworkVersionCache {
        private PhpFrameworkVersionProjectCache() {
        }
    }

    @State(name="PhpTestFrameworkVersionCache", storages={@Storage(value="php-test-framework.xml")})
    private static class PhpFrameworkVersionApplicationCache
    extends PhpTestFrameworkVersionCache {
        private PhpFrameworkVersionApplicationCache() {
        }
    }

    public static class CacheState {
        private Map<String, PhpTestFrameworkVersions> myVersionCache = new HashMap<String, PhpTestFrameworkVersions>();

        @Tag(value="tools_cache")
        @MapAnnotation(entryTagName="tool", keyAttributeName="tool_name", surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false)
        @NotNull
        public Map<String, PhpTestFrameworkVersions> getVersionCache() {
            Map<String, PhpTestFrameworkVersions> map = this.myVersionCache;
            if (map == null) {
                CacheState.$$$reportNull$$$0(0);
            }
            return map;
        }

        public void setVersionCache(@NotNull Map<String, PhpTestFrameworkVersions> versionCache) {
            if (versionCache == null) {
                CacheState.$$$reportNull$$$0(1);
            }
            this.myVersionCache = versionCache;
        }

        @Nullable
        public String getVersion(@NotNull String frameworkId, @NotNull String id) {
            if (frameworkId == null) {
                CacheState.$$$reportNull$$$0(2);
            }
            if (id == null) {
                CacheState.$$$reportNull$$$0(3);
            }
            if (this.myVersionCache.containsKey(frameworkId)) {
                return this.myVersionCache.get(frameworkId).getCachedVersion(id);
            }
            return null;
        }

        public void setVersion(@NotNull String frameworkId, @NotNull String id, @NotNull String version) {
            if (frameworkId == null) {
                CacheState.$$$reportNull$$$0(4);
            }
            if (id == null) {
                CacheState.$$$reportNull$$$0(5);
            }
            if (version == null) {
                CacheState.$$$reportNull$$$0(6);
            }
            if (!this.myVersionCache.containsKey(frameworkId)) {
                this.myVersionCache.put(frameworkId, new PhpTestFrameworkVersions());
            }
            this.myVersionCache.get(frameworkId).setCachedVersion(id, version);
        }

        public void removeVersion(@NotNull String frameworkId, @NotNull String id) {
            if (frameworkId == null) {
                CacheState.$$$reportNull$$$0(7);
            }
            if (id == null) {
                CacheState.$$$reportNull$$$0(8);
            }
            if (this.myVersionCache.containsKey(frameworkId)) {
                PhpTestFrameworkVersions versions = this.myVersionCache.get(frameworkId);
                versions.setCachedVersion(id, null);
                if (versions.getVersionCache().isEmpty()) {
                    this.myVersionCache.remove(frameworkId);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkVersionCache$CacheState";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versionCache";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frameworkId";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVersionCache";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkVersionCache$CacheState";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setVersionCache";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getVersion";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setVersion";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "removeVersion";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

