/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.phpunit.PhpUnitFrameworkType;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.PhpUnitSettingsManager;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkBaseSettingsManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfigurationFactory;
import com.jetbrains.php.testFramework.PhpTestFrameworkOldConfigHolder;
import com.jetbrains.php.testFramework.PhpTestFrameworkStateListener;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTestFrameworkSettingsManager
implements Disposable {
    private final PhpTestFrameworkProjectSettingsManager myProjectManager;
    private final PhpTestFrameworkApplicationSettingsManager myApplicationManager;
    @Nullable
    private Project myProject;

    public static PhpTestFrameworkSettingsManager getInstance(@Nullable Project project) {
        Project targetProject = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
        return (PhpTestFrameworkSettingsManager)ServiceManager.getService((Project)targetProject, PhpTestFrameworkSettingsManager.class);
    }

    public PhpTestFrameworkSettingsManager(final @Nullable Project project) {
        this.myProject = project;
        this.myApplicationManager = (PhpTestFrameworkApplicationSettingsManager)ApplicationManager.getApplication().getService(PhpTestFrameworkApplicationSettingsManager.class);
        if (project != null && !project.isDefault()) {
            this.myProjectManager = (PhpTestFrameworkProjectSettingsManager)ServiceManager.getService((Project)project, PhpTestFrameworkProjectSettingsManager.class);
            PhpTestFrameworkStateListener listener = new PhpTestFrameworkStateListener(){

                @Override
                public void onSettingsUpdate() {
                    PhpTestFrameworkSettingsManager.this.resolvePossibleCollisions(project);
                }
            };
            this.myProjectManager.addListener(this, listener);
            this.myApplicationManager.addListener(this, listener);
            this.resolvePossibleCollisions(project);
        } else {
            this.myProjectManager = null;
        }
    }

    private void resolvePossibleCollisions(@NotNull Project project) {
        if (project == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(0);
        }
        if (this.myProjectManager == null) {
            return;
        }
        Set<PhpTestFrameworkType> frameworks = this.getFrameworks();
        for (PhpTestFrameworkType frameworkType : frameworks) {
            this.resolvePossibleCollisions(project, frameworkType);
        }
    }

    public void onInterpretersUpdate() {
        if (this.myProjectManager == null) {
            return;
        }
        this.resolvePossibleCollisions(this.myProjectManager.myProject);
    }

    @NotNull
    public Set<PhpTestFrameworkType> getFrameworks() {
        if (this.myProjectManager == null) {
            Set<PhpTestFrameworkType> set = this.myApplicationManager.getFrameworks();
            if (set == null) {
                PhpTestFrameworkSettingsManager.$$$reportNull$$$0(1);
            }
            return set;
        }
        Set set = ContainerUtil.union(this.myProjectManager.getFrameworks(), this.myApplicationManager.getFrameworks());
        if (set == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(2);
        }
        return set;
    }

    private void resolvePossibleCollisions(@NotNull Project project, @NotNull PhpTestFrameworkType frameworkType) {
        if (project == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(3);
        }
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(4);
        }
        if (this.myProjectManager == null) {
            return;
        }
        boolean hasApplicationLevel = this.myProjectManager.getConfigurations(frameworkType).stream().anyMatch(configuration -> !configuration.isProjectLevel());
        if (!hasApplicationLevel) {
            boolean hasProjectLevel = this.myApplicationManager.getConfigurations(frameworkType).stream().anyMatch(PhpTestFrameworkConfiguration::isProjectLevel);
            if (hasProjectLevel) {
                this.setConfigurations(frameworkType, this.getConfigurations(frameworkType));
            }
            return;
        }
        SmartList newConfigurations = new SmartList();
        ArrayList<PhpTestFrameworkConfiguration> projectLevel = new ArrayList<PhpTestFrameworkConfiguration>();
        ArrayList<PhpTestFrameworkConfiguration> applicationLevel = new ArrayList<PhpTestFrameworkConfiguration>();
        for (PhpTestFrameworkConfiguration configuration2 : this.myApplicationManager.getConfigurations(frameworkType)) {
            if (configuration2.isProjectLevel()) {
                projectLevel.add(configuration2);
                continue;
            }
            applicationLevel.add(configuration2);
        }
        for (PhpTestFrameworkConfiguration config : this.myProjectManager.getConfigurations(frameworkType)) {
            if (!config.isProjectLevel()) {
                PhpTestFrameworkConfiguration existing = this.myApplicationManager.getConfigById(frameworkType, config.getId());
                if (existing != null) {
                    PhpTestFrameworkConfiguration copy;
                    if (existing.equals(config) || (copy = config.copyWithSettingsSource(project)) == null) continue;
                    newConfigurations.add(existing.getPresentableName(project));
                    projectLevel.add(copy);
                    continue;
                }
                applicationLevel.add(config);
                continue;
            }
            projectLevel.add(config);
        }
        this.myApplicationManager.setConfigurations(frameworkType, applicationLevel);
        this.myProjectManager.setConfigurations(frameworkType, projectLevel);
        if (!newConfigurations.isEmpty()) {
            PhpTestFrameworkSettingsManager.showWarning(project, frameworkType, (List<String>)newConfigurations);
        }
    }

    private static void showWarning(@NotNull Project project, @NotNull PhpTestFrameworkType frameworkType, @NotNull List<@NlsSafe String> newSettings) {
        if (project == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(5);
        }
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(6);
        }
        if (newSettings == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(7);
        }
        String toolName = frameworkType.getDisplayName();
        HtmlBuilder builder = new HtmlBuilder().append(PhpBundle.message("php.test.framework.interpreter.conflict", toolName));
        for (String name : newSettings) {
            builder.append((HtmlChunk)HtmlChunk.br()).append((HtmlChunk)HtmlChunk.text((String)("'" + name + "'")).bold());
        }
        String title = PhpBundle.message("php.test.framework.interpreter.conflict.title", toolName);
        PhpUnitUtil.showWarningBalloon(project, title, builder.toString(), null);
    }

    public List<PhpTestFrameworkConfiguration> getConfigurations(@NotNull PhpTestFrameworkType frameworkType) {
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(8);
        }
        ArrayList<PhpTestFrameworkConfiguration> result = new ArrayList<PhpTestFrameworkConfiguration>();
        if (this.myProjectManager != null) {
            result.addAll(this.myProjectManager.getConfigurations(frameworkType));
        }
        result.addAll(this.myApplicationManager.getConfigurations(frameworkType));
        return result;
    }

    public void setConfigurations(@NotNull PhpTestFrameworkType frameworkType, @NotNull List<PhpTestFrameworkConfiguration> configurations) {
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(9);
        }
        if (configurations == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(10);
        }
        if (this.myProjectManager == null) {
            this.myApplicationManager.setConfigurations(frameworkType, configurations);
            return;
        }
        ArrayList<PhpTestFrameworkConfiguration> applicationLevel = new ArrayList<PhpTestFrameworkConfiguration>();
        ArrayList<PhpTestFrameworkConfiguration> projectLevel = new ArrayList<PhpTestFrameworkConfiguration>();
        for (PhpTestFrameworkConfiguration config : configurations) {
            if (config.isProjectLevel()) {
                projectLevel.add(config);
                continue;
            }
            applicationLevel.add(config);
        }
        this.myApplicationManager.setConfigurations(frameworkType, applicationLevel);
        this.myProjectManager.setConfigurations(frameworkType, projectLevel);
    }

    @NotNull
    public List<PhpTestFrameworkConfiguration> getAllConfigurations() {
        ArrayList<PhpTestFrameworkConfiguration> result = new ArrayList<PhpTestFrameworkConfiguration>();
        for (PhpTestFrameworkType frameworkType : this.getFrameworks()) {
            result.addAll(this.getConfigurations(frameworkType));
        }
        Project project = this.myProjectManager != null ? this.myProjectManager.myProject : null;
        result.addAll(PhpUnitSettingsManager.getInstance(project).getAllSettings());
        ArrayList<PhpTestFrameworkConfiguration> arrayList = result;
        if (arrayList == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public void setAllConfigurations(@NotNull List<PhpTestFrameworkConfiguration> configurations) {
        if (configurations == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(12);
        }
        HashMap<PhpTestFrameworkType, SmartList> configurationByKey = new HashMap<PhpTestFrameworkType, SmartList>();
        for (PhpTestFrameworkType phpTestFrameworkType : this.getFrameworks()) {
            configurationByKey.put(phpTestFrameworkType, new SmartList());
        }
        ArrayList<PhpUnitSettings> phpUnitConfig = new ArrayList<PhpUnitSettings>();
        for (PhpTestFrameworkConfiguration config : configurations) {
            if (config instanceof PhpUnitSettings) {
                phpUnitConfig.add((PhpUnitSettings)config);
                continue;
            }
            PhpTestFrameworkType type = config.getFrameworkType();
            if (!configurationByKey.containsKey(type)) {
                configurationByKey.put(type, new SmartList());
            }
            ((List)configurationByKey.get(type)).add(config);
        }
        Project project = this.myProjectManager != null ? this.myProjectManager.myProject : null;
        PhpUnitSettingsManager.getInstance(project).setSettings(phpUnitConfig);
        for (Map.Entry entry : configurationByKey.entrySet()) {
            this.setConfigurations((PhpTestFrameworkType)entry.getKey(), (List)entry.getValue());
        }
    }

    @Nullable
    public PhpTestFrameworkConfiguration getLocalConfig(@NotNull PhpTestFrameworkType frameworkType) {
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(13);
        }
        if (this.myProjectManager != null) {
            return this.myProjectManager.getLocalConfig(frameworkType);
        }
        return null;
    }

    public void setLocalConfig(@NotNull PhpTestFrameworkType frameworkType, @Nullable PhpTestFrameworkConfiguration localConfig) {
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(14);
        }
        List configs = ContainerUtil.filter(this.getConfigurations(frameworkType), config -> !config.isLocal());
        if (localConfig != null) {
            configs = ContainerUtil.append((List)configs, (Object[])new PhpTestFrameworkConfiguration[]{localConfig});
        }
        this.setConfigurations(frameworkType, configs);
    }

    @Nullable
    public PhpTestFrameworkConfiguration getOrCreateByInterpreter(@NotNull PhpTestFrameworkType frameworkType, @Nullable PhpInterpreter interpreter) {
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(15);
        }
        return this.getOrCreateByInterpreter(frameworkType, interpreter, false);
    }

    @Nullable
    public PhpTestFrameworkConfiguration getOrCreateByInterpreter(@NotNull PhpTestFrameworkType frameworkType, @Nullable PhpInterpreter interpreter, boolean onTheFly) {
        PhpTestFrameworkConfiguration config;
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(16);
        }
        if ((config = this.getConfigByInterpreter(frameworkType, interpreter)) != null) {
            return config;
        }
        if (onTheFly && this.getLocalConfig(frameworkType) == null) {
            return null;
        }
        List<PhpTestFrameworkConfigurationFactory> factories = frameworkType.getFactories();
        for (PhpTestFrameworkConfigurationFactory factory : factories) {
            Object newConfig = factory.createByInterpreter(interpreter);
            if (newConfig == null) continue;
            if (!onTheFly) {
                List<PhpTestFrameworkConfiguration> configurations = this.getConfigurations(frameworkType);
                configurations.add((PhpTestFrameworkConfiguration)newConfig);
                this.setConfigurations(frameworkType, configurations);
            } else {
                PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
                if (manager != null && interpreter != null) {
                    PathMappingSettings mappings = manager.createPathMappings(this.myProject, interpreter.getPhpSdkAdditionalData());
                    PhpTestFrameworkConfiguration localConfig = this.getLocalConfig(frameworkType);
                    if (localConfig != null) {
                        NullableFunction function = s -> s == null ? null : mappings.convertToRemote((String)s);
                        factory.fillSettingsByDefaultValue(localConfig, newConfig, (NullableFunction<String, String>)function);
                    }
                }
            }
            return newConfig;
        }
        assert (false);
        return null;
    }

    @Nullable
    public PhpTestFrameworkConfiguration getConfigByInterpreter(@NotNull PhpTestFrameworkType frameworkType, @Nullable PhpInterpreter interpreter) {
        if (frameworkType == null) {
            PhpTestFrameworkSettingsManager.$$$reportNull$$$0(17);
        }
        if (frameworkType == PhpUnitFrameworkType.getInstance()) {
            Project project = this.myProjectManager != null ? this.myProjectManager.myProject : null;
            return PhpUnitSettingsManager.getInstance(project).getSettingsByInterpreter(interpreter);
        }
        if (interpreter == null || !interpreter.isRemote()) {
            return this.getLocalConfig(frameworkType);
        }
        String id = "interpreter-" + interpreter.getId();
        PhpTestFrameworkConfiguration config = this.myApplicationManager.getConfigById(frameworkType, id);
        if (config == null && this.myProjectManager != null) {
            config = this.myProjectManager.getConfigById(frameworkType, id);
        }
        return config;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkSettingsManager";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSettings";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkSettingsManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworks";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolvePossibleCollisions";
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showWarning";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurations";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setAllConfigurations";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLocalConfig";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setLocalConfig";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateByInterpreter";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getConfigByInterpreter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @State(name="PhpTestFrameworkSettings", storages={@Storage(value="php-test-framework.xml")})
    private static class PhpTestFrameworkProjectSettingsManager
    extends PhpTestFrameworkBaseSettingsManager {
        public static PhpTestFrameworkProjectSettingsManager getInstance(@NotNull Project project) {
            if (project == null) {
                PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(0);
            }
            return (PhpTestFrameworkProjectSettingsManager)ServiceManager.getService((Project)project, PhpTestFrameworkProjectSettingsManager.class);
        }

        PhpTestFrameworkProjectSettingsManager(@NotNull Project project) {
            if (project == null) {
                PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(1);
            }
            super(project);
        }

        @Override
        @NotNull
        public Set<PhpTestFrameworkType> getFrameworks() {
            HashSet<PhpTestFrameworkType> frameworks = new HashSet<PhpTestFrameworkType>(super.getFrameworks());
            for (PhpTestFrameworkOldConfigHolder holder : PhpTestFrameworkOldConfigHolder.getInstances()) {
                frameworks.add(holder.getFrameworkType());
            }
            HashSet<PhpTestFrameworkType> hashSet = frameworks;
            if (hashSet == null) {
                PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(2);
            }
            return hashSet;
        }

        @Nullable
        public PhpTestFrameworkConfiguration getLocalConfig(@NotNull PhpTestFrameworkType frameworkType) {
            if (frameworkType == null) {
                PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(3);
            }
            for (PhpTestFrameworkConfiguration configuration : this.getConfigurations(frameworkType)) {
                if (!configuration.isLocal()) continue;
                return configuration;
            }
            return null;
        }

        @Override
        @NotNull
        public List<PhpTestFrameworkConfiguration> getConfigurations(@NotNull PhpTestFrameworkType frameworkType) {
            List<PhpTestFrameworkConfiguration> configurations;
            if (frameworkType == null) {
                PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(4);
            }
            if (!(configurations = this.myState.getConfigurationsByKey(frameworkType.getID())).isEmpty()) {
                configurations.forEach(i -> i.setFrameworkType(frameworkType));
                List<PhpTestFrameworkConfiguration> list = configurations;
                if (list == null) {
                    PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(5);
                }
                return list;
            }
            for (PhpTestFrameworkOldConfigHolder holder : PhpTestFrameworkOldConfigHolder.getInstances()) {
                if (!holder.getFrameworkType().equals(frameworkType)) continue;
                List<PhpTestFrameworkConfiguration> list = holder.getConfigurations(this.myProject);
                if (list == null) {
                    PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(6);
                }
                return list;
            }
            return new SmartList();
        }

        @Override
        public void setConfigurations(@NotNull PhpTestFrameworkType frameworkType, @NotNull List<PhpTestFrameworkConfiguration> configurations) {
            if (frameworkType == null) {
                PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(7);
            }
            if (configurations == null) {
                PhpTestFrameworkProjectSettingsManager.$$$reportNull$$$0(8);
            }
            for (PhpTestFrameworkOldConfigHolder holder : PhpTestFrameworkOldConfigHolder.getInstances()) {
                if (!holder.getFrameworkType().equals(frameworkType)) continue;
                holder.removeAllConfigurations(this.myProject);
            }
            if (configurations.isEmpty()) {
                this.myState.removeConfigurations(frameworkType.getID());
            } else {
                this.myState.setConfigurationsByKey(frameworkType.getID(), configurations);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkSettingsManager$PhpTestFrameworkProjectSettingsManager";
                    break;
                }
                case 3: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frameworkType";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkSettingsManager$PhpTestFrameworkProjectSettingsManager";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFrameworks";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstance";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getLocalConfig";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigurations";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setConfigurations";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @State(name="PhpTestFrameworkSettings", storages={@Storage(value="php-test-framework.xml")})
    public static class PhpTestFrameworkApplicationSettingsManager
    extends PhpTestFrameworkBaseSettingsManager {
        public static PhpTestFrameworkApplicationSettingsManager getInstance() {
            return (PhpTestFrameworkApplicationSettingsManager)ApplicationManager.getApplication().getService(PhpTestFrameworkApplicationSettingsManager.class);
        }

        @Override
        @NotNull
        public List<PhpTestFrameworkConfiguration> getConfigurations(@NotNull PhpTestFrameworkType frameworkType) {
            if (frameworkType == null) {
                PhpTestFrameworkApplicationSettingsManager.$$$reportNull$$$0(0);
            }
            List<PhpTestFrameworkConfiguration> list = this.myState.getConfigurationsByKey(frameworkType.getID());
            if (list == null) {
                PhpTestFrameworkApplicationSettingsManager.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        public void setConfigurations(@NotNull PhpTestFrameworkType frameworkType, @NotNull List<PhpTestFrameworkConfiguration> configurations) {
            if (frameworkType == null) {
                PhpTestFrameworkApplicationSettingsManager.$$$reportNull$$$0(2);
            }
            if (configurations == null) {
                PhpTestFrameworkApplicationSettingsManager.$$$reportNull$$$0(3);
            }
            if (configurations.isEmpty()) {
                this.myState.removeConfigurations(frameworkType.getID());
            } else {
                this.myState.setConfigurationsByKey(frameworkType.getID(), configurations);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frameworkType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkSettingsManager$PhpTestFrameworkApplicationSettingsManager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkSettingsManager$PhpTestFrameworkApplicationSettingsManager";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigurations";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setConfigurations";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

