/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.configData.ComposerConfigClient;
import com.jetbrains.php.composer.configData.PackageComposerConfigClient;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkSettingsManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import com.jetbrains.php.testFramework.run.PhpTestRunConfiguration;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationSettings;
import com.jetbrains.php.testFramework.run.PhpTestRunnerSettings;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpTestFrameworkComposerConfig
extends PackageComposerConfigClient {
    private final PhpTestFrameworkType myFrameworkType;

    public PhpTestFrameworkComposerConfig(@NotNull PhpTestFrameworkType frameworkType, @NotNull String frameworkPackage, @NotNull String relativePath) {
        if (frameworkType == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(0);
        }
        if (frameworkPackage == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(1);
        }
        if (relativePath == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(2);
        }
        super(frameworkPackage, relativePath);
        this.myFrameworkType = frameworkType;
    }

    @Override
    public void updateSettings(@NotNull Project project, @Nullable PhpInterpreter interpreter) {
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(3);
        }
        this.updateSettings(project, interpreter, true);
    }

    @Nullable
    public PhpTestFrameworkConfiguration updateSettings(@NotNull Project project, @Nullable PhpInterpreter interpreter, boolean withRunConfig) {
        PhpTestFrameworkConfiguration configuration;
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(4);
        }
        if ((configuration = PhpTestFrameworkSettingsManager.getInstance(project).getConfigByInterpreter(this.myFrameworkType, interpreter)) == null || StringUtil.isEmpty((String)configuration.getExecutablePath())) {
            String executable = this.findFromComposerVendor(project);
            if (StringUtil.isEmpty((String)executable) || !FileUtil.exists((String)executable)) {
                return null;
            }
            PhpTestFrameworkConfiguration newConfig = PhpTestFrameworkSettingsManager.getInstance(project).getOrCreateByInterpreter(this.myFrameworkType, interpreter);
            newConfig.setExecutablePath(interpreter == null || !interpreter.isRemote() ? PathUtil.toSystemDependentName((String)executable) : executable);
            this.updateRunConfigurations(project, newConfig, withRunConfig);
            this.notify(project, newConfig);
            return newConfig;
        }
        return null;
    }

    protected void updateRunConfigurations(@NotNull Project project, @NotNull PhpTestFrameworkConfiguration configuration, boolean withRunConfig) {
        VirtualFile file;
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(6);
        }
        if ((file = VfsUtil.findRelativeFile((VirtualFile)project.getBaseDir(), (String[])new String[]{FileUtil.toCanonicalPath((String)this.getDefaultConfigName())})) == null) {
            file = VfsUtil.findRelativeFile((VirtualFile)project.getBaseDir(), (String[])new String[]{FileUtil.toCanonicalPath((String)(this.getDefaultConfigName() + ".dist"))});
        }
        if (file == null) {
            return;
        }
        this.updateByConfigurationFile(project, configuration, file);
        if (withRunConfig) {
            ConfigurationFactory[] factories = this.getConfigurationType().getConfigurationFactories();
            if (factories == null || factories.length != 1) {
                return;
            }
            RunManager runManager = RunManager.getInstance((Project)project);
            RunnerAndConfigurationSettings settings = runManager.createConfiguration(file.getName(), factories[0]);
            PhpTestRunnerSettings testRunnerSettings = ((PhpTestRunConfigurationSettings)((PhpTestRunConfiguration)settings.getConfiguration()).getSettings()).getRunnerSettings();
            testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.ConfigurationFile);
            runManager.addConfiguration(settings);
        }
    }

    protected void updateByConfigurationFile(@NotNull Project project, @NotNull PhpTestFrameworkConfiguration configuration, @NotNull VirtualFile file) {
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(8);
        }
        if (file == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(9);
        }
        configuration.setUseConfigurationFile(true);
        configuration.setConfigurationFilePath(file.getPath());
    }

    @NotNull
    public Collection<String> getTestRoots(@NotNull Project project) {
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(10);
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    protected abstract String getDefaultConfigName();

    @NotNull
    protected abstract ConfigurationType getConfigurationType();

    protected void notify(@NotNull Project project, @NotNull PhpTestFrameworkConfiguration newConfig) {
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(12);
        }
        if (newConfig == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(13);
        }
        this.notify(project, newConfig.getFrameworkType().getDisplayName(), ComposerLogMessageBuilder.Settings.TEST_FRAMEWORKS);
    }

    @Nullable
    public static PhpTestFrameworkComposerConfig getTestFrameworkComposerConfig(PhpTestFrameworkType frameworkType) {
        for (ComposerConfigClient client : (ComposerConfigClient[])EP_NAME.getExtensions()) {
            PhpTestFrameworkComposerConfig config = (PhpTestFrameworkComposerConfig)ObjectUtils.tryCast((Object)client, PhpTestFrameworkComposerConfig.class);
            if (config == null || config.myFrameworkType != frameworkType) continue;
            return config;
        }
        return null;
    }

    @NotNull
    public static Collection<PhpTestFrameworkComposerConfig> getTestExtensions() {
        List list = StreamEx.of((Object[])((ComposerConfigClient[])ComposerConfigClient.EP_NAME.getExtensions())).select(PhpTestFrameworkComposerConfig.class).toList();
        if (list == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    @Nullable
    public ComposerLogMessageBuilder.Settings getSettings() {
        return ComposerLogMessageBuilder.Settings.TEST_FRAMEWORKS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkPackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkComposerConfig";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkComposerConfig";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRoots";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateRunConfigurations";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateByConfigurationFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTestRoots";
                break;
            }
            case 11: 
            case 14: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

