/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreterComboBox;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.testFramework.PhpTestFrameworkBySdkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTestFrameworkBySdkDialog
extends DialogWrapper {
    protected Project myProject;
    protected List<PhpTestFrameworkBySdkConfiguration> myExistingConfigurations;
    private final String myFrameworkName;
    protected PhpInterpreterComboBox myComboBox;

    protected PhpTestFrameworkBySdkDialog(@Nullable Project project, @NotNull String frameworkName, @NotNull List<PhpTestFrameworkConfiguration> configurations) {
        if (frameworkName == null) {
            PhpTestFrameworkBySdkDialog.$$$reportNull$$$0(0);
        }
        if (configurations == null) {
            PhpTestFrameworkBySdkDialog.$$$reportNull$$$0(1);
        }
        super(project, false);
        this.myProject = project;
        this.myExistingConfigurations = new ArrayList<PhpTestFrameworkBySdkConfiguration>();
        this.myFrameworkName = frameworkName;
        for (PhpTestFrameworkConfiguration configuration : configurations) {
            this.filterConfigurations(configuration);
        }
        this.setTitle(PhpBundle.message("php.test.framework.by.sdk.new.settings.dialog.title", frameworkName));
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.initComboBox();
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myComboBox);
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.anchor = 18;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.gridy = 0;
        JLabel label = new JLabel(this.getLabelText());
        panel2.add((Component)label, gc);
        gc.weightx = 1.0;
        ++gc.gridx;
        this.myComboBox.setPreferredSize(new Dimension(200, this.myComboBox.getPreferredSize().height));
        label.setLabelFor((Component)((Object)this.myComboBox));
        panel2.add((Component)((Object)this.myComboBox), gc);
        Font font = this.myComboBox.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.myComboBox.getFontMetrics(font);
            int width = fontMetrics.charWidth('a') * 60;
            panel2.setPreferredSize(new Dimension(width, 50));
        }
        return panel2;
    }

    protected void initComboBox() {
        this.myComboBox = new PhpInterpreterComboBox(this.myProject, (Condition<? super PhpSdkAdditionalData>)((Condition)data -> data instanceof RemoteSdkAdditionalData));
        this.myComboBox.reset();
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myComboBox);
    }

    protected void filterConfigurations(@NotNull PhpTestFrameworkConfiguration configuration) {
        if (configuration == null) {
            PhpTestFrameworkBySdkDialog.$$$reportNull$$$0(2);
        }
        if (configuration instanceof PhpTestFrameworkBySdkConfiguration) {
            this.myExistingConfigurations.add((PhpTestFrameworkBySdkConfiguration)configuration);
        }
    }

    @Nls
    protected String getLabelText() {
        return PhpBundle.message("php.test.framework.by.sdk.dialog.label", new Object[0]);
    }

    @Nullable
    public String getSelectedInterpreterName() {
        return this.myComboBox.getSelectedItemName();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance(this.myProject);
        PhpSdkAdditionalData data = manager.findInterpreterDataById(manager.findInterpreterId(this.myComboBox.getSelectedItemName()));
        if (!(data instanceof RemoteSdkAdditionalData)) {
            return new ValidationInfo(PhpBundle.message("php.test.framework.by.sdk.settings.select.server", this.myFrameworkName), (JComponent)((Object)this.myComboBox));
        }
        for (PhpTestFrameworkBySdkConfiguration configuration : this.myExistingConfigurations) {
            String name = PhpInterpretersManagerImpl.getInstance(this.myProject).findInterpreterName(configuration.getInterpreterId());
            if (!StringUtil.equals((CharSequence)this.myComboBox.getSelectedItemName(), (CharSequence)name)) continue;
            return new ValidationInfo(PhpBundle.message("php.test.framework.by.sdk.settings.already.exist", this.myFrameworkName), (JComponent)((Object)this.myComboBox));
        }
        return super.doValidate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkBySdkDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "filterConfigurations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

