/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.surroundWith.inHtml;

import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpInHtmlSurrounderBase
implements Surrounder {
    protected static final String PLACEHOLDER = "#BODY#";
    protected static final String CARET_PLACEHOLDER = "$caret";

    public boolean isApplicable(PsiElement @NotNull [] elements) {
        if (elements == null) {
            PhpInHtmlSurrounderBase.$$$reportNull$$$0(0);
        }
        for (PsiElement e : elements) {
            if (e.isValid() && e.getContainingFile() instanceof XmlFile && !(e instanceof OuterLanguageElement)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, PsiElement @NotNull [] elements) throws IncorrectOperationException {
        if (project == null) {
            PhpInHtmlSurrounderBase.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            PhpInHtmlSurrounderBase.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            PhpInHtmlSurrounderBase.$$$reportNull$$$0(3);
        }
        if (elements.length > 0) {
            PsiElement firstElement = elements[0];
            PsiElement lastElement = elements[elements.length - 1];
            Object template = this.getTemplate();
            if (!(firstElement instanceof XmlTag) || !(lastElement instanceof XmlTag)) {
                PsiElement next;
                template = ((String)template).replace("\n", "");
                PsiElement prev = firstElement.getPrevSibling();
                if (PhpPsiUtil.isOfType(prev, XmlTokenType.XML_TAG_END)) {
                    template = "\n" + (String)template;
                }
                if (PhpPsiUtil.isOfType(next = lastElement.getNextSibling(), XmlTokenType.XML_END_TAG_START)) {
                    template = (String)template + "\n";
                }
            }
            int rangeStart = firstElement.getTextRange().getStartOffset();
            int rangeEnd = lastElement.getTextRange().getEndOffset();
            TextRange result = new TextRange(rangeStart, rangeEnd);
            int templateLength = ((String)template).length() - PLACEHOLDER.length();
            CharSequence original2 = editor.getDocument().getCharsSequence().subSequence(rangeStart, rangeEnd);
            template = ((String)template).replace(PLACEHOLDER, original2);
            RangeMarker caretMarker = null;
            int caretOffset = ((String)template).indexOf(CARET_PLACEHOLDER);
            if (caretOffset >= 0) {
                templateLength -= CARET_PLACEHOLDER.length();
                template = ((String)template).replace(CARET_PLACEHOLDER, "");
            }
            editor.getDocument().replaceString(rangeStart, rangeEnd, (CharSequence)template);
            if (caretOffset >= 0) {
                caretMarker = editor.getDocument().createRangeMarker(rangeStart, rangeStart + caretOffset);
            }
            result = result.grown(templateLength);
            RangeMarker marker = editor.getDocument().createRangeMarker(result.getStartOffset(), result.getEndOffset());
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file != null) {
                CodeStyleManager.getInstance((Project)project).reformatText(file, marker.getStartOffset(), marker.getEndOffset());
            }
            result = new TextRange(marker.getStartOffset(), marker.getEndOffset());
            marker.dispose();
            if (caretMarker != null) {
                TextRange caretRange = new TextRange(caretMarker.getEndOffset(), caretMarker.getEndOffset());
                caretMarker.dispose();
                return caretRange;
            }
            return result;
        }
        return null;
    }

    protected abstract String getTemplate();

    protected static Surrounder createSurrounder(final @NotNull @NlsSafe String templateDescription, final @NotNull String templateText) {
        if (templateDescription == null) {
            PhpInHtmlSurrounderBase.$$$reportNull$$$0(4);
        }
        if (templateText == null) {
            PhpInHtmlSurrounderBase.$$$reportNull$$$0(5);
        }
        return new PhpInHtmlSurrounderBase(){

            @Override
            protected String getTemplate() {
                return templateText;
            }

            public String getTemplateDescription() {
                return templateDescription;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateDescription";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateText";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/surroundWith/inHtml/PhpInHtmlSurrounderBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "surroundElements";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createSurrounder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

