/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.surroundWith;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.completion.autoImport.PhpAutoImportConfiguration;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpThrownExceptionsAnalyzer;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import com.jetbrains.php.surroundWith.PhpStatementSurrounder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTryCatchSurrounder
extends PhpStatementSurrounder<Try> {
    @NlsSafe
    private static final String TRY_CATCH = "try / catch";

    @Override
    protected String getStatementTemplate(Project project, PsiElement[] elements) {
        SmartList exceptions = new SmartList();
        PsiElement firstElement = elements[0];
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder(firstElement);
        if (scopeHolder != null) {
            PsiElement lastElement = elements[elements.length - 1];
            TextRange range = TextRange.create((int)firstElement.getTextOffset(), (int)(lastElement.getTextOffset() + lastElement.getTextLength()));
            Set<PhpType> exceptionClasses = PhpThrownExceptionsAnalyzer.getExceptionClasses(scopeHolder, range);
            for (PhpType exceptionClass : PhpTryCatchSurrounder.sortByHierarchy(new ArrayList<PhpType>(exceptionClasses), project)) {
                exceptions.add((String)ContainerUtil.getFirstItem((Collection)exceptionClass.getTypes()));
            }
        }
        if (exceptions.isEmpty()) {
            exceptions.add("\\Exception");
        }
        StringBuilder template = new StringBuilder("try{}");
        for (String exception2 : exceptions) {
            template.append("catch(").append(exception2).append(" $e){}");
        }
        return template.toString();
    }

    @NotNull
    public static List<PhpType> sortByHierarchy(@NotNull List<PhpType> exceptionClasses, @NotNull Project project) {
        if (exceptionClasses == null) {
            PhpTryCatchSurrounder.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PhpTryCatchSurrounder.$$$reportNull$$$0(1);
        }
        return PhpTryCatchSurrounder.sortByHierarchy(exceptionClasses, Function.identity(), project);
    }

    @NotNull
    public static <T> List<T> sortByHierarchy(@NotNull List<T> exceptionClasses, @NotNull Function<? super T, ? extends PhpType> keyExtractor, @NotNull Project project) {
        if (exceptionClasses == null) {
            PhpTryCatchSurrounder.$$$reportNull$$$0(2);
        }
        if (keyExtractor == null) {
            PhpTryCatchSurrounder.$$$reportNull$$$0(3);
        }
        if (project == null) {
            PhpTryCatchSurrounder.$$$reportNull$$$0(4);
        }
        PhpIndex index = PhpIndex.getInstance((Project)project);
        exceptionClasses.sort(Comparator.comparing(key -> (String)ContainerUtil.getFirstItem((Collection)((PhpType)keyExtractor.apply(key)).getTypes())));
        block0: for (int i = 1; i < exceptionClasses.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                PhpType outer = keyExtractor.apply(exceptionClasses.get(i));
                PhpType inner = keyExtractor.apply(exceptionClasses.get(j));
                if (!ContainerUtil.exists((Iterable)inner.getTypes(), my -> ContainerUtil.exists((Iterable)outer.getTypes(), other -> PhpType.findSuper((String)my, (String)other, (PhpIndex)index)))) continue;
                exceptionClasses.add(j, exceptionClasses.remove(i));
                continue block0;
            }
        }
        List<T> list = exceptionClasses;
        if (list == null) {
            PhpTryCatchSurrounder.$$$reportNull$$$0(5);
        }
        return list;
    }

    public static String createQualifiedName(@Nullable PhpPsiElement scopeForUse, @Nullable String fqn) {
        return scopeForUse != null && fqn != null ? PhpCodeInsightUtil.createQualifiedName(scopeForUse, fqn) : fqn;
    }

    @Override
    protected PsiElement getInsertInto(Try tryStatement2) {
        return tryStatement2.getStatement();
    }

    @Override
    protected void postProcess(Try tryStatement2) {
        PhpTryCatchSurrounder.importClassReferences(tryStatement2, Arrays.asList(tryStatement2.getCatchClauses()));
    }

    public static void importClassReferences(@NotNull Try tryStatement2, @NotNull Collection<? extends Catch> catchClauses) {
        if (tryStatement2 == null) {
            PhpTryCatchSurrounder.$$$reportNull$$$0(6);
        }
        if (catchClauses == null) {
            PhpTryCatchSurrounder.$$$reportNull$$$0(7);
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)tryStatement2);
        boolean autoImport = PhpCodeInsightUtil.isAutoImportEnabled(scope);
        PhpAutoImportConfiguration.State config = PhpAutoImportConfiguration.getInstance().getState();
        for (Catch catch_ : catchClauses) {
            for (ClassReference classReference : catch_.getExceptionTypes()) {
                String referenceText = classReference.getText();
                String qualifiedName = PhpTryCatchSurrounder.createQualifiedName(scope, referenceText);
                if (autoImport && PhpLangUtil.isFqn(qualifiedName) && (!PhpLangUtil.isGlobalNamespaceFQN(PhpLangUtil.getParentNamespaceFQN(referenceText)) || config.getGlobalClassBehavior() == PhpAutoImportConfiguration.GlobalSymbolBehavior.PREFER_IMPORT) && !PhpCodeInsightUtil.hasNameConflicts(scope, referenceText, PhpCodeInsightUtil.ImportElementType.CLASS)) {
                    PhpAliasImporter.insertUseStatement(referenceText, scope);
                    classReference.getFirstChild().delete();
                    continue;
                }
                if (PhpLangUtil.isFqn(qualifiedName)) continue;
                classReference.replace((PsiElement)PhpPsiElementFactory.createClassReference(tryStatement2.getProject(), qualifiedName));
            }
        }
    }

    @Override
    protected TextRange getSurroundSelectionRange(Try tryStatement2) {
        Statement body = tryStatement2.getStatement();
        assert (body != null);
        Catch catchStatement = (Catch)body.getNextPsiSibling();
        assert (catchStatement != null);
        PhpPsiElement exType = (PhpPsiElement)ContainerUtil.getFirstItem((Collection)catchStatement.getExceptionTypes());
        assert (exType != null);
        return TextRange.from((int)exType.getTextOffset(), (int)0);
    }

    public String getTemplateDescription() {
        return TRY_CATCH;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClasses";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyExtractor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/surroundWith/PhpTryCatchSurrounder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchClauses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/surroundWith/PhpTryCatchSurrounder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sortByHierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sortByHierarchy";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "importClassReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

