/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.surroundWith;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.surroundWith.PhpStatementSurrounder;
import org.jetbrains.annotations.NotNull;

public class PhpFunctionSurrounder
extends PhpStatementSurrounder<Function> {
    @NlsSafe
    private static final String FUNCTION = "function";

    @Override
    protected String getStatementTemplate(Project project, PsiElement[] elements) {
        return "function f(){}";
    }

    @Override
    @NotNull
    protected Function createStatement(@NotNull Project project, PsiElement @NotNull [] elements) {
        if (project == null) {
            PhpFunctionSurrounder.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            PhpFunctionSurrounder.$$$reportNull$$$0(1);
        }
        Function function = PhpPsiElementFactory.createFunction(project, this.getStatementTemplate(project, elements));
        if (function == null) {
            PhpFunctionSurrounder.$$$reportNull$$$0(2);
        }
        return function;
    }

    @Override
    protected PsiElement getInsertInto(Function f) {
        return PhpFunctionSurrounder.getStatement(f);
    }

    @Override
    protected TextRange getSurroundSelectionRange(Function f) {
        PsiElement identifier = PhpFunctionSurrounder.getIdentifier(f);
        int offset = PhpFunctionSurrounder.getIdentifier(f).getTextOffset();
        identifier.delete();
        return TextRange.from((int)offset, (int)0);
    }

    public String getTemplateDescription() {
        return FUNCTION;
    }

    @NotNull
    private static PsiElement getStatement(Function f) {
        for (PsiElement e = f.getLastChild(); e != null; e = e.getPrevSibling()) {
            if (!PhpElementTypes.ANY_GROUP_STATEMENT.contains(e.getNode().getElementType())) continue;
            PsiElement psiElement = e;
            if (psiElement == null) {
                PhpFunctionSurrounder.$$$reportNull$$$0(3);
            }
            return psiElement;
        }
        throw new IllegalStateException("Statement has not been found");
    }

    @NotNull
    private static PsiElement getIdentifier(Function f) {
        for (PsiElement e = f.getFirstChild(); e != null; e = e.getNextSibling()) {
            if (!PhpPsiUtil.isOfType(e, PhpTokenTypes.IDENTIFIER)) continue;
            PsiElement psiElement = e;
            if (psiElement == null) {
                PhpFunctionSurrounder.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        throw new IllegalStateException("Identifier has not been found");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/surroundWith/PhpFunctionSurrounder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/surroundWith/PhpFunctionSurrounder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStatement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

