/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.structureView;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.ui.IconManager;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Include;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.structureView.PhpNaturalOrderSorter;
import com.jetbrains.php.structureView.PhpVisibilityComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpStructureViewTreeElement
extends PsiTreeElementBase<PsiElement>
implements StructureViewTreeElement,
PhpVisibilityComparator.AccessLevelSortOrderProvider {
    private final PsiElement myElement;
    private final ItemPresentation myPresentation;
    private final boolean myInherited;
    private static final TextAttributes INHERITED_MEMBER_TEXT = SimpleTextAttributes.GRAYED_ATTRIBUTES.toTextAttributes();
    public static final TextAttributesKey INHERITED_MEMBER = TextAttributesKey.createTextAttributesKey((String)"PHP_INHERITED_MEMBER", (TextAttributes)INHERITED_MEMBER_TEXT);

    public PhpStructureViewTreeElement(PsiElement psiElement, boolean isInherited) {
        super(psiElement);
        this.myElement = psiElement;
        this.myInherited = isInherited;
        this.myPresentation = PhpStructureViewTreeElement.createPresentation(this.myElement, (TextAttributesKey)(isInherited ? INHERITED_MEMBER : null));
        assert (this.myPresentation.getPresentableText() != null) : "PsiElement " + psiElement + " doesn't have any presentable text";
    }

    public PhpStructureViewTreeElement(PsiElement psiElement) {
        this(psiElement, false);
    }

    @Nullable
    public PsiElement getValue() {
        return this.myElement.isValid() ? this.myElement : null;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation itemPresentation = this.myPresentation;
        if (itemPresentation == null) {
            PhpStructureViewTreeElement.$$$reportNull$$$0(0);
        }
        return itemPresentation;
    }

    private static TextAttributesKey getDeprecatedAttributes(PsiElement myElement) {
        if (myElement instanceof PhpNamedElement && PhpNamedElementImpl.getDeprecatedSinceVersion((PhpNamedElement)myElement) != null) {
            return CodeInsightColors.DEPRECATED_ATTRIBUTES;
        }
        return null;
    }

    @NotNull
    public static PresentationData createPresentation(PsiElement myElement, TextAttributesKey textAttrsKey) {
        TextAttributesKey deprecatedAttributes = PhpStructureViewTreeElement.getDeprecatedAttributes(myElement);
        if (deprecatedAttributes != null) {
            textAttrsKey = deprecatedAttributes;
        }
        if (myElement instanceof PhpFile) {
            PresentationData presentationData = PhpPresentationUtil.getFilePresentation((PhpFile)myElement);
            if (presentationData == null) {
                PhpStructureViewTreeElement.$$$reportNull$$$0(1);
            }
            return presentationData;
        }
        if (myElement instanceof PhpNamespace) {
            PresentationData presentation = PhpPresentationUtil.getNamespacePresentation((PhpNamespace)myElement);
            presentation.setLocationString(null);
            PresentationData presentationData = presentation;
            if (presentationData == null) {
                PhpStructureViewTreeElement.$$$reportNull$$$0(2);
            }
            return presentationData;
        }
        if (myElement instanceof PhpClass) {
            PhpClass phpClass = (PhpClass)myElement;
            String className = phpClass.getName();
            Icon classIcon = phpClass.getIcon();
            return new PresentationData(className, null, classIcon, textAttrsKey);
        }
        if (myElement instanceof Method) {
            Method e = (Method)myElement;
            return new PresentationData(PhpPresentationUtil.formatFunction((Function)e), null, e.getIcon(), textAttrsKey);
        }
        if (myElement instanceof Field) {
            Field field = (Field)myElement;
            StringBuilder builder = new StringBuilder().append(field.getName());
            PhpPresentationUtil.formatType(builder, (PhpNamedElement)field);
            PhpPresentationUtil.appendDefaultValue(builder, field.getDefaultValuePresentation());
            return new PresentationData(builder.toString(), null, field.getIcon(), textAttrsKey);
        }
        if (myElement instanceof Function) {
            Function function = (Function)myElement;
            RowIcon rowIcon = IconManager.getInstance().createRowIcon(2);
            rowIcon.setIcon(function.getIcon(), 0);
            rowIcon.setIcon(PhpPresentationUtil.getAccessIcon(PhpModifier.Access.PUBLIC), 1);
            return new PresentationData(PhpPresentationUtil.formatFunction(function), null, (Icon)rowIcon, textAttrsKey);
        }
        if (myElement instanceof Constant) {
            Constant e = (Constant)myElement;
            StringBuilder b = new StringBuilder().append(e.getName());
            PhpPresentationUtil.formatType(b, (PhpNamedElement)e);
            PhpPresentationUtil.appendDefaultValue(b, e.getValuePresentation());
            return new PresentationData(b.toString(), null, e.getIcon(), textAttrsKey);
        }
        if (myElement instanceof Include) {
            Include e = (Include)myElement;
            StringBuilder b = new StringBuilder();
            Icon icon = e.getIcon();
            try {
                String name = e.getFileName();
                if (name != null) {
                    b.append(name);
                } else {
                    b.append(e.getArgument().getText());
                }
            }
            catch (IndexNotReadyException ex) {
                b.append("Resolving...");
                icon = PhpIcons.WAITING;
            }
            catch (Exception otherEx) {
                b.append("?");
            }
            return new PresentationData(b.toString(), null, icon, null);
        }
        return new PresentationData(myElement.getText(), null, null, null);
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        if (!this.myElement.isValid() || this.myElement instanceof Function) {
            Set<StructureViewTreeElement> set = Collections.emptySet();
            if (set == null) {
                PhpStructureViewTreeElement.$$$reportNull$$$0(3);
            }
            return set;
        }
        ArrayList<StructureViewTreeElement> children = new ArrayList<StructureViewTreeElement>();
        PhpStructureViewTreeElement.collectChildren(children, this.myElement);
        ContainerUtil.sort(children, (Comparator)PhpNaturalOrderSorter.INSTANCE.getComparator());
        ArrayList<StructureViewTreeElement> arrayList = children;
        if (arrayList == null) {
            PhpStructureViewTreeElement.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static void collectChildren(@NotNull List<StructureViewTreeElement> result, @NotNull PsiElement myElement) {
        block14: {
            block13: {
                Field[] fields;
                Method[] methods;
                if (result == null) {
                    PhpStructureViewTreeElement.$$$reportNull$$$0(5);
                }
                if (myElement == null) {
                    PhpStructureViewTreeElement.$$$reportNull$$$0(6);
                }
                if (!(myElement instanceof PhpClass)) break block13;
                for (Method method : methods = ((PhpClass)myElement).getOwnMethods()) {
                    boolean isOwnMethod;
                    PhpClass containingClass = method.getContainingClass();
                    boolean bl = isOwnMethod = containingClass == myElement;
                    if (containingClass == null || PhpLangUtil.isObject(containingClass)) continue;
                    result.add(new PhpStructureViewTreeElement((PsiElement)method, !isOwnMethod));
                }
                for (Field field : fields = ((PhpClass)myElement).getOwnFields()) {
                    PsiElement parent;
                    PhpClass containingClass = field.getContainingClass();
                    if (containingClass == null || PhpLangUtil.isObject(containingClass) || (parent = field.getParent()) == null || parent instanceof FieldReference) continue;
                    boolean isOwnField = containingClass == myElement;
                    result.add(new PhpStructureViewTreeElement((PsiElement)field, !isOwnField));
                }
                break block14;
            }
            PsiElement[] children = myElement.getChildren();
            if (children.length == 0) {
                return;
            }
            ArrayList<PhpNamespace> namespaces = null;
            for (PsiElement child : children) {
                if (child instanceof PhpNamespace) {
                    if (namespaces == null) {
                        namespaces = new ArrayList<PhpNamespace>();
                    }
                    namespaces.add((PhpNamespace)child);
                    continue;
                }
                if (child instanceof PhpNamedElement) {
                    if (!(child instanceof PhpFile) && (!(child instanceof Function) || child instanceof Method) && !(child instanceof Constant) && !(child instanceof PhpClass)) continue;
                    result.add(new PhpStructureViewTreeElement(child));
                    continue;
                }
                if (child instanceof Include) {
                    result.add(new PhpStructureViewTreeElement(child));
                    continue;
                }
                if (child instanceof PhpExpression && !(child instanceof AssignmentExpression)) continue;
                PhpStructureViewTreeElement.collectChildren(result, child);
            }
            if (namespaces == null) break block14;
            if (namespaces.size() == 1) {
                PhpStructureViewTreeElement.collectChildren(result, (PsiElement)namespaces.get(0));
            } else {
                for (PhpNamespace namespace : namespaces) {
                    result.add(new PhpStructureViewTreeElement((PsiElement)namespace));
                }
            }
        }
    }

    public void navigate(boolean requestFocus) {
        if (this.myElement instanceof Include && requestFocus) {
            PsiReference[] refs;
            Include include = (Include)this.myElement;
            for (PsiReference ref : refs = include.getReferences()) {
                PsiElement item = ref.resolve();
                if (!(item instanceof PhpFile)) continue;
                NavigationUtil.activateFileWithPsiElement((PsiElement)((PhpFile)item).getOriginalFile());
                return;
            }
        }
        ((Navigatable)this.myElement).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return ((Navigatable)this.myElement).canNavigate();
    }

    public boolean canNavigateToSource() {
        return ((Navigatable)this.myElement).canNavigateToSource();
    }

    public boolean isInherited() {
        return this.myInherited;
    }

    @Override
    public int getAccessLevelSortOrder() {
        if (this.myElement instanceof Field) {
            Field field = (Field)this.myElement;
            return PhpStructureViewTreeElement.modifierToAccessLevelSortOrder(field.getModifier());
        }
        if (this.myElement instanceof Method) {
            Method method = (Method)this.myElement;
            return PhpStructureViewTreeElement.modifierToAccessLevelSortOrder(method.getModifier());
        }
        return -1;
    }

    private static int modifierToAccessLevelSortOrder(@NotNull PhpModifier modifier) {
        if (modifier == null) {
            PhpStructureViewTreeElement.$$$reportNull$$$0(7);
        }
        if (modifier.isPublic()) {
            return 2;
        }
        if (modifier.isProtected()) {
            return 1;
        }
        if (modifier.isPrivate()) {
            return 0;
        }
        return -1;
    }

    public int getMemberKindWeight() {
        if (this.myElement instanceof Include) {
            return 5;
        }
        if (this.myElement instanceof Constant) {
            return 10;
        }
        if (this.myElement instanceof Field) {
            if (((Field)this.myElement).isConstant()) {
                return 10;
            }
            return 20;
        }
        return 1000;
    }

    public PsiElement getPsiElement() {
        return this.myElement;
    }

    @Nullable
    public String getPresentableText() {
        return ((PhpNamedElement)this.myElement).getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/structureView/PhpStructureViewTreeElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenBase";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/structureView/PhpStructureViewTreeElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectChildren";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "modifierToAccessLevelSortOrder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

